#!/boot/home/config/bin/perl

# BeClueCat v 1.2
# originally based on Kevin Fowlks' CueCat reader
#
# GPL, Ted Stodgell, kart@hal-pc.org

# use MIME::Base64 qw(MagicDecode);  # not part of the stock BeOS Perl package
                                     # uncomment and use it if you want.

sub GetClue($){ 
  $value=@_[0];                      # split into 3 chunks at the .'s
  @v=split /\./,$value;

  #print "v[1]  = $v[1]\n";          # your big brother ID (we ignore this)
  #print "v[2]  = $v[2]\n";          # barcode type
  #print "v[3]  = $v[3]\n\n";        # the barcode itself
           
  $type="($v[2]) not recognized";
  if ($v[2] eq 'cGf2') {$type="ISBN";}
  if ($v[2] eq 'fHmc') {$type="UPC";}
  if ($v[2] eq 'fHmg') {$type="UPC";}
  if ($v[2] eq 'fGjX') {$type="magazine";}
  if ($v[2] eq 'fGj2') {$type="Try scanning the inside cover instead.";}
  if ($v[2] eq 'aabI') {$type="CueCat";} 
  if ($v[2] eq 'CNf7') {$type="might be a US drivers license";} 
  if ($v[2] eq 'ahb6') {$type="ID Badge or Library Card";} 
  if ($v[2] eq 'aaer') {$type="this might be a Seattle public library card";} 
  
  $v[3] =~ tr|A-Za-z\-|a-zA-Z/|;  # swap upper and lower case, change + to /
  
  $unbase = "";
  $unbase = MagicDecode($v[3]);
    
  $decode = "";
  for ($i=0;$i<length($unbase);$i++){
    $c = substr($unbase,$i,1);
    $decode = $decode . chr(ord($c) ^ 67); # WARNING: Strong Crypto ;-)
  } 
   
  if ($type eq 'ISBN') { CheckISBN($decode); }
  print "\n      barcode type   = $type\n";
  print "      barcode value  = $decode\n";  

  if ($type eq 'ISBN') {
    my $url = "http://www.amazon.com/exec/obidos/ASIN/$decode";
    print "      amazon url     = $url\n";
    system("/boot/beos/apps/NetPositive $url/&");
  }

  if ($type eq "might be a US drivers license"){
	my $dl = substr($decode,1,12);
	my $bdate = substr($decode,13,4);
	my $exd = substr($decode,17,6);
  	print "      DL#            = $dl\n";
	print "      birthdate      = $bdate\n";
	print "      exp. date      = $exd\n";
  }

  return 0;
}

# Comment out this sub if you happen to have MIME::base64
sub MagicDecode($){
  my $str = shift;
  my $res = "";
  $str =~ tr|A-Za-z0-9+/| -_|;
  my $len .= chr(32+length($str)*3/4);
  $res .= unpack("u", $len . $str);
  return $res;
}

# Make an ISBN checkdigit with the first 9 digits of an ISBN number
sub CheckISBN($){
  $value = @_[0];
  
  $sum="";$sss="";$ss="";$isbn="";
  #drop the first 3 digits.  i dunno why, but you gotta do this for it to work :P
  my $isbn = substr($value,3,9);
  #print "isbn   = $isbn\n";
  for ($i = 0; $i < 9; $i++){  # only look at the first 9 digits
    $sum = (10-$i);
    $sss= $sum *  substr($isbn,$i,1);
    $ss=$ss+$sss;
    $sum = (11-($ss %  11));
  }
  if  ($sum == 10) { $sum='X'; } # if the checkdigit is a 10, replace
                                 # it with 'X'
  #print "sum    = $sum\n";
  $decode = $isbn . $sum;
  return 0;
}


sub Menu(){
  print "\033\133\110\033\133\062\112";
  print "\e[0;37;44m+-----------------------------<\e[0;30;47m \e[4m\e[1;34;47mB\e[1;31;47me\e[0;30;47mClueCat v1.2 \e[0;37;44m>-------------------------------+\e[m\n";
  print "\e[0;37;44m|    q = quit                                                                  |\e[m\n";
  print "\e[0;37;44m|    u = check for updates                 Scan a barcode at the \e[m\e[1;31m>\e[0;37;44m prompt.     |\e[m\n";
  print "\e[0;37;44m+------------------------------------------------------------------------------+\e[m\n";
}

# Main
Menu();
while(){
  print"\n \e[1;31m>\e[m ";
  $input = <STDIN>;
  chomp $input;
  if ($input eq 'q' or $input eq 'Q') { last; }
  if ($input eq 'u' or $input eq 'U') { system("/boot/beos/apps/NetPositive http://www.bebits.com/app/1537 &"); last; }
  GetClue($input);
}
