#!/usr/bin/perl

# If this module is not available, comment out this line and
# uncomment the decode_base64 function below
use MIME::Base64 qw(decode_base64);

sub decode_base64($);  # Declaration
sub CheckDigitISBN($); # Declaration
sub CueCatDecode($$);  # Declaration  
sub BarCodeType($);    # Declaration



# CueCat Decoder & ISBN Check Digit Maker For Perl
# Version 1.0.2  GPL
# All Code Here is free to use but must give credit 
# Written By Kevin Fowlks
# Updated By Gary Calvin added base64 & Xor decode
# http://www.barcode-search.com
# Aug 29,2000  




# If MIME::Base64 is not available, uncomment this code and comment
# out the statement above
#
#sub decode_base64($)
#{
#    my $str = shift;
#    my $res = "";
#    $str =~ tr|A-Za-z0-9+/| -_|;         # convert to uuencode format
#    my $len = chr(32+length($str)*3/4);  # compute length byte
#    $res .= unpack("u", $len . $str);    # uudecode
#    return $res;
#}

# Arg 1 is the Cuecat String and Arg 2 is the type
# e.g.Type Can be the Following  1 - (CuecatID) 2 - (Barcode Type) 3 - (Barcode) 
# Returns String of Barcode Based On Type

sub CueCatDecode($$)
{

    $value=$_[0];
    $s=$_[1];


    # Lets Split our CuCat String into a Array with all the differnt subsections
    @v=split /\./,$value;

    # Swap upper case to lower case and vice versa, minuses to slashes
    $code = $v[$s];
    $code =~ tr|A-Za-z\-|a-zA-Z/|;

    # Decode with base64
    $decode = decode_base64($code);

    # Take each character XOR 67
    $dc = "";
    for ($i=0;$i<length($decode);$i++)
    {
        $c = substr($decode,$i,1);
        $dc = $dc . chr(ord($c) ^ 67);
    }

    return $dc;

}

# Creates a ISBN Check Digit from the first 9 digits of an ISBN Number
# Arg-1 takes the first 9 digits of a barcode 
# Returns: Digit 
# Note: If digit is equal to 10 then replace with an X this is standard
sub CheckDigitISBN($)
{
        $value = $_[0];
        $sss=0;
	$ss=0;
	$sum=0;
        for ($i = 0; $i < 9; $i++)
        {
            $sum = (10-$i);
            $sss= $sum *  substr($value,$i,1);
            $ss=$ss+$sss;
            $sum = (11-($ss %  11));

        }
        return $sum;
}



sub BarCodeType($)
{

  if ($_[0] eq "cGf2") {$btype="ISBN";}
  else { $btype="UNKNOWN";}

  return  $btype;

}
return 1;
