/* the os checking in here uses queso style tcp fingerprinting, among
   other things */

/* IMPORTANT: global bufferz declared in here:
   response{} <- responses to queso style tcp flag queries
   *stringos <- string describing current os, used in registeros[]
   scripting function.
   telnetbanner[] <- buffer containing telnet banner of host.. used in
   os() macro and telnetbanner[] scripting lang function
 */

#include "sscan.h"
extern char *stringos;
extern char *telnetbanner;
extern struct response *responsez;

char *
checkos (u_long source, u_long dest, u_short port)
{

/* hack for pcap_next, put some data on the wire when SIGALRM recvd */
/* note: despite the obvious lameness of this handler, boxes with multiple
   inet devices might send packets out on the wrong device and fuq things */

  extern char *deviceglobal;
  struct p4ck3t
    {
      struct iphdr ip;
      struct tcphdr tcp;
      char data[2000];
    }
   *p4ck3t;
  int on = 1;
  int counter = 0;
  char fd;
  /* send our segments, incrementing the source port each time so that
     we know which packet is a response to which segment... */
  unsigned long int sourceport = 1, timev = 0, response_num = 0;
  char buf[2040];
  /* first get the telnet banner */
  if ((fd = telnetconnect (dest)) != -1)
    read (fd, telnetbanner, 96);
  install_alarm_handler (ALARM_PCAP);
  startpcap ();	/* start b4 sending in case we're doing localhost */
  /* number 1. */
  send_raw_tcp (source, dest, sourceport, port, TH_SYN | TH_ACK, 1028);
  usleep (1000);
  sourceport++;
  /* number 2. */
  send_raw_tcp (source, dest, sourceport, port, TH_FIN, 1028);
  usleep (1000);
  sourceport++;
  /* number 3. */
  send_raw_tcp (source, dest, sourceport, port, TH_FIN | TH_ACK, 1028);
  usleep (1000);
  sourceport++;
  /* number 4. */
  send_raw_tcp (source, dest, sourceport, port, TH_SYN | TH_FIN, 1028);
  usleep (1000);
  sourceport++;
  /* number 5. */
  send_raw_tcp (source, dest, sourceport, port, TH_PUSH, 1028);
  usleep (1000);
  bzero (responsez, sizeof (struct response) * 6);
/* response[] is global and will have values from previous scan maybe? */
  alarm (7);
  timev = time (NULL) + 6;
loop:
  while (timev > time (NULL))
    {
      bzero (buf, 2040);
      if (counter == 5)
	goto done;
      if (recvtcp (dest, buf, 2040))
	{
	  p4ck3t = (struct p4ck3t *) buf;
	  response_num = ntohs (p4ck3t->tcp.th_dport);
	  if (response_num > 5)
	    continue;		// not our packet
	  /* fill in response information */
	  responsez[response_num].window = ntohs (p4ck3t->tcp.th_win);
	  responsez[response_num].seqnum = ntohl (p4ck3t->tcp.th_seq);
	  responsez[response_num].acknum = ntohl (p4ck3t->tcp.th_ack);
	  responsez[response_num].syn = (p4ck3t->tcp.th_flags & TH_SYN);
	  responsez[response_num].ack = (p4ck3t->tcp.th_flags & TH_ACK);
	  responsez[response_num].push = (p4ck3t->tcp.th_flags & TH_PUSH);
	  responsez[response_num].fin = (p4ck3t->tcp.th_flags & TH_FIN);
	  responsez[response_num].rst = (p4ck3t->tcp.th_flags & TH_RST);
	  responsez[response_num].urg = (p4ck3t->tcp.th_flags & TH_URG);
	  if (DEBUG_CHECKOS)
	    {
	      printf ("\n%d - response number\n", response_num);
	      printf ("srcport: %d dstport: %d\n", ntohs (p4ck3t->tcp.th_sport), ntohs (p4ck3t->tcp.th_dport));
	      if (responsez[response_num].syn)
		printf ("syn ");
	      if (responsez[response_num].ack)
		printf ("ack ");
	      if (responsez[response_num].push)
		printf ("push ");
	      if (responsez[response_num].fin)
		printf ("fin ");
	      if (responsez[response_num].rst)
		printf ("rst ");
	      if (responsez[response_num].urg)
		printf ("urg ");
	      printf ("\n%u - seqnum\n", responsez[response_num].seqnum);
	      printf ("%u - acknum\n", responsez[response_num].acknum);
	      printf ("%u - window\n", responsez[response_num].window);
	    }
	  ++counter;
	  usleep (5000);
	}
    }
done:
  endpcap ();			/* close libpcap buffers and stuff */
}
