#include "sscan.h"

void
get_config_file (struct opts *options, char *filename)
{
#define MAX_READ 256
  extern char *deviceglobal;
  FILE *config_fd;
  char string[MAX_READ];
  char type[MAX_READ], *value, *ptr;

  char *rvalue (char *ptr)
  {
    char *tmp_ptr;
      tmp_ptr = (char *) strchr (ptr, '=');
    if (!tmp_ptr)
      {
	printf ("Error in config file!\n");
	exit (-1);
      }
    ++tmp_ptr;
    return tmp_ptr;
  }

  if (!filename)
    config_fd = fopen ("./Sscan.conf", "r");
  else
    config_fd = fopen (filename, "r");

  if (!config_fd)
    die ("error opening config file");

  while (fgets (string, MAX_READ, config_fd) != (char *) NULL)
    {
      /* cheesy parsing */
      if (strchr (string, '#'))
	continue;		/* comment line */
      if (strlen (string) < 5)
	continue;		/* a config option cant get smaller than this */
      strcpy (type, string);
      value = rvalue (string);
      ptr = (char *) strchr (type, '=');
      bzero (ptr, sizeof (ptr));
      value[strlen (value) - 1] = '\0';		/* remove new line */

      if (strncasecmp ("CGI", type, 3) == 0)
	{
	  if (strncasecmp ("YES", value, 3) == 0)
	    options->cgi = 1;
	  else
	    options->cgi = 0;
	}
      else if (strncasecmp ("DNS", type, 3) == 0)
	{
	  if (strncasecmp ("YES", value, 3) == 0)
	    options->dns = 1;
	  else
	    options->dns = 0;
	}
      else if (strncasecmp ("LLISTEN", type, 7) == 0)
	{
	  if (strncasecmp ("YES", value, 3) == 0)
	    options->llisten = 1;
	  else
	    options->llisten = 0;
	}
      else if (strncasecmp ("BANNER", type, 6) == 0)
	{
	  if (strncasecmp ("YES", value, 3) == 0)
	    options->banner = 1;
	  else
	    options->banner = 0;
	}
      else if (strncasecmp ("BACKDOOR", type, 8) == 0)
	{
	  if (strncasecmp ("YES", value, 3) == 0)
	    options->backdoor = 1;
	  else
	    options->backdoor = 0;
	}
      else if (strncasecmp ("RPC", type, 3) == 0)
	{
	  if (strncasecmp ("YES", value, 3) == 0)
	    options->rpc = 1;
	  else
	    options->rpc = 0;
	}
      else if (strncasecmp ("X11", type, 3) == 0)
	{
	  if (strncasecmp ("YES", value, 3) == 0)
	    options->x = 1;
	  else
	    options->x = 0;
	}
      else if (strncasecmp ("FINGER", type, 6) == 0)
	{
	  if (strncasecmp ("YES", value, 3) == 0)
	    {
	      value += 4;
	      options->fingers = (char *) malloc (strlen (value) + 1);
	      strcpy (options->fingers, value);
	    }
	  else
	    options->fingers = NULL;
	}
      else if (strncasecmp ("OPEN_SHARE", type, 10) == 0)
	{
	  if (strncasecmp ("YES", value, 3) == 0)
	    options->openshare = 1;
	  else
	    options->openshare = 0;
	}
      else if (strncasecmp ("SYNSCAN", type, 7) == 0)
	{
	  if (strncasecmp ("YES", value, 3) == 0)
	    options->syn = 1;
	  else
	    options->syn = 0;
	}
      else if (strncasecmp ("MODULE", type, 6) == 0)
	{
	  if (strncasecmp ("NONE", value, 4) == 0)
	    continue;
	  else
	    {
	      options->module = (char *) malloc (strlen (value) + 1);
	      strcpy (options->module, value);
	      options->do_modules = 1;
	    }
	}
      else if (strncasecmp ("MAX_CHILDREN", type, 12) == 0)
	{
	  options->maxchildren = atoi (value);
	}
      else if (strncasecmp ("DEVICE", type, 5) == 0)
	{
	  /*
	     if (strncasecmp ("DEFAULT", value, 7) == 0)
	     continue;
	     else */
	  strncpy (deviceglobal, value, 32);
	}
      else if (strncasecmp ("WINGATE", type, 7) == 0)
	{
	  if (strncasecmp ("NONE", value, 4) == 0)
	    continue;
	  else
	    {
	      options->wingate = (char *) malloc (strlen (value) + 1);
	      strcpy (options->wingate, value);
	    }
	}
    }
  fclose (config_fd);

}
