#include "sscan.h"
/* global thingz */
char *deviceglobal;		/* inet device we're using. */
char *stringos;			/* os of the box we're scanning. */
char *telnetbanner;		/* telnet banner of box we're scanning. */
struct response *responsez;	/* responses to queSO obscure tcp segments. */
struct vuln *global_vulns;	/* global vulnerability linked list. */
struct vuln *global_vulns_index;	/* where we are in the linked list */
struct tcptransaction *tcptransaction_start;
struct tcptransaction *tcptransaction_index;
u_long ipbuffer[256];

void
main (int argc, char **argv)
{
  /* global stuff */

  int counter = 0, option;
  struct opts opts;
  char current_ip[32], extrascript[32];
  u_long localip, firstip, lastip, currenthost;
  /* SET DEFAULT OPTIONS */
  opts.verbosity = 0;
  opts.cgi = 0;
  opts.dns = 0;
  opts.banner = 0;
  opts.rpc = 0;
  opts.x = 0;
  opts.singlehost = 0;
  opts.stdin_ip = 0;
  opts.syn = 0;
  opts.backdoor = 0;
  opts.llisten = 0;
  opts.openshare = 0;
  opts.doextrascript = 0;
  opts.maxchildren = 30;
  opts.config = NULL;
  opts.device = NULL;
  opts.module = NULL;
  opts.wingate = NULL;
  opts.fingers = NULL;
  opts.only_modules = 0;
  opts.regularscan = 1;
/* close stderr, it's annoying. */
  install_alarm_handler (ALARM_BLOCKING_IO);
  close (2);
/* allocate space for global buffers */
  deviceglobal = malloc (32);
  stringos = malloc (48);
  telnetbanner = malloc (300);
  responsez = calloc (6, sizeof (struct response));
/* initialize linked list of vulnerabilities found on current host. */
  global_vulns = malloc (sizeof (struct vuln));
  global_vulns_index = global_vulns;	/* movl %esp, %ebp :) */
/* initialize linked list of tcp transactions to make. */
  tcptransaction_start = malloc (sizeof (struct tcptransaction));
  tcptransaction_index = tcptransaction_start;
/* check if we're root? */
  setuid (0);
  setgid (0);
  if (argc < 2 || getuid () != 0)
    {
      printf ("* this program needs r00t to run * \n");
      usage ();
    }
  while ((option = getopt (argc, argv, "c:o:e:svm")) != EOF)
    {
      switch (option)
	{
	case 'v':
	  opts.verbosity = 1;
	  break;
	case 'e':
	  opts.extrascript = malloc(sizeof(optarg));
	  strcpy(opts.extrascript, optarg);
	  opts.doextrascript = 1;
	  break;
	case 'm':
	  opts.only_modules = 1;
	  break;
	case 's':		/* accept ip's from stdin */
	  opts.stdin_ip = 1;
	  opts.regularscan = 0;
	  break;
	case 'o':
	  opts.singlehost = 1;
	  opts.regularscan = 0;
	  opts.host = (char *) malloc (strlen (optarg) + 1);
	  strcpy (opts.host, optarg);
	  break;
	case 'c':
	  opts.config = (char *) malloc (strlen (optarg) + 1);
	  strcpy (opts.config, optarg);
	  break;
	}
    }

  /* i think we should buffer truncated output too. */
  /* if (!opts.verbosity)
     setvbuf (stdout, 0, _IONBF, 0); */
  if (opts.stdin_ip && opts.singlehost)
    {
      printf ("*!* don't use -o and -s together. *!*\n");
      usage ();
    }
  if (!opts.stdin_ip && !opts.host)
    usage ();
  get_config_file (&opts, opts.config);
  startpcap();
  endpcap();
  localip = getlocalip ();
/* scan a single host. */
  if (opts.singlehost)
    {
      if (lookup (opts.host) == -1)
	{
	  printf ("invalid host\n");
	  usage ();
	}
      if (!tcpping (localip, lookup (opts.host), 5 /* timeout */ ))
	{
	  printf ("ping timeout, box not up.\n");
	  exit (1);
	}
      scan (lookup (opts.host), localip, &opts);
      exit (0);
    }
/* done scanning single host. */

  if (opts.stdin_ip)
    {
      counter = 0;
      /* accepting ip's from standard input, using concurrent processes */
      /* BEGIN CONCURRENT SCANNING SHIOT! */
      while ((fgets (current_ip, 32, stdin)) != NULL)
	{
	  switch (fork ())
	    {
	    case 0:
	      {
		/* is this a valid ip address? */
		if (inet_addr (current_ip) == -1)
		  exit (0);
		if (!tcpping (localip, inet_addr (current_ip), 4))
		  exit (0);
		scan (inet_addr (current_ip), localip, &opts);
		exit (0);
	      }
	    case -1:
	      {
		perror ("fork");
		exit (0);
	      }
	    default:
	      {
		++counter;
		/* if we've spawned the maximum number of children wait for one
		   to exit before re-entering our loop */
		if (counter >= opts.maxchildren)
		  {
		    wait (NULL);
		  }
	      }
	    }
	}
      exit (0);
    }
  if (!parsebits (argv[optind], &firstip, &lastip))
    usage ();
  currenthost = firstip;
  while (currenthost != lastip)
    {
      switch (fork ())
	{
	case 0:
	  {
	    /* is this a valid ip address? */
	    if (!tcpping (localip, currenthost, 4))
	      exit (0);
	    scan (currenthost, localip, &opts);
	    exit (0);
	  }
	case -1:
	  {
	    perror ("fork");
	    exit (0);
	  }
	default:
	  {
	    ++counter;
	    /* if we've spawned the maximum number of children wait for one
	       to exit before re-entering our loop */
	    if (counter >= opts.maxchildren)
	      {
		wait (NULL);
	      }
	  }
	}
      currenthost = ntohl (currenthost);
      currenthost++;
      currenthost = htonl (currenthost);
    }
  exit (0);
}
/* END MAIN() */

void
usage (void)
{
  printf ("sscan0.1 - by jsbach, email: jsb4ch@hotmail.com \"!\"..\n");
  printf ("sscan (-o hostname | -s) (-c configfile) (-v)\n");
  printf ("-<[   -c <config> : specify an alternate config file.\n");
  printf ("-<[   -o <host>   : specify a single host to scan.\n");
  printf ("-<[   -e <script> : use this script in addition to default.\n");
  printf ("-<[   -m : skip all hardcoded checks and just use script file.\n");
  printf ("-<[   -s : accept host's to scan from stdin.\n");
  printf ("-<[   -v : verbose, in-depth output.\n");
  exit (1);
}

void
die (char *errbuf)
{
  if (errbuf)
    perror (errbuf);
  exit (-1);
}

void
blockingret (int signo)
{
  return;
}

/* lame. */
void
pcap_alarm_handler (int signo)
{
/* for inet devices */
  send_raw_tcp (inet_addr ("1.2.3.4"), inet_addr ("1.2.3.4"), 0, 0, 0, 0);
/* for lo */
  send_raw_tcp (inet_addr ("127.0.0.1"), inet_addr ("127.0.0.1"), 0, 0, 0, 0);
}

/* setup signal handler for SIGALRM, used in blocking syscall timeouts. */
/* used sigaction() for libc/glibc, bsd/sysv compatibility. */
int
install_alarm_handler (int type)
{
  struct sigaction alarmaction;
  bzero (&alarmaction, sizeof (struct sigaction));
  if (type == ALARM_PCAP)
    {
      alarmaction.sa_handler = pcap_alarm_handler;
      alarmaction.sa_flags = 0;
      sigaction (SIGALRM, &alarmaction, NULL);
    }
  if (type == ALARM_BLOCKING_IO)
    {
      alarmaction.sa_handler = blockingret;
      alarmaction.sa_flags = 0;
      sigaction (SIGALRM, &alarmaction, NULL);
    }
}
/*
   u_long getnextip(int type)
   {
   char buf[128];
   u_long tmp;

   if(type == STDIN) {
   fgets(buf, 128, stdin);
   tmp = inet_addr(buf);
   }
   if(type == REGULARSCAN) {
   currenthost = ntohs(currenthost) + 1;
   }
   }

 */
