#include "./sscan.h"
/* check if a host is up by sending TCP ACK segments to ports:
   23, 25, 110, 143, 80 (the most likely ports to not be firewalled) */

int
tcpping (u_long source, u_long dest, int timeout)
{
  extern char *deviceglobal;
  u_long timev;
  char buf[2040];
  startpcap ();	/* start b4 sending in case we're doing localhost */
  send_raw_tcp (source, dest, 23, 23, TH_ACK, 1028);
  usleep (1000);
  send_raw_tcp (source, dest, 25, 25, TH_ACK, 1028);
  usleep (1000);
  send_raw_tcp (source, dest, 143, 143, TH_ACK, 1028);
  usleep (1000);
  send_raw_tcp (source, dest, 110, 110, TH_ACK, 1028);
  usleep (1000);
  send_raw_tcp (source, dest, 80, 80, TH_ACK, 1028);
  usleep (1000);
  install_alarm_handler (ALARM_PCAP);
  alarm (timeout + 1);
  timev = time (NULL) + timeout;
  while (timev > time (NULL))
    {
      bzero (buf, 2040);
      if (recvtcp (dest, buf, 2040))
	{
	  endpcap ();
	  install_alarm_handler (ALARM_BLOCKING_IO);
	  return 1;
	}
    }
  endpcap ();			/* close libpcap buffers and stuff */
  install_alarm_handler (ALARM_BLOCKING_IO);
  return 0;
}
/* simple linked list implementation for vulnerability recording. */

extern struct vuln *global_vulns;
extern struct vuln *global_vulns_index;

int
add_vuln (char *vuln)
{
  struct vuln *new;
  new = malloc (sizeof (struct vuln));
  new->vulnstring = malloc (strlen (vuln) + 1);
  strncpy (new->vulnstring, vuln, strlen(vuln));
  new->next = NULL;
  /* have the previous vulnerability point to this one. */
  global_vulns_index->next = new;
  /* have the index pointing to the newest vulnerability. */
  global_vulns_index = new;
}
int
printvulns (char *currenthost)
{
  /* global_vulns points to the start of the linked list. */
  struct vuln *traverse;
  for (traverse = global_vulns; traverse->next != NULL; traverse = traverse->next)
    {
      printf ("--<[ *VULN*: %s: %s\n", currenthost, traverse->next->vulnstring);
      if (!traverse->next)
	return 0;		/* lame. */
    }
  return 0;
}
int
vulnexists (char *search)
{
  /* global_vulns points to the start of the linked list. */
  struct vuln *traverse;
  for (traverse = global_vulns; traverse->next != NULL; traverse = traverse->next)
    {
      if (strstr (traverse->next->vulnstring, search) != NULL)
	return 1;
      if (!traverse->next)
	return 0;		/* lame. */
    }
  return 0;
}

int 
parsebits (char *string, u_long * firsthost, u_long * lasthost)
{
  char host[64], bits[64];
  char *ptr;
  unsigned long int address, realbits, netmask;

/* parse the host */
  strncpy (host, string, 64);
  if (!(ptr = strchr (host, '/')))
    return 0;
  *ptr = '\0';

  if ((address = inet_addr (host)) == -1)
    {
      if ((address = lookup (host)) == -1)
	return 0;
    }

/* ok word host is parsed, now onto the bits */
  strncpy (bits, string, 64);
  if (!(ptr = strchr (bits, '/')))
    return 0;
  realbits = atoi (ptr + 1);

/* now determine first and last hosts of the scan. */
  address = ntohl (address);
  netmask = ~(0xFFFFFFFFL >> realbits);
  *firsthost = (address & netmask) + 1;
  *lasthost = (address | ~(netmask)) - 1;

/* convert the byte order back */
  *firsthost = htonl (*firsthost);
  address = htonl (address);
  *lasthost = htonl (*lasthost);
}

/* lame */
int 
sendmail_expn_check (u_long host, char *account)
{
  int fd;
  char buf[128];
  if ((fd = connect_to_host (host, 25)) == -1)
    return 0;
  alarm (0);
  alarm (3);
  read (fd, buf, 128);
  buf[127] = '\0';
  if (strstr (buf, "220") == NULL)
    return 0;
  snprintf (buf,128,"expn %s\r\n", account);
  write (fd, buf, strlen (buf));
  read (fd, buf, 128);
  buf[127] = '\0';
  if (strstr (buf, "250") == NULL)
    return 0;
  return 1;
}
