#include "sscan.h"

pcap_t *pcap_global_descriptor;
extern char *deviceglobal;
static int offset;	/* offset from datalink protocol hdr to ip hdr */

int
startpcap (void)
{
  char errbuf[1028];
  int datalink;
  struct pcap_pkthdr useless;
/* is the device null or set to the default still? if so look it up */
  if (!deviceglobal || !strcmp (deviceglobal, "default")) {
    strcpy(deviceglobal,pcap_lookupdev (errbuf));
   }
/* its still null?! exit this mothafuckaH! :-) */
  if (!deviceglobal)
    {
      printf ("Error getting device - %s\n", errbuf);
      exit (1);
    }
/* now open a "datalink descriptor" */
  pcap_global_descriptor = pcap_open_live (deviceglobal, 10000, 0, 1000, errbuf);
  if (pcap_global_descriptor == NULL)
    {
      printf ("error opening pcap: %s\n", errbuf);
      printf ("( * set your device in Sscan.conf *)\n");
      exit (1);
    }
 /* set the offset from the beginning of the datagram that the iphdr
    starts.*/

  datalink = pcap_datalink (pcap_global_descriptor);
  bzero (&useless, sizeof (struct pcap_pkthdr));
  /* these offsets were taken from queso by savage@apostols.org
     who took them from lamont something-or-other apparently */
  switch (datalink)
    {
    case DLT_EN10MB:
      offset = 14;
      break;
    case DLT_NULL:
    case DLT_PPP:
      offset = 4;
      break;
    case DLT_SLIP:
      offset = 16;
      break;
    case DLT_RAW:
      offset = 0;
      break;
    case DLT_SLIP_BSDOS:
    case DLT_PPP_BSDOS:
      offset = 24;
      break;
    case DLT_ATM_RFC1483:
      offset = 8;
      break;
    case DLT_IEEE802:
      offset = 22;
      break;
    default:
      fprintf (stderr, "unknown datalink type (%d)", datalink);
      return (0);
    }
  return 1;
}

void
endpcap (void)
{
  pcap_close (pcap_global_descriptor);
}

int
recvtcp (u_long from, char *buf, int sizeofbuffer)
{
  int datalink;
  struct pcap_pkthdr useless;

  struct p4ck3t
    {
      struct iphdr ip;
      struct tcphdr tcp;
      u_char *data;
    }
   *p4ck3t;
  p4ck3t = (struct p4ck3t *) pcap_next (pcap_global_descriptor, &useless);
  (char *) p4ck3t += offset;
  if (ntohs (p4ck3t->ip.tot_len) > sizeofbuffer - 1)
    return 0;
  memcpy (buf, p4ck3t, ntohs (p4ck3t->ip.tot_len));
  /* check to see if its somewhat valid */
  if (p4ck3t->ip.version != 4)
    {
      return 0;
    }
  if (p4ck3t->ip.protocol == IPPROTO_TCP)
    {
      if (p4ck3t->ip.saddr == from)
	return 1;
    }
  return 0;
}
