#include "sscan.h"
#define TIMEOUT 5
#include <errno.h>
int
isconnected (int sockfd)
{
  int sockopt = -1;
  u_long socklen = 4;
  fd_set wset;
  FD_ZERO (&wset);
  FD_SET (sockfd, &wset);
  select (sockfd + 1, NULL, &wset, NULL, NULL);
  if (FD_ISSET (sockfd, &wset))
    getsockopt (sockfd, SOL_SOCKET, SO_ERROR, &sockopt, &socklen);
  if (sockopt == 0)
    return 1;			/* connected */
  else if (sockopt != 4 && sockopt != -1)
    return 2;			/* something other than not connected */
  else
    return 0;
}

int
portscan (u_long host, struct ports *portz, int verbosity)
{
 char service[32];
  int count, i = 0, savedtime, openportscount = 0, retval, count2 = 0;
  char sockets[portz->length];
  /* try and establish all connections... */
  for (count = 0; count != portz->length; count++, ++i)
    {
      sockets[i] = connect_to_host (host, -(portz->portlist[count]));
      if (sockets[i] < 0)
	printf ("connect_to_host() failed. errno is %d\n", errno);
    }
  /* check/report connections */
  alarm(0); alarm(TIMEOUT + 1);
  savedtime = time (NULL);
  while (time (NULL) != (savedtime + TIMEOUT))
    {
      for (count = 0; count != portz->length; count++)
	{
	  if ((retval = isconnected (sockets[count])) != 0)
	    {
	      /* reseting the timeout slows things down! */
	      /*  savedtime = time (NULL); */
	      /* we're done with it */
	      close (sockets[count]);
	      /* its not an establish connection, so just ignore it */
	      if (retval == 2)
		{
		  count2++;
		  /* all ports have been accounted for, we're done */
		  if (count2 >= portz->length)
		    goto done;
		  continue;
		}
	      /* a new port was found open, do the normal deeds */
		getservicename(portz->portlist[count], service);
		if(!(openportscount%2)) puts("");
		printf ("<[ tcp port: %d (%s) ]> \t",portz->portlist[count],service);
	      count2++;
	      portz->portlist[openportscount] = portz->portlist[count];
	      ++openportscount;
	      /* all ports have been accounted for, we're done. */
	      if (count2 >= portz->length)
		goto done;
	    }
	}
    }
done:
  printf("\n");
  portz->length = openportscount;
}

int
checkport (struct ports *portz, int port)
{
  int count;
  for (count = 0; count < portz->length; count++) {
    if (portz->portlist[count] == port)
      return 1;
   }
  return 0;
}

int
findopenport (struct ports *portz)
{
  int count;
  for (count = 0; count <= portz->length; count++)
    if (portz->portlist[count] != 0)
      return portz->portlist[count];
  return 0;
}

void getservicename(int port, char *string)
{
struct servent *j;
j = getservbyport(htons(port), "tcp");
if(!j) { strcpy(string, "unknown"); return; }
strcpy(string, j->s_name);
}
