/*
   i decided to split up the portmapper routines into 3 functions
   so that we'll only have to query once for any given
   host..  rpcinfo() gets the portmap, checkrpc() searches the portmap list
   for a given service, and printrpc() prints the entire list ala rpcinfo:)
 */

#include "sscan.h"


struct pmaplist *
rpcinfo (u_long host)
{
  struct sockaddr_in sheep;
  static struct pmaplist *head;	/* linked list returned by pmap_getmaps .. */

  sheep.sin_family = AF_INET;
  sheep.sin_port = htons (111);	/* sunrpc ;) */
  sheep.sin_addr.s_addr = host;

  head = pmap_getmaps (&sheep);
  return head;
}				/* that was easy =P */

int
checkrpc (struct pmaplist *head, char *prog)
{
  struct rpcent *service;	/* for prognum -> ascii lookup */
  if (head == NULL)
    return 0;
  while (head != NULL)
    {
      head = head->pml_next;	/* next member of the linked list */
      /* resolve the program number to a string */
      if ((service = getrpcbynumber (head->pml_map.pm_prog)) != NULL)
	if (strcmp (prog, service->r_name) == 0)
	  return 1;
      if (head->pml_next == NULL)
	return 0;
    }
}


int
printrpc (struct pmaplist *head, u_long ip)
{
  struct rpcent *service;	/* for prognum -> ascii lookup */
  printf ("--<[ * rpc servicez? * ]>--\n");

  if (head == NULL)
    {
      printf ("[ NONE ! ]\n");
      return 0;
    }

  while (head != NULL)
    {
      head = head->pml_next;	/* next member of the linked list */
      /* resolve the program number to a string */
      if ((service = getrpcbynumber (head->pml_map.pm_prog)) != NULL)

	printf ("<[ [prog. name -> %s] [port -> %d(%s)] [vers. -> %d]\n",
		service->r_name, head->pml_map.pm_port,
	(head->pml_map.pm_prot == 6) ? "tcp" : "udp", head->pml_map.pm_vers);

      if (head->pml_next == NULL)
	{
	  return 0;
	}
    }
}

/* fix me.. br0ke on some hosts.. */
struct mountbody *
nfsinfo (u_long host)
{
  CLIENT *aqua;
  static struct mountbody *exports = NULL;
  struct timeval timeout;
  aqua = clnt_create (inet_ntoa (host), MOUNTPROG, MOUNTVERS, "tcp");
  if (aqua == NULL)
    return NULL;
  timeout.tv_sec = 3;
  timeout.tv_usec = 31337;
  clnt_call (aqua /* call nfs */ , MOUNTPROC_DUMP /*remote procedure */ ,
	     xdr_void /* no input to z function */ , 0 /* "" */ ,
	     xdr_mountlist /* local procedure? */ ,
	     (caddr_t) & exports /* out args */ , timeout);
  return exports;
}
int
printexports (u_long host, struct mountbody *exportz)
{
  int retwillbeone = 0;
  for (; exportz != NULL; exportz = exportz->ml_next)
    {
      if (strcmp (exportz->ml_hostname, "(anon)") == 0)
	{
	  strcpy (exportz->ml_hostname, "everyone! =)");
	  retwillbeone++;
	}
      printf ("-<[ *NFS exp0rt*: %s: to: %s  dir: %s ]>-\n",
	      inet_ntoa (host), exportz->ml_hostname, exportz->ml_directory);
    }
  if (retwillbeone)
    return 1;
  return 0;
}
