#include "sscan.h"
struct ports *openports;

struct vulns *
scan (u_long ip, u_long localip, struct opts *opts)
{
  struct mountbody *mountl1st;	/* exports on current host. */
  struct pmaplist *portmap;	/* rpc services running on current host. */
  char *spareptr, sparestring[128], *ptr, *ptr2, *ptr3;
  extern char *stringos;
  extern char *deviceglobal;
  extern char *telnetbanner;
  char *currenthostname;
  int index = 0, counter = 0;
  currenthostname = rlookup (ip);
  openports = calloc(1, sizeof(struct ports));
  printf ("--------------------------<[ * report for host %s *", currenthostname);
  /* SETUP PORTS */
  index = 0;

  if (opts->cgi)
    {
      openports->portlist[index] = 80;
      index++;
    }
  if (opts->banner)
    {
      openports->portlist[index] = 23;
      index++;
      openports->portlist[index] = 143;
      index++;
      openports->portlist[index] = 110;
      index++;
    }
  if (opts->rpc)
    {
      openports->portlist[index] = 111;
      index++;
    }
  if (opts->x)
    {
      openports->portlist[index] = 6000;
      index++;
    }
  if (opts->fingers)
    {
      openports->portlist[index] = 79;
      index++;
    }
  if (opts->dns)
    {
      openports->portlist[index] = 53;
      index++;
    }
  if (opts->backdoor)
    {
      openports->portlist[index] = 31337;
      index++;
    }
  if (opts->llisten)
    {
      openports->portlist[index] = 2766;
      index++;
    }
  openports->portlist[index] = 139;
  index++;
  openports->portlist[index] = 25;
  index++;
  openports->portlist[index] = 21;
  index++;
  openports->portlist[index] = 22;
  index++;
  openports->portlist[index] = 1114;
  index++;
  openports->portlist[index] = 1;
  index++;
  openports->length = index;
  /* PORT SCAN */
  portscan (ip, openports, opts->verbosity);
  install_alarm_handler (ALARM_PCAP);
  checkos (localip, ip, openports->portlist[0]);
  install_alarm_handler (ALARM_BLOCKING_IO);
  do_modules (localip, ip, 0 /* os */ , "./Osdefs.ms");
  if (opts->only_modules)
    goto modules;
  if (!(!(*stringos)))
    printf ("--<[ *OS*: %s: os detected: %s\n", currenthostname,
	    stringos);

  /* TELNET BANNER */
  if (opts->verbosity && checkport(openports, 23))
    {
      printf ("--<[ *BANNER*: telnet banner: %s\n\n", telnetbanner);
      close (index);
    }
  /* POP3 BANNER */
  if (checkport (openports, 110))
    {
      spareptr = (char *) getbanner (ip, 110);
      if (spareptr != 0)
	{
	  if (strstr ((char *) spareptr, "QPOP") != (char) NULL)
	    add_vuln ("QPOP remote r00t buffer overflow");
	}
      if (opts->verbosity)
	printf ("--<[ *BANNER*: POP banner follows:\n%s\n", (char *)
		spareptr);
    }
  /* IMAP BANNER */
  if (checkport (openports, 143))
    {
      spareptr = (char *) getbanner (ip, 143);
      if (spareptr != NULL)
	{
	  if (strstr ((char *) spareptr, "9.0") != (char) NULL)
	    add_vuln ("IMAP remote r00t buffer overflow");
	  if (opts->verbosity)
	    printf ("--<[ *BANNER*: IMAP banner follows:\n%s\n\n", (char
							       *) spareptr);
	}
    }
  /* sendmail EXPN check */
  if (checkport (openports, 25))
    {
      if (sendmail_expn_check (ip, "root"))
	add_vuln ("sendmail will 'expn' accounts for us");
    }

  /* LLISTEN CHECK */
  if (checkport (openports, 2766) && os ("solaris"))
    add_vuln ("solaris x86 listen/nlps_serv remote root overflow");
  if (checkport (openports, 1114) && os ("linux"))
    add_vuln ("linux running mysql 2.0, remote stack overflow");
  if (checkport(openports, 53) && (os("linux") || os("bsd")))
    if(checknamed(inet_ntoa(ip))) add_vuln("linux bind/iquery buffer overflow");
  /* CGI CHECKS */
  if (checkport (openports, 80) && !os ("windows"))
    {
      if (!os ("windows"))
	{
	  if (check_cgi (ip, "/cgi-bin/phf"))
	    add_vuln ("/cgi-bin/phf here.. shell escape?");
	  if (check_cgi (ip, "/cgi-bin/Count.cgi"))
	    add_vuln ("/cgi-bin/Count.cgi remote overflow?");
	  if (check_cgi (ip, "/cgi-bin/test-cgi"))
	    add_vuln ("/cgi-bin/test-cgi here.");
	  if (check_cgi (ip, "/cgi-bin/php.cgi"))
	    add_vuln ("/cgi-bin/php.cgi here.");
	  if (check_cgi (ip, "/cgi-bin/handler"))
	    add_vuln ("/cgi-bin/handler (shell escape..?)");
	  if (check_cgi (ip, "/cgi-bin/webgais"))
	    add_vuln ("/cgi-bin/webgais is here.");
	  if (check_cgi (ip, "/cgi-bin/websendmail"))
	    add_vuln ("/cgi-bin/websendmail is here.");
	  if (check_cgi (ip, "/cgi-bin/webdist.cgi"))
	    add_vuln ("/cgi-bin/webdist.cgi is here.");
	  if (check_cgi (ip, "/cgi-bin/faxsurvey"))
	    add_vuln ("/cgi-bin/faxsurvery is here.");
	  if (check_cgi (ip, "/cgi-bin/htmlscript"))
	    add_vuln ("/cgi-bin/htmlscript is here.");
	  if (check_cgi (ip, "/cgi-bin/pfdisplay.cgi"))
	    add_vuln ("/cgi-bin/pfdisplay.cgi is here.");
	}
      if (check_cgi (ip, "/cgi-bin/perl.exe"))
	add_vuln ("/cgi-bin/perl.exe is here.");
      if (check_cgi (ip, "/cgi-bin/wwwboard.pl"))
	add_vuln ("/cgi-bin/wwwboard.pl is here.");
    }
  /* DNS CHECK */
  if (checkport (openports, 53) && os ("linux"))
    add_vuln ("linux bind/iquery remote buffer overflow");
  /* BACKDOOR CHECK */
  if (checkport (openports, 31337))
    add_vuln ("port 31337(tcp) open.. backdoor?");
  /* RPC CHECK */
  if (checkport (openports, 111) && !os ("windows"))
    {
      portmap = (struct pmaplist *) rpcinfo (ip);
      if (opts->verbosity)
	printrpc (portmap, ip);
      mountl1st = (struct mountbody *) nfsinfo (ip);
      if (opts->verbosity)
	printf ("--<[ * exports ....? * ]>--\n");
      if (printexports (ip, mountl1st))
	add_vuln ("world readable/writeable nfs exports");
      if (os ("linux"))
	if (checkrpc (portmap, "mountd"))
	  add_vuln ("linux mountd remote buffer overflow");
      if (os ("solaris"))
	{
	  if (checkrpc (portmap, "rstatd"))
	    add_vuln ("solaris running statd (automountd remote?)");
	  if (checkrpc (portmap, "rpc.nisd") || checkrpc (portmap, "ypserv"))
	    add_vuln ("solaris running NIS services.. remote overflow?");
	  if (checkrpc (portmap, "nlockmgr"))
	    add_vuln ("solaris running nlockmgr.. remote overflow?");
	}
    }
  /* X11 CHECK */
  if (checkport (openports, 6000) && !os ("windows"))
    {
      bzero (sparestring, sizeof (sparestring));
      strcpy (sparestring, (char *) inet_ntoa (ip));
      strcat (sparestring, ":0");
      if (XOpenDisplay (sparestring) != NULL)
	add_vuln ("the X display can be dumped/sniffed");
    }
  if (strstr (telnetbanner, "Gate>") != NULL)
    add_vuln ("runs wingate!");
  /* FINGER CHECKS */
  if (checkport (openports, 79) && (!os("windows")))
    {
      if (opts->verbosity)
	{
	  printf ("\n--<[ * fingering accountz... * ]>--\n");
	  printf ("%s\n", finger (ip, "\r\n"));
	}
      ptr = opts->fingers;
      ptr2 = NULL;
      while (1)
	{
	  ptr2 = strtok (ptr, ",");
	  if (ptr2 == NULL)
	    break;
	  snprintf (sparestring, sizeof (sparestring), "%s\r\n\0", ptr2);
	  ptr3 = finger (ip, sparestring);
	  if (!ptr3)
	    break;
	  if ((strstr (ptr3, "no such user") != NULL))
	    printf ("");
	  else if (strstr (ptr3, "Never logged") != NULL)
	    printf ("-<[ *FINGER*: %s: %s: is a user who has never logged in.\n", currenthostname, ptr2);
	  else if (strstr (ptr3, "Login") != NULL)
	    printf ("-<[ *FINGER*: %s: %s: account exists.\n",
		    currenthostname, ptr2);
	  else if (opts->verbosity)
	    printf ("-<[ *FINGER*: %s: uninterpreted finger output: %s\n",
		    currenthostname, ptr3);
	  ptr += (strlen (ptr2) + 1);
	}
    }

  if (opts->do_modules)
    {
    modules:
      do_modules (localip, ip, 0, opts->module);
      if(opts->doextrascript) 
       do_modules (localip, ip, 0, opts->extrascript);
    }
  printvulns (currenthostname);
  printf ("---------------------------<[ * scan of %s completed *\n\n",
currenthostname);
  write (1, "\n\n", 2);
}
