#define LIBC
#include <stdio.h>
#include <fcntl.h>
#include <netdb.h>
#include <signal.h>
#include <linux/sockios.h>
#include <unistd.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <rpc/rpc.h>
#include <rpc/pmap_prot.h>
#include <rpcsvc/mount.h>
#include <errno.h>
#include <rpc/pmap_prot.h>
#include <rpc/pmap_clnt.h>
#include "./pcap_include/bpf.h"
#include "./pcap_include/pcap.h"
#include <string.h>
#include <getopt.h>
#include <setjmp.h>

#define os(x) (strstr(stringos, x) != NULL)

#define TH_FIN  0x01
#define TH_SYN  0x02
#define TH_RST  0x04
#define TH_PUSH 0x08
#define TH_ACK  0x10
#define TH_URG  0x20

#define DEBUG_NET 0
#define DEBUG_PARSE 0
#define DEBUG_CHECKOS 0

#define ALARM_PCAP 2
#define ALARM_BLOCKING_IO 3

/* scripting lang command defines */
#define PORT 2
#define RPC 3
#define BANNER 4
#define CGI 5
#define OS 6
#define PRINT 7
#define COMMENT 8
#define SH 9
#define STARTTELNETDIALOG 10
#define SEND 11
#define READ 12
#define WAIT 13
#define ENDDIALOG 14
#define STARTTCPDIALOG 15
#define RESPONSE 16
#define REGISTEROS 17
#define TELNETBANNER 18
#define ADDVULN 19
#define VULNEXISTS 20

struct response
  {
    u_short window, syn, ack, fin, push, urg, rst;
    u_long seqnum, acknum;
  };

struct tcptransaction {
u_short port;
char *indata;
char *outdata;
struct tcptransaction *next;
};

struct tcphdr
{
    u_int16_t th_sport;         /* source port */
    u_int16_t th_dport;         /* destination port */
    u_int32_t th_seq;             /* sequence number */
    u_int32_t th_ack;             /* acknowledgement number */
    u_int8_t th_x2:4;           /* (unused) */
    u_int8_t th_off:4;          /* data offset */
    u_int8_t th_flags;
    u_int16_t th_win;           /* window */
    u_int16_t th_sum;           /* checksum */
    u_int16_t th_urp;           /* urgent pointer */
};                                                                                                  
struct ports 
{ 
    short portlist[256];
    int length;
};
struct icmppacket
{
    struct iphdr ip;
    struct icmphdr icmp;
    char data[1400];
};
struct opts
{
    char 	verbosity,singlehost,doextrascript,
			cgi,
			dns,
			rpc,
			x,
			stdin_ip,
			banner,
			syn,
			backdoor,
			llisten,
			openshare,
			processes,
			maxchildren, do_modules, only_modules,
			regularscan;	
	char 	*module,
			*host,
			*device,
			*wingate,
			*config,
			*fingers,
			*extrascript;
};

/* vulnerabilities are arranged in a linked list.. when a new
vulnerability is found it is added to the list. */

struct vuln {
struct vuln *next;
char *vulnstring;
};

/* FUNCTION PROTOTYPES */
/* main.c */
void ret (int);
void main (int, char **);
void usage (void);
void usage (void);
void die(char *);
/* scan.c */
struct vulns *scan (u_long ,u_long,struct opts *);
/* net.c */
unsigned long int lookup (char *);
char *rlookup (u_long);
int connect_to_host (unsigned long int, int);
char *finger (unsigned long int, char *);
int check_port (unsigned long int , int);
int ping (unsigned long int);
u_long getlocalip (void);
unsigned short in_cksum (unsigned short *, int);
void send_raw_tcp (u_long, u_long, u_short,u_short, u_short,u_short);
int telnetconnect (u_long);
/* parse.c */
void do_modules (u_long , u_long, int , char *);
int handle_port (char *);
int handle_rpc (char *);
int handle_banner (char *);
int handle_cgi (char *);
int handle_os (char *, int );
int handle_print(char *);
int parse_line (char *, int);
char *getbetweenbrackets (char *);
char *getbeforecoma (char *);
char *getaftercoma (char *);
/* portscan.c */
int isconnected(int);
int portscan(u_long, struct ports *, int);
/* rpc.c */
struct pmaplist *rpcinfo (u_long);
int checkrpc (struct pmaplist *, char *);
int printrpc (struct pmaplist *, u_long);
/* ident.c */
char *getident(u_long , u_short , u_short);
char *getbanner(u_long , int);
/* banner.c */
char *getbanner(u_long , int );
/* checkos.c */
int tcpflags (u_long , u_long , u_short , int );
char *checkos(u_long, u_long, u_short);
int telnetos (u_long);
const char *printos(int);
/*  pcap.c */
int startpcap(void);
int recvtcp(u_long , char *, int);
/* synportscan.c */
int syn_portscan (u_long , u_long , struct ports *);
/* config.c */
void get_config_file(struct opts*,char *);
/* cgi.c */
int check_cgi(u_long , char *);
/* mount.c */
struct mountbody *nfsinfo (u_long );
int printexports (u_long , struct mountbody *);

/* from linux/if.h... this wasnt #include'd to avoid glibc/libc
header incompatibility */
struct ifmap 
{
	unsigned long mem_start;
	unsigned long mem_end;
	unsigned short base_addr; 
	unsigned char irq;
	unsigned char dma;
	unsigned char port;
	/* 3 bytes spare */
};
struct ifreq 
{
#define IFHWADDRLEN	6
#define	IFNAMSIZ	16
	union
	{
		char	ifrn_name[IFNAMSIZ];		/* if name, e.g. "en0" */
	} ifr_ifrn;
	
	union {
		struct	sockaddr ifru_addr;
		struct	sockaddr ifru_dstaddr;
		struct	sockaddr ifru_broadaddr;
		struct	sockaddr ifru_netmask;
		struct  sockaddr ifru_hwaddr;
		short	ifru_flags;
		int	ifru_metric;
		int	ifru_mtu;
		struct  ifmap ifru_map;
		char	ifru_slave[IFNAMSIZ];	/* Just fits the size */
		caddr_t	ifru_data;
	} ifr_ifru;
};

#define ifr_name	ifr_ifrn.ifrn_name	/* interface name 	*/
#define ifr_hwaddr	ifr_ifru.ifru_hwaddr	/* MAC address 		*/
#define	ifr_addr	ifr_ifru.ifru_addr	/* address		*/
#define	ifr_dstaddr	ifr_ifru.ifru_dstaddr	/* other end of p-p lnk	*/
#define	ifr_broadaddr	ifr_ifru.ifru_broadaddr	/* broadcast address	*/
#define	ifr_netmask	ifr_ifru.ifru_netmask	/* interface net mask	*/
#define	ifr_flags	ifr_ifru.ifru_flags	/* flags		*/
#define	ifr_metric	ifr_ifru.ifru_metric	/* metric		*/
#define	ifr_mtu		ifr_ifru.ifru_mtu	/* mtu			*/
#define ifr_map		ifr_ifru.ifru_map	/* device map		*/
#define ifr_slave	ifr_ifru.ifru_slave	/* slave device		*/
#define	ifr_data	ifr_ifru.ifru_data	/* for use by interface	*/

struct ifconf 
{
	int	ifc_len;			/* size of buffer	*/
	union 
	{
		caddr_t	ifcu_buf;
		struct	ifreq *ifcu_req;
	} ifc_ifcu;
};
#define	ifc_buf	ifc_ifcu.ifcu_buf		/* buffer address	*/
#define	ifc_req	ifc_ifcu.ifcu_req		/* array of structures	*/
