/* this code is spagehtii =) */

#include "sscan.h"
#define TIMEOUT 8
#define MAX_READ_DATA 255

extern struct tcptransaction *tcptransaction_index;
extern struct tcptransaction *tcptransaction_start;

int
add_tcp_transaction (u_short port, char *indata)
{
  struct tcptransaction *new;
  new = calloc (1, sizeof (struct tcptransaction));
  if (indata != NULL)
    new->indata = calloc (1, strlen (indata));

/* i wish we could malloc() the output buffer based on how many bytes
   were read, but we read() into a buffer that uses a pointer to this
   buffer, so if we changed the pointer, this buffer would remain unchanged
   and the calling function would receive gibberish.. 0h w3ll. */

  new->outdata = calloc (1, MAX_READ_DATA);
  new->port = port;

  if (indata != NULL)
    strcpy (new->indata, indata);
  if (!indata)
    new->indata = NULL;
  tcptransaction_index->next = new;
  tcptransaction_index = new;
}

/* this function goes through a linked list of information about two
   "sentence" dialogs between client/server to be carried out all at once. */
/* its useful for queueing CGI, finger, pop3, and sendmail queries. */

void
do_tcp_transactions (u_long host)
{
  struct socketd
  {
    u_short port;
    u_char sockfd;
    char *indata;
    char *outdata;
  }
   *sockets, *opensockets;
/* variables for select() */
  fd_set readfds, writefds;
  int highestfd = 0, lowestfd = 0, selectret;
  struct timeval timeout;
/* for debugging */
  char buf[512];

/* for linked list */
  struct tcptransaction *traverse;
  /* socket connecting stuff */
  int i = 0, savedtime, count, numentries = 0, opensockets_index = 0;
  int count2 = 0;		/* <- number of sockets that have
				   been rst'd or syn'd */
  int numopen = 0;		/* <- number of open sockets. */
  int retval = 0;
/* structures for holding sockets etc. */
  sockets = calloc (255, sizeof (struct socketd));
  opensockets = calloc (255, sizeof (struct socketd));

/* find out where our lowest socket is, used in structure
   complications later on with select() */

/* create nonblocking connections */
  for (traverse = tcptransaction_start;
       traverse->next != NULL; traverse = traverse->next, ++i)
    {
      printf ("connecting to %d.\n", traverse->next->port);
      sockets[i].sockfd = connect_to_host (host, -(traverse->next->port));
      sockets[i].port = traverse->next->port;
      sockets[i].indata = traverse->next->indata;
      sockets[i].outdata = traverse->next->outdata;
      if (!traverse->next)
	return;
      numentries++;
    }
  /* setup timeout */
  savedtime = time (NULL);
  while (time (NULL) < (savedtime + TIMEOUT))
    {
      for (count = 0; count <= numentries; count++)
	{
	  if ((retval = isconnected (sockets[count].sockfd)) != 0)
	    {
	      if (retval == 2)
		{
		  count2++;
		  /* all ports have been accounted for, goto connected state. */
		  if (count2 >= numentries)
		    {
		      goto connected;
		    }
		  continue;
		}
	      /* neat, its open */
	      count2++;
	      numopen++;
	      printf ("open port found, %d.\n",
		      sockets[count].port);
	      /* i know you can assign structures to each other in C,
	         but doing it just makes me feel funny. */
	      opensockets[opensockets_index].sockfd = sockets[count].sockfd;
	      opensockets[opensockets_index].port = sockets[count].port;
	      opensockets[opensockets_index].indata = sockets[count].indata;
	      opensockets[opensockets_index].outdata = sockets[count].outdata;
	      opensockets_index++;
	      /* all ports have been accounted for, we're done. */
	      if (count2 >= numentries)
		goto connected;
	    }
	}
    }
connected:
  /* now do read/write stuff on connected sockets */

  /* initialize the timeout for select() */
  bzero (&timeout, sizeof (struct timeval));
  timeout.tv_sec = TIMEOUT;
  bzero (&readfds, sizeof (readfds));
  bzero (&writefds, sizeof (writefds));
  /* initialize the socket descriptor sets for select() */
  for (count = 0; count < numopen; count++)
    {
      FD_SET (opensockets[count].sockfd, &writefds);
      FD_SET (opensockets[count].sockfd, &readfds);
      /* is this fd higher than the one we thought was the highest?
         if so set it as the highest fd. */
      if (opensockets[count].sockfd > highestfd)
	highestfd = opensockets[count].sockfd;
    }

/* debug */
  for (count = 0; count < numopen; count++)
    printf ("sockfd: %d port: %d\n",
	    opensockets[count].sockfd, opensockets[count].port);

/* wait for the sockets to be ready for input */
  for (count = 0; count < numopen;)
    {
      selectret = select (highestfd + 1, NULL, &writefds, NULL, &timeout);
      printf ("selectret is %d.\n", selectret);
      for (count2 = 0; count2 < numopen; count2++)
	{
	  if (FD_ISSET (opensockets[count2].sockfd, &writefds))
	    {
	      /* ok word its connected, lets write the input */
	      if (opensockets[count2].indata)
		write (opensockets[count2].sockfd, opensockets[count2].indata,
		       strlen (opensockets[count2].indata));
	      count++;
	    }
	}
    }
  /* now lets read() the output */
  for (count = 0; count < numopen;)
    {
      selectret = select (highestfd + 1, &readfds, NULL, NULL, &timeout);
      if (selectret == 0)
	{
	  puts ("timeout");
	  goto d0ne;
	}
      for (count2 = 0; count2 < numopen; count2++)
	{
	  printf ("socket %d.\n", opensockets[count2].sockfd);
	  /* ok word, our data has arrived, lets read it in */
	  if (FD_ISSET (opensockets[count2].sockfd, &readfds))
	    {
	      read (opensockets[count2].sockfd, opensockets[count2].outdata, 255);
	      printf ("data for socket %d:\n", opensockets[count2].sockfd);
	      puts (opensockets[count2].outdata);
	      puts ("\r\n");
	    }
	}
    }
d0ne:
}

void
printtransactions (void)
{
  struct tcptransaction *traverse;

  for (traverse = tcptransaction_start;
       traverse->next != NULL; traverse = traverse->next)
    {
      printf ("%s\n", traverse->next->outdata);
      printf ("%s\n", traverse->next->indata);
      printf ("%d\n\n", traverse->next->port);
    }

}
