#include <sys/time.h>
#include <unistd.h>
#include <iostream.h>
#include <iomanip.h>
#include <qp.h>

class TimeMeasure {
    private:
	struct timeval start_tv;
	struct timeval stop_tv;
    public:
	void Start() {
		gettimeofday(&start_tv, NULL);
	}
	void Stop() {
		gettimeofday(&stop_tv, NULL);
	}
	void Print() {
		int sec, usec;
		char usec_str[16];
		
		sec = stop_tv.tv_sec - start_tv.tv_sec;
		if (start_tv.tv_usec > stop_tv.tv_usec) {
			sec--;
			usec = (stop_tv.tv_usec + 1000000) - start_tv.tv_usec;
		} else
			usec = stop_tv.tv_usec - start_tv.tv_usec;
		sprintf(usec_str, "%06d", usec);
		cout << "time: " << sec << "." << usec_str << endl;
	}
};


void spinlock_test(int iter)
{
	TimeMeasure tme;
	QpSpinLock spin_lock;
	int i;
	
	cout << "SpinLock - plain test ";
	cout.flush();
	
	tme.Start();
	for (i = 0; i < iter; i++) {
		spin_lock.Lock();
		spin_lock.Unlock();
	}
	tme.Stop();
	tme.Print();
}

void mutex_test(int iter)
{
	TimeMeasure tme;
	QpMutex mutex;
	int i;
	
	cout << "Mutex - plain test ";
	cout.flush();
	tme.Start();
	for (i = 0; i < iter; i++) {
		mutex.Lock();
		mutex.Unlock();
	}
	tme.Stop();
	tme.Print();
}

void mutexex_test(int iter)
{
	TimeMeasure tme;
	QpMutexEx mutex;
	int i;
	
	cout << "MutexEx - plain test ";
	cout.flush();
	tme.Start();
	for (i = 0; i < iter; i++) {
		mutex.Lock();
		mutex.Unlock();
	}
	tme.Stop();
	tme.Print();
}

int main(int argc, char *argv[])
{
	QpInit qp_init;
	int c;
	int iter = 1000;
	
	while ((c = getopt(argc, argv, "i:")) != EOF) {
		switch (c) {
		    case 'i':
			iter = atoi(optarg);
			break;
		}
	}
	spinlock_test(iter);
	mutex_test(iter);
	mutexex_test(iter);
	return 0;
}
