#include <qpthr/qp.h>

class TimerTest: public QpRunnable {
	QpMonitor tt_monitor;
	int 	  tt_count;
    public:
	TimerTest(): tt_count(0) {}
	virtual void Main() {
		cout << "TimerTest" << endl;
		QpSLock lock(&tt_monitor);
		tt_count++;
		tt_monitor.Broadcast();
	}
	void WaitForCount(int c) {
		QpSLock lock(&tt_monitor);
		while (tt_count < c)
			tt_monitor.Wait();
	}
};

int main()
{
	QpInit qp_init(QpInit::QP_TIMER);
	TimerTest tt;
	QpRegItem ri;
	
	ri = QpTimer::Register(&tt, 500, 10);
	tt.WaitForCount(5);
	QpTimer::Unregister(ri);
	QpThread::Sleep(1000);
	cout << endl;
	ri = QpTimer::Register(&tt, 500, 1);
	QpThread::Sleep(1000);
}
