#!/bin/sh
#
# bb-doack.sh
#
# BIG BROTHER ACKNOWLEDGEMENT SCRIPT
# Robert-Andre Croteau
# Version 1.3
# November 7, 1999
#
# This program is Copyright (c) 1997-1999
# Robert-Andre Croteau, The MacLawran Group Inc.
# All Rights Reserved
#
# Format: bb-doack.sh ack_event <XXXXX> <delay> [message]
#   where XXXXX is an acknowledgement number 
#         bb-doack.sh rm_event <hostname.service>
#   where hostname.service is an event tag
# i.e. : bb-doack.sh ack_event 43652 60
#	acknowledge ticket # 43652 with a delay of 60 minutes
#	 bb-doack.sh rm_event myhost.domain.com.conn
#	remove event notification for myhost.domain.com.conn
#


# ***************         IMPORTANT         *******************
#
# Do not use this script directly to acknowlege an event
# please use the 'bb' client:
# bb bbpage-ip "ack ack_event ack# delay message"
# and make sure your BB environment has been sourced
# 

if test "$#" != "1"
then
    echo "bb-doack.sh: wrong argument count - $#"
    echo "             arguments should be double quoted"
    echo "Usage: bb-doack.sh \"ack_event <ack #> <delay> [message]\""
    echo "       bb-doack.sh \"rm_event <host[.domain].service> <seconds down>\""
    exit 1
fi

# Acknowledge notification

set $1

if [ "$#" -lt 2 -o "$#" -gt 4 ]
then
    echo "bb-doack.sh: wrong argument count - $# - $*"
    exit 1
fi

case $1 in

    ack_event)

	shift
	if [ "$#" -lt 2 -o "$#" -gt 3 ]
	then
	    echo "bb-doack.sh: ack_event has wrong arguments - $*"
    	    echo "Usage: bb-doack.sh \"ack_event <ack #> <delay> [message]\""
	    exit 1
	fi

	# Make sure no invalid characters are in the number
	number=`echo "$1" | $SED 's/[0-9]//g'`
	number=`eval "echo $number"`
	if [ "$number" != "" ]
	then
	    echo "bb-doack.sh: Invalid ack# - $1"
    	    echo "Usage: bb-doack.sh \"ack_event <ack #> <delay> [message]\""
	    exit 2
	fi
	NUMBER=$1

	# Make sure no invalid characters are in the delay
	delay=`echo "$2" | $SED 's/[0-9]//g'`
	delay=`eval "echo $delay"`
	if [ "$delay" != "" ]
	then
	    echo "bb-doack.sh: Invalid delay - $2"
    	    echo "Usage: bb-doack.sh \"ack_event <ack #> <delay> [message]\""
	    exit 3
	fi
	DELAY=$2

	if [ "$#" -eq 3 ]
	then
		MESSAGE="$3"
	else
		MESSAGE=""
	fi

	# These shouldn't be used as ack #.  0000000 is used as initial delay/escalation
	# 0000099 would match 0000000 later on with it's first five digits and is invalid
	NUMVAL=`$EXPR $NUMBER + 0`
	if [ $NUMVAL -eq 0 -o $NUMVAL -eq 99 ]
	then
		exit 0
	fi

	# Now go thru the list of pagin tag files
	# and find out which one is associated with the number
	# if the ack # ends with 99 then all tagfiles with
	# the same prefix (without the 99) will be acknowledged
	
	# if the ack # ends with 99 then all tagfiles with
	# the same prefix (without the 99) will be acknowledged
	rcptid=`$EXPR $NUMBER % 100`
	if [ "$rcptid" -eq 99 ]
	then
		acknum=`$EXPR $NUMBER / 100`
	else
		acknum=$NUMBER
	fi

	$GREP -l "^$acknum" $BBTMP/np* 2>/dev/null | \
	while read file
	do 
	    set `$CAT $file` >/dev/null 2>&1
	    if [ "$#" -ge 2 ]
	    then
		host=$2
	    else
		host="not.found.in.tagfile"
	    fi
	    # Reset the file
	    $BBHOME/bin/touchtime $DELAY $file
	    echo "$1	$DELAY	$NUMBER	$file	$host	$MESSAGE" >> $BBHOME/www/acks/acklog
	done

	;;

    rm_event)

	args="$*"

	# 
	# GET PAGETYPE
	# THIS CODE IS ALSO IN bb-page1.sh
	# ANY CHANGES HERE MUST BE DONE THERE

	PAGETYPE="RCPT"
	pagetypeline=`$GREP "^pagetype:" $BBHOME/etc/bbwarnsetup.cfg` 2>/dev/null
	if [ "$?" -eq 0 ]
	then    
        	set $pagetypeline >/dev/null 2>&1
        	if [ "$#" -gt 1 ]
        	then
                	shift           # remove pagertype token from line
                	param="$1" 

                	# Check if it's a valid parameter,
                	# Set it if it's valid 

			case $param in

			RCPT | GROUP | HOST | EVENT )

				PAGETYPE=$param
				;;

			* )     
				;;      

			esac
		fi
	fi

	set $args >/dev/null 2>&1
	shift
	if [ "$#" -ne 2 ]
	then
	    echo "bb-doack.sh: rm_event has wrong arguments - $*"
	    echo "Usage: bb-doack.sh \"rm_event <host[.domain].service> <seconds down>\""
	    exit 1
	fi

	downsecs=$2

	# Save the event for page
	hostsvc=`echo "$1" | $SED 's/[^A-Za-z0-9.\,_-]//g'`
	# Reset "," in name if need be
	event=`echo $1 | $SED 's/,/./g'`

	# If FQDN is not set then tag file name has hostname and service
	# but no domain name.
	if [ "$FQDN" != "TRUE" ]
	then
	    OLDIFS=$IFS
	    IFS='.'
	    set $event
	    IFS=$OLDIFS
	    taginfo="$1"
	    arglast='$'"$#"
	    arglastval=`eval "echo $arglast"`
	    taginfo="${taginfo}.${arglastval}"
	else
	    taginfo=$event
	fi

	# if notify when problem is recovered (not at pagelevels colors anymore)
	pagerecoveredline=`$GREP "^pagerecovered:" $BBHOME/etc/bbwarnsetup.cfg` 2>/dev/null
	if [ "$?" -eq 0 ]
	then    
        	set $pagerecoveredline >/dev/null 2>&1
        	if [ "$#" -gt 1 ]
        	then
               		shift           # remove pagerecovered token from line
               		param="$1"
			if [ "$param" = "TRUE" ]
			then
				# Maybe I could call bb-page1.sh directly instead, ponder this 
				$BBHOME/bin/bb-page.sh  "$hostsvc recovered `date` Problem has been resolved after $downsecs seconds"
			fi
		fi
	fi

	# Save all transitions from bad to good :) From color in PAGELEVELS to color not in PAGELEVELS
	OLDIFS=$IFS
	IFS='.'
	set $hostsvc
	IFS=$OLDIFS
	arglast='$'"$#"
	svc=`eval "echo $arglast"`
	host=`echo $taginfo | $SED "s/\.$svc//"`
	echo "`$DATE` $host $svc `$BBHOME/bin/touchtime -e` $downsecs" >> $BBHOME/www/acks/recoveries.log

	# Only do when EVENT type notification is defined
	if [ "$PAGETYPE" = "EVENT" ]
	then
		# remove the tag file
		$FIND $BBTMP -name "np_*" -exec $GREP -l "$taginfo" {} \; | \
		while read file
		do
		    $RM -f $file
		done
	fi

	;;

    *)

	echo "usage: bb-doack.sh ack_event <ticket #> <delay>"
	echo "       bb-doack.sh rm_event <event> <seconds down>"
	echo "       where <event> is in the form [myhost,domain,com.conn|myhost.conn]"

	;;
esac
exit 0
