#!/bin/sh

# bb-network.sh
#
# BIG BROTHER NETWORK MONITORING SCRIPT
# Sean MacGuire - The MacLawran Group Inc.
# Version 1.3
# November 7, 1999
#
# This program is Copyright (c) 1997-1999
# The MacLawran Group Inc.
# All Rights Reserved
#
# SEND THE TEST RESULTS TO THE DISPLAY SERVER USING bb

# echo "***** BBHOME IS SET TO $BBHOME IN bb-net"
if test ! "$BBTMP"			# GET DEFINITIONS IF NEEDED
then
	. $BBHOME/etc/bbdef.sh		# INCLUDE STANDARD DEFINITIONS
fi

#
# SMM - NEW FOR 1.05
# ALLOW TESTING OF BANKS OF CONNECTIONS ONLY
# FORMAT OF THE LINE IS
# dialup name IP-ADDRESS COUNT
# dialup modem-bank1 132.220.50.1 16
#
$GREP "^dialup" $BBHOSTS |
while read line
do
	set $line
	if test "$#" != "4"
	then
		echo "MISSING ARGUMENTS FOR dialup"
		echo "Line format is:"
		echo "dialup pool-name start-ip count"
		exit 1
	fi
	NAME="$2"
	TTL="$4"
	set `echo $3 | $SED "s/\./ /g"`
	BASE="$1.$2.$3"
	START="$4"
	END=`$EXPR $START + $TTL - 1`
	# echo "NAME IS $NAME"
	# echo "TTL IS $TTL"
	# echo "BASE IS $BASE"
	# echo "START IS $START"
	# echo "END IS $END"
	LINE="FROM $BASE.$START TO $END DATA "
	while test "$START" -le "$END"
	do
		TEST="${BASE}.$START"
		# echo $TEST
		$PING $PINGPAR1 $TEST $PINGPAR2 > $BBTMP/BBPING 2>&1
		$GREP "bytes from" $BBTMP/BBPING > /dev/null 2>&1
		if test $? != "0"
		then
			LINE="$LINE clear "
		else
			LINE="$LINE green "
		fi
		START=`$EXPR $START + 1`
	done
	# echo "LINE IS $LINE"
	$BB $BBDISP "status dialup.${NAME} green `date` $LINE" 
done

$GREP "^[0-9]" $BBHOSTS |
while read line
do
	set $line
	HOSTIP=$1			# HOST IP ADDRESS
	FULLNAME=$2
	IPADDR=`echo $1 | $SED "s/\.//g"`
	#
	# SMM - NEW FOR 1.07c
	# IMPLICIT SUPPORT FOR dhcp STATIONS WHEN LISTED AS 0.0.0.0
	#
	if test "$HOSTIP" = "0.0.0.0"
	then
		PINGHOST=$FULLNAME	# SUPPORT PING BY NAME FOR DHCP ONLY
	else
		PINGHOST=$HOSTIP
	fi
	#
	# SMM - NEW FOR 1.04
	# USE FULLY QUALIFIED MACHINE NAMES?
	# DOT -> COMMA -> DOT FOR WEB DISPLAY
	#
	if test "$FQDN" = "TRUE"
	then
		set `echo $FULLNAME | $SED "s/\./,/g"`
	else
		set `echo $FULLNAME | $SED "s/\./ /"`
	fi
	MACHINE=$1

	#
	# SMM 1.09d - SUPPORT FOR ALIAS DISPLAY
	#
	echo "$line" | $GREP "[ 	]testip" > /dev/null 2>&1
	if [ "$?" = "0" ]
	then
		HOSTSTRING=$HOSTIP
	else
		HOSTSTRING=$FULLNAME
	fi

	#
	#================================================
	# CONNECTIVITY TEST
	# Added support for non-standard pings. gunnar@bitcon.no
	#
	# SMM: PING BY IP ADDRESS INSTEAD OF BY NAME. (v1.04a)
	# SMM: TRY THREE TIMES BEFORE PAGING (v1.06b)
	# 	BB SHOULD NOT BE A 3AM WAKE UP CALL...
	#================================================

	CONN_TEST_FAILED="FALSE"

	#
	# SMM 1.07
	# TO PING OR NOT TO PING
	# FIXED FALSE POSITIVES THANKS TO consult@netcom.com
	# SMM ADDED noconn KEYWORD
	#
	echo "$line" | $GREP "noconn" > /dev/null 2>&1
	ERR=$?
	if test "$ERR" != "0"
	then
		echo "$line" | $GREP "noping" > /dev/null 2>&1
		ERR=$?
	fi
	if test $ERR = "0"
	then
		COLOR="clear"			# PING TEST DISABLED BY REQUEST
		LINE="Ping test disabled by request (noping)"
	else
		COLOR="green"			# INNOCENT UNTIL PROVEN GUILTY...
		LINE="Connection OK"
		$PING $PINGPAR1 $PINGHOST $PINGPAR2 > $BBTMP/BBPING 2>&1
		ERR=$?
		if test $ERR = "0"		# DID IT REALLY PASS THE FIRST TEST...
		then
			$GREP "bytes from" $BBTMP/BBPING > /dev/null 2>&1
			ERR="$?"
		fi
	fi
	DIALUP=FALSE
	if test $ERR != "0"
	then
		echo "$line" | $GREP "dialup" > /dev/null 2>&1
		if test $? = "0"
		then
			COLOR="clear"
			LINE="bb-network.sh: $FULLNAME offline (dialup)"
			DIALUP="TRUE"
			CONN_TEST_FAILED="TRUE"
		else		# NON-DIALUP GETS 3rd STRIKE...
			sleep 1		# PAUSE... AND TRY AGAIN...
			$PING $PINGPAR1 $PINGHOST $PINGPAR2 > $BBTMP/BBPING 2>&1
			ERR=$?
			if test $ERR = "0"		# DID IT REALLY PASS THE SECOND TEST...
			then
				$GREP "bytes from" $BBTMP/BBPING > /dev/null 2>&1
				ERR=$?
			fi
			if test $ERR != "0"
			then
				sleep 2
				LINE="bb-network.sh: Can't ping $FULLNAME..."
				$PING $PINGPAR1 $PINGHOST $PINGPAR2 > $BBTMP/BBPING 2>&1
				ERR=$?
				if test $ERR = "0"	# PASSED THE THIRD TEST...
				then
					$GREP "bytes from" $BBTMP/BBPING >/dev/null 2>&1
					ERR=$?
				fi
                                if test $ERR != "0"     # THREE STRIKES...
                                then 
					CONN_TEST_FAILED="TRUE"
                                        echo "$NONETPAGE" | $GREP "ping" >/dev/null 2>&1
                                        if test $? = "1"        # NOT FOUND - PAGE
                                        then
						COLOR="red"
                                        else
                                        	COLOR="yellow"
                                        	LINE="$LINE - configured not to page"
					fi
                                else    # OK ON THIRD TRY... CAME BACK...
                                        COLOR="yellow"
                                        LINE="Connection OK on 3rd try..."
                                fi
			else	# OK ON THIRD TRY... CAME BACK...
				COLOR="yellow"	
				LINE="Connection OK on 2nd try..."
			fi
		fi
	fi
	#
	# SMM 1.2c
	# IF THERE'S A noconn SYMBOL - NO REPORT!
	#
	echo "$line" | $GREP "noconn" > /dev/null 2>&1
	if test "$?" != 0 
	then
		# Do we send clear status for noping & 0.0.0.0 ?
		# If so, continue on (we always send message when color != clear)
		if [ "$DIALUP" = "TRUE" -o "$COLOR" = "clear" -a "$NOPINGCLEAR" = "TRUE" -o "$COLOR" != "clear" ]
		then
			$BB $BBDISP "status ${MACHINE}.conn $COLOR `date` $LINE" 
		fi
	fi
	$RM -f $BBTMP/BBPING		# GET RID OF THE LEFTOVERS

	#
	# THIS IS NEW WITH 1.04... TEST FOR OTHER SERVICES HERE...
	# SEND THE RESULTS TO THE USUAL PLACE...
	#
	set $line			# GET ALL THE LINE ARGS
	shift; shift;			# SKIP THE IP-ADDR AND NAME

	if [ "$#" -ne 0 ]
	then
		newline=""
		httparg=""
		# REWRITE THE ARGUMENTS SUCH THAT http DIRECTIVES ARE BUNCHED TOGETHER
		while [ "$#" -ne 0 ]
		do
			case $1
			in
				http* )
					if [ "$httparg" = "" ]
					then
						httparg="$1"
					else
						httparg="${httparg}|${1}"
					fi
					;;
				* )
					newline="$newline $1"
					;;
			esac
		
			shift
		done
		set $newline $httparg
	fi
			
	while test "$1"			# AS LONG AS WE HAVE ARGS
	do
		line="$*"		# SAVE THIS..

		case $1 
		in
			*!* )
				arg=`echo $1 | $SED 's/!//g'`
				TESTREVERSED=TRUE
				;; 
			*)
				arg=$1
				TESTREVERSED=FALSE
				;;
		esac    

		case $arg
		in
			*~* )
				arg=`echo $arg | $SED 's/~//1'`
				REVERSE_IP_CLEAR=TRUE
				;; 
			*)
				arg=$arg
				REVERSE_IP_CLEAR=FALSE
				;;
		esac    

		case $arg
		in

		#
		# Add telnet test Tony DeJoie (tony@bellcore.com)
		# Add ssh test Kim Shrier (kim@tinker.com)
		#
		ssh* | telnet* | nntp* | ftp* | pop* | smtp* | imap* )	# OUR SERVICES
			#
			# OK... GET THE SERVICE NUMBER OUT OF /etc/services
			# CAN BE SEPERATED BY SPACES/TABS... (v1.04a)
			#
			OLDIFS=$IFS
			IFS=":"
			set $arg
			IFS=$OLDIFS
			SVCNAME=$1
			USEIP=$2
			SVC=""
			#
			# SMM 1.07a - 21 JUN 98
			# A LITTLE FRIENDLY CHECK HERE WILL SAVE LOTS OF GRIEF
			#
			SVCLINE=`$GREP "^${SVCNAME}[ 	]" /etc/services | $GREP "/tcp"`
			if test "$SVCLINE" = ""	# HOUSTON, WE HAVE A PROBLEM
			then
				echo "bb-network.sh: ERROR on bb-hosts line: $FULLNAME"
				echo "$SVCNAME NOT in /etc/services (CHECK SPELLING)"
				set $line
				shift;
				continue;
			fi

			set $SVCLINE

			while test "$SVC" = ""
			do
				echo $1 | $GREP "/tcp" > /dev/null
				if test "$?" = "0"
				then
					SVC=`echo $1 | $SED "s/\/tcp//"`
					#echo "FOUND SERVICE: $SVCNAME: $SVC"
				fi
				shift;
			done
			# echo "SETTING UP PROTOCOL SPECIFIC DATA"
			# By default bbnet sends "quit"
			case $SVCNAME
			in
				imap* )
					textmsg="* LOGOUT"
					;;
				*)
					textmsg="DONTUSEARGS"
					;;
			esac
			# echo "TESTING SERVICE $SVC"
			# if "" don't send any argument, use bbnet default
			RC=0
			if [ "$textmsg" != "DONTUSEARGS" ]
			then
				OUTPUT=`$BBHOME/bin/bbnet ${HOSTSTRING}:${SVC} "$textmsg"` 
				RC=$?
			else
				OUTPUT=`$BBHOME/bin/bbnet ${HOSTSTRING}:${SVC}` 
				RC=$?
			fi
			#
			# SMM - 1.09d
			# SUPPORT SERVICES EVEN WHEN THEY'RE NOT IN THE DNS
			#
			if test "$RC" = "1" -a "$HOSTSTRING" = "$FULLNAME"	# HOST NOT FOUND... TRY IP...
			then
				if [ "$textmsg" != "DONTUSEARGS" ]
				then
					OUTPUT=`$BBHOME/bin/bbnet ${HOSTIP}:${SVC} "$textmsg"` 
					RC=$?
				else
					OUTPUT=`$BBHOME/bin/bbnet ${HOSTIP}:${SVC}` 
					RC=$?
				fi
				OUTPUT="$OUTPUT
*** Note: $FULLNAME not found in DNS... Tested using IP addr directly..."
			fi

			# Check if service must NOT be running
			if [ "$TESTREVERSED" = "TRUE" ]
			then
				if [ "$RC" -ne 0 ]
				then
					RC=0
				else
					RC=1
				fi
			fi

			if test "$RC" != "0"
			then
				# echo "SERVICE IS BROKEN"
				#
				# IF IT'S BROKEN, THEN SCREAM IF WE HAVE TO
				#
				if [ "$TESTREVERSED" = "TRUE" ]
				then
					LINE="SERVER - $SVCNAME UP"
				else
					LINE="SERVER - $SVCNAME DOWN"
				fi

				#
				# NO MORE RED DOTS FOR DIALUP NETWORK STUFF
				# WHEN THE CONNECTION TEST FAILED
				# TESTREVERSED WILL ALWAYS YIELD YELLOW/RED HAS THE TEST REALLY CONNECTED ...
				#
				SET_TO_CLEAR="FALSE"
				if [ "$IPTEST_2_CLEAR_ON_FAILED_CONN" = "TRUE" -a "$REVERSE_IP_CLEAR" != "TRUE" ]
				then
					SET_TO_CLEAR="TRUE"
				elif [ "$IPTEST_2_CLEAR_ON_FAILED_CONN" = "FALSE" -a "$REVERSE_IP_CLEAR" = "TRUE" ]
				then
					SET_TO_CLEAR="TRUE"
				fi
				if [ "$CONN_TEST_FAILED" = "TRUE" -a "$TESTREVERSED" != "TRUE" -a "$SET_TO_CLEAR" = "TRUE" ]
				then
                                	COLOR="clear"
					LINE="$LINE (host offline)"
				else

					#
					# SMM NEW IN 1.07b
					# CORRECT TEST FOR NETWORK SERVICE PAGING
					# THANKS TO: Patrick Hopewell <p.hopewell@utoronto.ca>
					#
					echo "$NONETPAGE" | $GREP "$SVCNAME" > /dev/null 2>&1
					if test $? = "1"	# NOT FOUND - PAGE
                			then
                        			COLOR="red"
					else
                        			COLOR="yellow"
						LINE="$LINE - configured not to page"
					fi
				fi
			else
				COLOR="green"
				if [ "$TESTREVERSED" = "TRUE" ]
				then
					LINE="$SVCNAME OK: SERVICE IS NOT RUNNING"
				else
					LINE="$SVCNAME OK: $OUTPUT"
				fi
				# echo $OUTPUT
			fi
			$BB $BBDISP "status ${MACHINE}.${SVCNAME} $COLOR `date` $LINE" 
			;;

		#
		# NEW IN 1.06C 
		# DNS TESTING FROM Frank T. Kujawski <frank@bluegrass.net>
		#
		dns )	# echo "looking for domain server"
			if test "$HOSTIP" = "0.0.0.0"	# SMM 1.10 DDNS
			then
				$NSLOOKUP ${FULLNAME} ${FULLNAME} > /dev/null
			else
				$NSLOOKUP ${FULLNAME} ${HOSTIP} > /dev/null
			fi
			if test "$?" != "0"
			then
				LINE="DNS Server on ${FULLNAME} down"
				# IT HELPS TO SEARCH FOR THE RIGHT SERVICE!
				# Takahiro Yugawa <yugawa@itjit.ad.jp>
				echo "$NONETPAGE" | $GREP "dns" > /dev/null 2>&1
				if test $? = "1"	# NOT FOUND - PAGE
				then
					COLOR="red"
				else
					COLOR="yellow"
                                	LINE="$LINE - configured not to page"
				fi
			else
				COLOR="green"
				LINE="DNS Server OK"
			fi

			$BB $BBDISP "status ${MACHINE}.dns $COLOR `date` $LINE"

                        ;;

		#
		# SMM 1.2c - SUPPORT FOR https TESTING (finally)
		#
		http* )	# echo "DOING HTTP/HTTPS TEST..."
			OLDIFS=$IFS
			IFS='|'
			set $arg
			IFS=$OLDIFS
			URLS=$*
			COLOR="green"
			LINE=""
			for URL in $URLS
			do
				echo $URL | $GREP "^https" > /dev/null 2>&1
				if test "$?" = "0"	# USE LYNX FOR SECURE TESTING
				then
					HTTP="https"
					# echo "USING LYNX TO TEST $URL "
					$LYNX $URL > $BBTMP/HTTP 2>&1
				else
					HTTP="http"
					# echo "USING BBNET TO TEST $URL "
					$BBHOME/bin/bbnet $URL > $BBTMP/HTTP 2>&1
				fi
				if test "$?" != 0
				then
					TMPLINE="$URL - No connection"
					echo "$NONETPAGE" | $GREP "http" > /dev/null 2>&1
					if test $? = "1"	# NOT FOUND - PAGE
					then
						echo "$line" | $GREP "dialup" > /dev/null 2>&1
						if test $? = "0"
						then
							if [ "$COLOR" = "green" ]
							then
								COLOR="yellow"
							fi
        	                        		LINE="${LINE}

&yellow $TMPLINE (no page on dialup)"
						else
							COLOR="red"
        	                        		LINE="${LINE}

&red $TMPLINE"
						fi
					else
						if [ "$COLOR" = "green" ]
						then
							COLOR="yellow"
						fi
                                		LINE="${LINE}
&yellow $TMPLINE (configured not to page)"
					fi
				else
					#
					# CHECK FOR A SERVER ERROR HIDING HERE... CHECK FOR IT
					#

					#
					# THANKS TO: Douwe Dijkstra <D.Dijkstra@Twinfo.nl>
					# Version 1.04b
					#
					read HTTPVER RC STATUSMESSAGE < $BBTMP/HTTP
					case $RC in
    					'200'|'401'|'301'|'302')
         					TMPCOLOR="green"
						TMPLINE="Server OK"
         					;;
    					*)
						if [ "$COLOR" = "green" ]
						then
         						COLOR="yellow"
						fi
         					TMPCOLOR="yellow"
						TMPLINE="Server **NOT** OK"
         					;;
					esac
					#
					# SMM 1.07c - SEND http HEADERS ALONG
					#
					LINE="${LINE}
&$TMPCOLOR $URL - $TMPFILE
`cat $BBTMP/HTTP` "
					$RM -f $BBTMP/HTTP
				fi
			done
			$BB $BBDISP "status ${MACHINE}.http $COLOR  `date` $LINE"
			;;
		\# | BBPAGER | BBDISPLAY | BBNET | dialup | noping  | testip  )
			# These tags do nothing here
			;;
		* )
			# At one point this message will be enabled
			# NOPE, the directives will probably for external tests
			# echo "Invalid bb-hosts directive: $1"
			;;
		esac
		set $line		# RESTORE...
		shift;			# GET NEXT ARGUMENT
	done
done
