#!/bin/sh

# savelog.sh
#
# Robert-Andre Croteau
# Version 1.3
# November 7, 1999
#
# This program is Copyright (c) 1997-1999
# Robert-Andre Croteau, The MacLawran Group Inc.
# All Rights Reserved
#

if [ "$#" -ne 2 ]
then
	echo "Usage: keeplog.sh <filename> <date>"
	exit 1
fi

if [ ! -f "$1" ]
then
	echo "Usage: keeplog.sh <filename> <date>"
	exit 1
fi

filename=$1
date="$2"

OLDIFS=$IFS
IFS='/'
set $filename

shift `expr $# - 1`
IFS='.'
set $1
IFS=$OLDIFS

if [ "$#" -ne 2 ]
then
	echo "Usage: keeplog.sh <filename> <date>"
	exit 1
fi

fname=`echo $1 | $SED 's/,/_/g'`
dirname="$BBHOME/www/histlogs/${fname}"
subdirname="$dirname/$2"

if [ ! -d "$dirname" ]
then
	mkdir "$dirname"
	if [ "$?" -ne 0 ]
	then
		echo "Could not create $dirname"
		exit 1
	fi
fi

if [ ! -d "$subdirname" ]
then
	mkdir "$subdirname"
	if [ "$?" -ne 0 ]
	then
		echo "Could not create $subdirname"
		exit 1
	fi
fi

newfilename=`echo $date | $SED 's/ /_/g'`

$CAT $filename > $subdirname/${newfilename}

# Keep only the last 50 (same sumber as in the history module)

#cd $subdirname
#if [ "$?" -ne 0 ]
#then
#	echo "Could not chdir to $subdirname"
#	exit 1
#fi

#files=`$LS -t1 | $WC -l`

#if [ "$files" -gt 50 ]
#then
#	rmnumfiles=`expr $files - 50`
#	$RM -f `$LS -t1 | $TAIL -${rmnumfiles}`
#fi
