#!/bin/sh
#
# bbchkhosts.sh:	Check the host file for invalid entries
#
# The MacLawran Group Inc.
# Version 1.3
# November 7, 1999
#
# This program is Copyright (c) 1997-1999
# The MacLawran Group Inc.
# All Rights Reserved
#

# Check if the BB program paths are correct
#
exec < /dev/null

echo
echo "If any comments are displayed, please fix the entries in your configuration"
echo

grep "^[0-9]" ./bb-hosts |\
while read line
do
	# A config line needs at least two parameters
	set $line
	if [ "$#" -lt 2 ]
	then
		echo "bb-hosts: \"$line\" -- missing information"
		contiue
	fi
	numargs=$#
	arg1=$1
	shift
	arg99=$*
	OLDIFS=$IFS
	IFS=.
	set $arg1
	IFS=$OLDIFS
	# Is it a valid ip address
	if [ "$#" -ne 4 ]
	then
		echo "bb-hosts: \"$line\" -- invalid IP address"
		continue
	fi

	set $arg99
	
	arg1=$1
	shift
	arg99=$*
	# If FQDN is set, is the hostname valid
	if [ "$FQDN" = TRUE ]
	then
		OLDIFS=$IFS
		IFS=.
		set $arg1
		IFS=$OLDIFS
		if [ "$#" -lt 3 ]
		then
			echo "bb-hosts: \"$line\" -- invalid host name (FQDN=TRUE)"
			continue
		fi
	fi

	if [ "$numargs" -eq 2 ]
	then
		continue
	fi

	set $arg99
	
	arg1=$1
	shift
	arg99=$*
	# If the 3rd arg of cfg line is not a '#', then an alias was defined
	if [ "$arg1" != "#" ]
	then
		if [ "$FQDN" = "TRUE" ]
		then
			OLDIFS=$IFS
			IFS=.
			set $arg1
			IFS=$OLDIFS
			if [ "$#" -lt 3 ]
			then
				echo "bb-hosts: \"$line\" -- invalid alias name (FQDN=TRUE)"
				continue
			fi
		fi
	fi

	# Any more arguments ?
	if [ -z "$arg99" ]
	then
		continue
	fi

	for param in $arg99
	do
		case $param
		in

		http* | dns | BBNET | BBDISPLAY | BBPAGER | dialup | noping | testip | noconn )
			continue
			;;
		*)
			case $param
			in
				!* )
					param=`echo $param | sed 's/!//1'`
					;;
			esac
			grep "^${param}[ 	]" /etc/services >/dev/null 2>/dev/null
			if [ "$?" -ne 0 ]
			then
				echo "bb-hosts: \"$line\" -- invalid service ($param)"
			fi
			;;
		esac
	done
done
