#/bin/sh
#
# bbinc.sh
#
# Sean MacGuire - The MacLawran Group Inc. 
# Version 1.3
# November 7, 1999
# 
# This program is Copyright (c) 1997-1999
# The MacLawran Group Inc. 
# All Rights Reserved 
#

BBREL="1.3"
BBRELDATE="Wed, 10 Nov 1999 23:00:00 GMT"
export BBREL BBRELDATE

# --------------------------------------------------
# Big Brother - Pager codes and system definitions
#
# NO CHANGES SHOULD BE NEEDED HERE
# --------------------------------------------------
#
BB="${BBHOME}/bin/bb"			# WHERE bb LIVES
BBHOSTS="${BBHOME}/etc/bb-hosts"        # BIG BROTHER HOSTS FILE
BBDFTAB="${BBHOME}/etc/bb-dftab"	# LEVELS BY DISK PARTITION
BBLOGS="${BBHOME}/www/logs"             # WHERE THE LOG FILES LIVE
BBNOTES="${BBHOME}/www/notes"           # WHERE THE SYSTEM NOTES LIVE
export BB BBHOSTS BBDFTAB BBLOGS BBNOTES

NETERR="7"				# NETWORK ERROR 7 + PORT NUMBER
					# KEEP FOR BACKWARD COMPATABILITY
export NETERR

# --------------------------------------------------
# SMM NEW IN 1.3
# TITLES FOR DISPLAY ELEMENTS USED BY mkbb.sh
# THIS IS TO FACILITATE CHANGES AND TRANSLATION
# --------------------------------------------------
MKBBLOCAL="<B><I>Pages Hosted Locally</I></B>"
MKBBREMOTE="<B><I>Remote Status Display</I></B>"
export MKBBLOCAL MKBBREMOTE

# YOU CAN CHANGE FONT ATTRIBUTES FOR ROWS AND COLUMNS HERE
# THIS IS USED AS TITLES FOR THE TABLES
MKBBTITLE="COLOR=ivory SIZE=+1"

# THIS IS USED FOR THE MACHINE NAMES
MKBBROWFONT="SIZE=+1 COLOR=\"#FFFFCC\" FACE=\"Tahoma, Arial, Helvetica\""

# THIS IS USED FOR COLUMN HEADINGS ACROSS THE TOP
MKBBCOLFONT="COLOR=teal SIZE=-1"

export MKBBROWFONT MKBBCOLFONT MKBBTITLE

#
# FIGURE OUT THE LOCAL MACHINE NAME
# USE FULLY QUALIFIED MACHINE NAMES?
# DOT -> COMMA -> DOT FOR WEB DISPLAY
#

MACHINE=`uname -n`			# WHO ARE WE?  MAY NOT BE FQDN!

# New code 1.09 - RAC
#
# Extract the host part if not FQDN
if test "$FQDN" != "TRUE"
then
	set `echo $MACHINE | $SED "s/\./ /"` >/dev/null 2>&1
	MACHINE=$1
fi

set ""		# force a set or it will keep the old $* if it failed

# Do we match: "255.255.255.255 ${MACHINE}" ?
set `$GREP -i "^[0-9][0-9\.]*[ 	][ 	]*${MACHINE}$" $BBHOSTS` >/dev/null 2>&1
if test "$2" = ""
then
	# Do we match: "255.255.255.255 ${MACHINE} # blah blah blah" ?
	# Do we match: "255.255.255.255 ${MACHINE}.domain.com # blah blah blah" ?
	set `$GREP -i "^[0-9][0-9\.]*[ 	][ 	]*${MACHINE}[\. 	].*$" $BBHOSTS` >/dev/null 2>&1
fi

if test "$2" = ""
then
	echo "This host <${MACHINE}> was not found in the etc/bb-hosts file"
	echo "Please use the same name from 'uname -n'"
	exit 1
fi
# End of new code 1.09 - RAC

# SMM 1.09 - OFFLOAD CODE FROM RUNBB.SH 
# CHECK IF THIS MACHINE IS A BBDISPLAY

# echo "TESTING RESULTS FROM $*"

echo "$*" | $GREP BBDISPLAY > /dev/null 2>&1 
if test "$?" = "0"
then
	BBDISPLAY="TRUE"
	BBSERVER="TRUE"
fi

echo "$*" | $GREP BBPAGER > /dev/null 2>&1 
if test "$?" = "0"
then
	BBPAGER="TRUE"
	BBSERVER="TRUE"
fi

echo "$*" | $GREP BBNET > /dev/null 2>&1 
if test "$?" = "0"
then
	BBNET="TRUE"
fi

export BBDISPLAY BBSERVER BBNET

MACHINE=$2				# GET FQDN NAME FROM etc/bb-hosts
MACHIP=`echo $1 | $SED "s/\.//g"`	# IP ADDRESS FOR PAGER DISPLAY

if test "$FQDN" = "TRUE"
then
	MACHINE=`echo $MACHINE | $SED "s/\./,/g"`
else
	set `echo $MACHINE | $SED "s/\./ /"`
	MACHINE=$1
fi

export MACHINE MACHIP

#
# WHERE THE BIG BROTHER SERVERS LIVE
# LOOK IN bb-hosts FOR DISPLAY AND PAGER HOSTS
# SMM ADD SUPPORT FOR MULTIPLE BBDISPLAYS
#

bbline=`$GREP BBDISPLAY $BBHOSTS | $GREP "^[0-9]" | $GREP -v "^\#" | \
		$AWK '{print $1 " " $2}'` 2>/dev/null
if [ -z "$bbline" ]
then
	echo "*** FATAL ERROR: BBDISPLAY not set in etc/bb-hosts!"
	exit 2
fi

set $bbline
BBDISPLAYS=""

while [ "$#" -ne 0 ]
do
	if test "$1" = "0.0.0.0"		# SMM 1.10 DDNS SUPPORT
	then
		BBDISPLAYS="${BBDISPLAYS} $2" 	# USE THE NAME
	else	
		BBDISPLAYS="${BBDISPLAYS} $1"	# USE THE IP ADDR
	fi
	shift;shift				# Advance to next BBDISPLAY
done

BBDISPLAYS=`echo $BBDISPLAYS`

set $BBDISPLAYS
if test "$#" -eq 1
then
	BBDISP="$1"			# ORIGINAL FLAVOR...
	BBDISPLAYS=""
else
	BBDISP="0.0.0.0"		# DUMMY - DON'T USE...
fi

export BBDISP
export BBDISPLAYS		# bb EXECUTABLE USE THIS INSTEAD IF BBDISP = 0.0.0.0


# SMM ADD SUPPORT FOR MULTIPLE BBPAGERS

bbline=`$GREP BBPAGER $BBHOSTS | $GREP "^[0-9]" | $GREP -v "^\#" | \
		$AWK '{print $1 " " $2}'` 2>/dev/null
if [ -z "$bbline" ]
then
	# DEFAULT TO THE SAME THING AS BBDISPLAY
	BBPAGE=$BBDISP
	BBPAGERS=$BBDISPLAYS
else
	set $bbline
	BBPAGERS=""

	while [ "$#" -ne 0 ]
	do
		if test "$1" = "0.0.0.0"		# SMM 1.10 DDNS SUPPORT
		then
			BBPAGERS="${BBPAGERS} $2" 	# USE THE NAME
		else	
			BBPAGERS="${BBPAGERS} $1"	# USE THE IP ADDR
		fi
		shift;shift				# Advance to next BBPAGER
	done

	BBPAGERS=`echo $BBPAGERS`
	set $BBPAGERS
	if test "$#" -eq 1
	then
		BBPAGE="$1"			# ORIGINAL FLAVOR...
		BBPAGERS=""
	else
		BBPAGE="0.0.0.0"		# DUMMY - DON'T USE...
	fi
fi

export BBPAGE
export BBPAGERS		# bb EXECUTABLE USE THIS INSTEAD IF BBPAGE = 0.0.0.0


#
# GET PAGELEVELS FROM etc/bbwarnsetup.cfg. IT CONTAINS THE COLOR
# ON WHICH A NOTIFICATION SHOULD BE SENT
# IF YOU CHANGE THE VALUE pagelevels IN etc/bbwarnsetup.cfg YOU
# MUST RESTART BB.  MAKE SURE THE pagelevels VALUE IS
# IDENTICAL ON ALL CLIENTS
# Default colors are in bbdef.sh

pagelevelsline=`grep "^pagelevels:" $BBHOME/etc/bbwarnsetup.cfg` 2>/dev/null
if [ "$?" -eq 0 ]
then
        set $pagelevelsline >/dev/null 2>&1
        if [ "$#" -gt 1 ]
        then
                shift           # remove pagelevels token from line
                param="$*"

                # Check if it's a valid parameter, remove bad values

                PAGELEVELS=""
                for color in $param
                do
                        case $color in  
      
                        yellow | red | purple )

                                PAGELEVELS="$PAGELEVELS $color"
                                ;;

                        * )
                                ;;

                        esac
                done
        fi
fi
export PAGELEVELS

#echo "=====> 1) $MACHINE 2) $MACHIP 3) $BBDISP 4) $BBPAGE 5) $BBDISPLAYS 6) $BBPAGERS"
