#!/bin/sh

#
# bbsys.sh
#
# Sean MacGuire - The MacLawran Group Inc. 
# Version 1.3
# November 7, 1999
# 
# This program is Copyright (c) 1997-1999
# The MacLawran Group Inc. 
# All Rights Reserved 
#
# BIG BROTHER
# WHERE THINGS WE NEED LIVE...
#

#
# STANDARD COMMANDS...
#
NSLOOKUP="/usr/bin/nslookup"		# SMM NEW IN 1.06C
PING="/sbin/ping"			# CONNECTIVITY TEST
LS="/bin/ls"
FIND="/usr/bin/find"
TOUCH="/usr/bin/touch"
CAT="/bin/cat"
GREP="/usr/bin/grep"
SORT="/usr/bin/sort"
UNIQ="/usr/bin/uniq"
DATE="/bin/date"
TAIL="/usr/bin/tail"
SED="/usr/bin/sed"
UPTIME="/usr/bin/uptime"
WC="/usr/bin/wc -l"
WHO="/usr/bin/who"
RM="/bin/rm"
MAIL="/usr/bin/mail -s"		# MAIL WITH SUBJECT FOR PAGING
KERMIT="/usr/local/bin/kermit"	# WHERE kermit LIVES
ALPHAPGR="/usr/local/bin/qpage"	# WHERE qpage LIVES
DF="/bin/df"
EXPR="/usr/bin/expr"
HEAD="/usr/bin/head"

AWK=/usr/bin/awk        # Set AWK & GREP paths
EGREP=/usr/bin/egrep    # Make sure your egrep accepts -vx args and
                        # compound expressions (xxx.*|yyy.*|zzz.*disk)
                        # I think by default Solaris doesn't, so use the
			#   one in xpg4 - use bbsys.solaris as bbsys.local

#
# DISK INFORMATION
#
DFSORT="4"				# % COLUMN - 1
DFUSE="^/dev"				# PATTERN FOR LINES TO INCLUDE
DFEXCLUDE="cdrom"			# PATTERN FOR LINES TO EXCLUDE

#
# PING PARAMETERS
# Added by Gunnar Helliesen <gunnar@bitcon.no> to accomodate different
# styles of ping commands.
#
PINGPAR1="-c 1"
PINGPAR2=""

#
# LOCKFILE PREFIX
# added  by Jacob Lundqvist <jaclu@ibk.se> to handle queued paging
#
LOCKPREFIX="/var/lock/LCK.."

#
#  Lockfile indicating on-going kermit page
#
PAGINGLOCK=${BBTMP}/paginglock

#
# Qpage specific info
# Based on code by Mike Volk <Mike_Volk@pupress.princeton.edu>
#
QPAGE="/usr/local/bin/qpage"
QPAGEUSER="bb"
QPAGEARGS="-f bb"

#
# sendpage specific info
#
SENDPAGE="/usr/local/bin/sendpage"
SENDPAGEARGS=""

#
# LOCAL SYSTEM REDEFINES, BY OS...
#
. ${BBHOME}/etc/bbsys.local

#
# MAKE ALL OF THIS AVAILABLE...
#
export PING LS FIND TOUCH CAT GREP SORT UNIQ DATE TAIL SED UPTIME WC WHO RM EXPR HEAD
export AWK EGREP MAIL KERMIT ALPHAPGR
export DFSORT DFUSE DFEXCLUDE PS NSLOOKUP
export PINGPAR1 PINGPAR2
export LOCKPREFIX PAGINGLOCK
export QPAGE QPAGEUSER QPAGEARGS
export SENDPAGE SENDPAGEARGS
