/*
 *
 * bbd.c 
 * BIG BROTHER DAEMON PROGRAM
 * Sean MacGuire - The MacLawran Group Inc.
 * Version 1.3
 * November 7, 1999
 *
 * This program is Copyright (c) 1997-1999
 * The MacLawran Group Inc.
 * All Rights Reserved
 *
 * This daemon just listens on a port, accepts single lines of input
 * and handles them.  It doesn't send any acknowledgements back...
 *
 * Two types of actions are possible, depending on the content we get:
 *
 *	1.	Input for the display monitor
 *	2.	Request to send a page to the admin
 */


#include "bb.h"		/* THE BIG BROTHER INCLUDE FILE */
#include <errno.h>
#include <sys/stat.h>
#include <ctype.h>

unsigned long securedb[MAXLINE];	/* SECURITY DB LIVES HERE */

char bblogdir[MAXLINE];		/* DIRECTORY TO PUT LOG FILES INTO */
char bbhistdir[MAXLINE];	/* DIRECTORY TO PUT HISTORY FILES INTO */
char bbhtmldir[MAXLINE];	/* DIRECTORY TO PUT HTML FILES INTO */
char bbwebdir[MAXLINE];		/* DIRECTORY WHERE HTML STATUS PAGE's FOOTER & HEADER CAN BE FOUND */
char bbpid[MAXLINE];		/* BBD PID FILE */
char security[MAXLINE];		/* WHERE THE BBD SECURITY FILE LIVES */
char pager[MAXLINE];		/* BB-PAGER PROGRAM LOCATION */
char acker[MAXLINE];		/* BB-ACK PROGRAM LOCATION */
char bb[MAXLINE];		/* BB  PROGRAM LOCATION */
char *bbpage;			/* IP ADDRESS OF BB PAGER */
char savelogger[MAXLINE];	/* savelog.sh  PROGRAM LOCATION */

char *pagelevels;
char *webhistory;
char *cgibinwebhistory;
char *savestatuslog;

char *ipdotaddr;		/* IP address of the end connection in dot notation */
main(argc, argv)
int argc;
char *argv[];
{
 	int status, sockfd, newsockfd, child, port, len, ttllen;
        struct sockaddr_in serv_addr, cli_addr;
	static char linebuf[MAXLINE];
	static char msgbuf[MAXBUF];		/* INCOMING MESSAGE BUFFER */
	int on=1;
	unsigned long inc;
	char *bbhome;			/* WHERE ALL BB LIVES */
	FILE *bbf;

	debug("*** Starting bbd ***\n");
	bbpage=(char *)getenv("BBPAGE");
	if (!bbpage) {
		fprintf(stderr,"bbd: BBPAGE is not set in the environment!\n");
		fprintf(stderr,"Make sure you're running bbd from runbb.sh!\n");
		exit(1);
	}

	bbhome=(char *)getenv("BBHOME");
	if (bbhome) {
		len=strlen(bbhome);
		if (len > MAXLINE - 50) {		/* CHECK THIS... */
			fprintf(stderr,"bbd: BBHOME is too large - go away!\n");
			exit(1);
		}
        	sprintf(security, "%s/etc/security", bbhome);
		sprintf(bblogdir, "%s/www/logs", bbhome);
		sprintf(bbhistdir, "%s/www/hist", bbhome);
		sprintf(bbhtmldir, "%s/www/html", bbhome);
		sprintf(bbwebdir, "%s/web", bbhome);
		sprintf(bbpid, "%s/tmp/BBPID", bbhome);
		sprintf(pager, "%s/bin/bb-page.sh", bbhome);
		sprintf(acker, "%s/bin/bb-doack.sh", bbhome);
		sprintf(bb, "%s/bin/bb", bbhome);
		sprintf(savelogger, "%s/bin/savelog.sh", bbhome);
	}
	else {
		fprintf(stderr,"bbd: BBHOME is not set in the environment!\n");
		fprintf(stderr,"Make sure you're running bbd from runbb.sh!\n");
		exit(1);
	}

	pagelevels= (char *) getenv("PAGELEVELS");
	webhistory= (char *) getenv("WEBHISTORY");
	cgibinwebhistory= (char *) getenv("CGIBINWEBHISTORY");
	savestatuslog = (char *) getenv("SAVESTATUSLOG");

	/*
	 * BB SECURITY ENHANCEMENT
	 * ALLOW BB TO RESTRICT ACCESS BASED ON A LIST OF 
	 * NUMERIC HOSTS/MASKS LOCATED IN etc/security
	 */
	getsecurity();			/* GET VALID HOSTS AND MASKS */

	port = PORT;

        debug("MAKING SOCKET CONNECTION...\n");
        if ( (sockfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
                fprintf(stderr, "bbd: Can't open socket\n");
		exit(1);
        }
        debug("SOCKET CONNECTED OK...\n");

	/*
	 * FINALLY FIX THE REUSE BUGLET
	 * THANKS TO Gary Mills <mills@cc.UManitoba.CA>
	 */
	(void)setsockopt(sockfd, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof on);

        bzero((char *) &serv_addr, sizeof(serv_addr));
        serv_addr.sin_family = AF_INET;
        serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
        serv_addr.sin_port = htons(port);

        debug("BINDING TO SOCKET...\n");
        if (bind(sockfd,(struct sockaddr *)&serv_addr,sizeof(serv_addr))<0) {
		/* DON'T HARDCODE PORT NUMBER: frank@bluegrass.net */
                fprintf(stderr,"bbd: Can't bind to port %d - ", port);
		fprintf(stderr, "is bbd already running?\n");
		exit(2);
        }
        debug("SOCKET BOUND OK...\n");

        /*
	 * NOW THE PARENT EXITS AND THE CHILD DETACHES FROM THE CONTROLLING TTY
	 * SET UP TO IGNORE SIGNALS SENT BY EXITING CHILDREN
         */
        if ((child = fork()) != 0) {
        	debug("TRYING TO OPEN BBFILE %s\n", bbpid);
        	bbf = fopen(bbpid, "w");
		if (bbf) {
			fprintf(bbf, "%d ", child);
			fclose(bbf);
		}
		exit(0);             /* PARENT EXITS */
	}
	setsid();					/* RELEASE TTY */

#ifndef ZOMBIE
        signal(SIGCHLD, SIG_IGN);
#endif /* NO ZOMBIE */

	/*
	 * NOW SET UP THE LISTENING LOOP
         */
        listen(sockfd, 250);

        for ( ;; ) {
                len = sizeof(cli_addr);
                newsockfd = accept(sockfd,(struct sockaddr*)&cli_addr,&len);
  		/*
                 * SMM BBD SECURITY CHECK
                 */
                inc = cli_addr.sin_addr.s_addr;
                debug("INCOMING CONNECTION FROM: %u\n", inc);
		if (checksecurity(inc) == 0) { /* FAIL */
                	debug("SECURITY: %u\n", inc);
			close(newsockfd);
			continue;
		}

		/*
		 * THANKS TO Marc L. Allen (allen@chesapeake.rps.slb.com)
		 */

                if (newsockfd < 0 ) {
                        if (errno == EINTR) continue;
			else {
				/* 
				 * Jac Kersing *kersing@the-box.com)
				 * Just retry. Might be a killed client 
				 */
				sleep(5);
				continue;
			}
		}

		/*
		 * NOW FORK OFF AND LET THE CHILD HANDLE THE REQUEST
		 */
 		if ((child = fork()) < 0) die("fork error");

		if (child != 0) {			/* THE PARENT */
			close(newsockfd);
#ifdef ZOMBIE
			debug("WAIT FOR CHILD EXIT...\n");
			wait(&status);
			debug("CLEANED UP CHILD: %d\n", status);
#endif /* ZOMBIE */
		}
		else {					/* THE CHILD */
			close(sockfd); 
			/*
			 * NOW GET THE LINE FROM THE CLIENT
			 * AND HANDLE THE REQUEST...
			 * IGNORE BAD DATA...
			 * 1.07c ADDED SUPPORT FOR MESSAGES UP TO 8K
			 */
			ttllen = 0;
			memset(msgbuf,'\0',sizeof(msgbuf));
			memset(linebuf,'\0',sizeof(linebuf));
			debug("NEW INCOMING MESSAGE\n");
			while ( (len = recv(newsockfd, linebuf, MAXLINE - 1, 0)) && (ttllen != -1)) {
				linebuf[len]='\0';		/* FOR ANDREY */
				debug("MESSAGE LEN: %d MSG: [%s]\n", len, linebuf);
				ttllen += len;
				if (ttllen > (MAXBUF-1)) {
					ttllen -= len;
					len = MAXBUF-1 - ttllen - 30;
					if ( len > 0 ) {
						linebuf[len] = '\0';
						strcat(msgbuf,linebuf);
					}
					strcat(msgbuf, "\n\n... DATA TRUNCATED ...\n"); /* 25 chars ! */
					break;
				}
				else {
					strcat(msgbuf, linebuf);
					memset(linebuf,'\0',sizeof(linebuf));
				}
			}
			if (ttllen != 0) { 
				ipdotaddr = (char *)inet_ntoa( cli_addr.sin_addr );
				do_bb(msgbuf);
			}
			close(newsockfd);
                	exit(0);
		}
	}
}

/*
 * HANDLE INCOMING BIG BROTHER REQUESTS
 * PARSE THE LINE WE'VE RECEIVED AND HANDLE IT
 */
do_bb(req)
char *req;
{
	debug("REC'D: %s\n", req);
	/*
	 * IF THE REQUEST STARTS WITH "page" THEN CALL THE PAGING SCRIPT
	 * IF THE REQUEST STARTS WITH "status" THEN LOG THE MESSAGE
	 * IF THE REQUEST STARTS WITH "summary" THEN LOG THE MESSAGE
	 * OTHERWISE IGNORE IT (FOR SAFETY SAKE)
	 */
	if (strncmp(req, "page ", 5) == 0) {
		req += 5;			/* JUMP OVER page */
		debug("CALL PAGER: %s\n", req);
		/* Minor bugs spotted by */
		/* Andrew Dalgleish <andrewd@axonet.com.au> */
		if ( *req ) {
			/* Make sure pager was set */
			if (strcmp("/bin/bb-page.sh",pager)) {
				execlp(pager, pager, req, (char *)NULL);
				die("bbd: Could not execute bb-page.sh\n");
			}
			else die("PAGE FAILED!\n");
		}
		else {
			debug("NULL PAGE MSG IGNORED\n");
		}
	}
	else if (strncmp(req, "status ", 7) == 0) {
		req += 7;			/* JUMP OVER status */
		/* Minor bugs spotted by */
		/* Andrew Dalgleish <andrewd@axonet.com.au> */
		if ( *req ) {
			debug("LOG STATUS MSG: %s\n", req);
			bblog(req,"status");		/* LOG THE REQUEST */
		}
		else 
			debug("NULL STATUS MSG IGNORED\n");
	}
	else if (strncmp(req, "summary ", 8) == 0) {
		req += 8;			/* JUMP OVER summary */
		/* Minor bugs spotted by */
		/* Andrew Dalgleish <andrewd@axonet.com.au> */
		if ( *req ) {
			debug("LOG SUMMARY MSG: %s\n", req);
			bblog(req,"summary");		/* LOG THE REQUEST */
		}
		else {
			debug("NULL SUMMARY MSG IGNORED\n");
		}
	}
	else if (strncmp(req, "ack ", 4) == 0) {
		req += 4;                       /* JUMP OVER ack */
		debug("DO ACK: %s\n", req);
		/* Minor bugs spotted by */
		/* Andrew Dalgleish <andrewd@axonet.com.au> */
		if ( *req ) {
			/* Make sure acker is set */
			if (strcmp("/bin/bb-doack.sh",acker)) {
				execlp(acker, acker, req, (char *)NULL);
				die("bbd: Could not execute bb-doack.sh\n");
			}
			else die("ACK FAILED!\n");
		}
		else {
			debug("NULL ACK MSG IGNORED\n");
		}
	}
	else debug("IGNORE MESSAGE: %s\n", req);
}

/*
 * LOG A BIG BROTHER STATUS MESSAGE
 * THE MESSAGE GOES INTO THE DIRECTORY SPECIFIED BY BBLOG
 * MESSAGE FORMAT IS:
 * 	machine.area status message
 * 	summaryname.area summary message
 *
 * THE MESSAGE IS PLACED IN A FILE NAMED machine.area
 */

bblog(msg,msgtype)
char *msg;
char *msgtype;
{
        FILE *bbfile;
        FILE *bbhist;
        FILE *bbhtml,*bbhead,*bbfoot;
        int len,child, first, statres, msglen;
        char fname[MAXLINE];				/* FILENAME */
        char histname[MAXLINE];				/* HISTORY FILENAME */
        char htmlname[MAXLINE];				/* HTML FILENAME */
        char headname[MAXLINE];				/* HEADER FILENAME */
        char footname[MAXLINE];				/* FOOTER FILENAME */
	char oldcolor[MAXLINE];				/* FOR COLOR MATCHING */
	char newcolor[MAXLINE];
	char bbbkgfile[MAXLINE];
	char hostname[MAXLINE];
	char *bbhost,*bbsvc;
	char filename[MAXLINE];
	char tmpfilename[MAXLINE];
	char dur[MAXLINE];
	char sentby[MAXLINE];
	char request[MAXLINE];
	char htmlline[MAXLINE];
	long duration, timenow, lasttime, fwhere;	/* SMM */
	double f;
	struct stat *statbuf;
        char *name, *timebuf;
	char *ptrmsg,*nlmsg;
	int savelog;
	char savelog_cmd[MAXLINE];

	statbuf = (struct stat *) malloc(sizeof(struct stat));
	/*timebuf = (char *) malloc(64);*/

        if (bblogdir) {
                sscanf(msg, "%s %s", filename, newcolor);
		
                len = strlen(filename);       
                if (strlen(bblogdir) + len + 2 > MAXLINE)
                {
                        /* too large for allocated memory, skip it */
			debug("FILENAME TOO BIG - IGNORED\n");
                        return;
                }

                /* 
		 * THANKS TO Jac Kersing <J.Kersing@the-box.com>
		 * SMM: IGNORE ATTEMPTS TO WRITE TO PARENT DIRECTORIES
		 * AND CHECK FOR BUFFER OVERFLOWS
                 */
                name = (char *)strrchr(filename,'/');
                if (name != (char *)NULL) {		/* FOUND A FUNNY */
			debug("ILLEGAL FILE NAME - IGNORED\n");
			return;				/* GO AWAY */
		}

        	sprintf(fname, "%s/%s", bblogdir, filename);

		/*
		 * SMM BB 1.09: EVENT HISTORY AND DURATION
		 * IF THE COLOR OF AN INCOMING MESSAGE IS NOT THE SAME
		 * AS THE CURRENT STATUS, WRITE A LINE IN THE HISTORY
		 * FILE.  OTHERWISE JUST UPDATE THE LOG FILE WITH AN
		 * INDICATION OF THE DURATION OF THE CURRENT STATUS
		 */

		dur[0] = '\0';

		/* Don't do hist for summaries */
		if ( !strcmp(msgtype,"summary") ) {
			goto nohistpls;
		}

        	sprintf(histname, "%s/%s", bbhistdir, filename);

		oldcolor[0]='\0';		/* FOR ROB */

        	debug("TRYING TO OPEN BBFILE %s\n", fname);
        	bbfile = fopen(fname, "r");
		if (bbfile) {
			fscanf(bbfile, "%s", oldcolor);
			fclose(bbfile);
		}

		duration = 0;
		time(&timenow);			/* GET THE TIME */
		timebuf = ctime(&timenow);	/* CONVERT TO ASCII */
		*(timebuf + 24) = '\0';		/* LOSE THE NEWLINE */

		savelog=0;

		statres=stat(histname, statbuf);	/* HISTORY AVAILABLE? */

		if ((strcmp(oldcolor, newcolor) != 0) || (statres == -1)) {
			savelog=1;
        		debug("TRYING TO OPEN HISTORY FILE %s\n", histname);
			if (statres == -1)		/* CREATE IT */
        			bbhist = fopen(histname, "a+");
			else				/* OPEN IT */
        			bbhist = fopen(histname, "r+");

			if (bbhist) {
				/*
				 * ICKY THINGS HERE... BACK UP OVER THE
				 * OLD TIME, AND WRITE THE DURATION IN
				 * IT'S PLACE...
				 */
				fseek(bbhist, -11L, SEEK_END);
				fwhere=ftell(bbhist);
				if (fwhere > 0) {
					fscanf(bbhist, "%ld", &lasttime);
					fseek(bbhist, -11L, SEEK_END);
					fprintf(bbhist, " %ld %ld\n%s %s  %ld\n", lasttime, timenow - lasttime, timebuf, newcolor, timenow);
					debug("%s: FWHERE: %ld LASTIME %ld\n", histname, fwhere, lasttime);
				}
				else {
					fprintf(bbhist, "%s %s  %ld\n", timebuf, newcolor, timenow);
				}
				fclose(bbhist);
			}
			/*
			 * NOW FORK OFF AND LET THE CHILD HANDLE THE REQUEST
			 * Send a rm_event ack message to remove the tmp/np_* tagfile
			 * associated with this event as the color if not defined in
			 * in the PAGELEVELS variable (pagelevels token is bbwarnsetup.cfg)
			 * Also used for recovery message
			*/
			if( !pagelevels || (strlen(pagelevels) == 0) )
				pagelevels = PAGELEVELSDEFAULT; 
			if ( strstr(pagelevels,oldcolor) && !strstr(pagelevels,newcolor) ) {
				if ((child = fork()) < 0) die("fork error");
				/* child does work, thanks to svangari@uu.net */
				if (child == 0) {                       /* THE CHILD */
					sprintf(request,"ack rm_event %s %d",filename,timenow-lasttime);
					execlp(bb, bb, bbpage, request, (char *)NULL);
				}
				/* Parent continues */
			}
		}
		else {
			if (statres == 0) {
				duration = timenow - statbuf->st_mtime;
			}
		}
		/*
		 * FREE OUR LITTLE FRIENDS
		 */
		free(statbuf);

		if (duration > 86400) {
			f = duration / (double) 86400.00;
			sprintf(dur, "Status unchanged in %.2f days\n", f);
		}
		else if (duration > 3600) {
			f = duration / (double) 3600.00;
			sprintf(dur, "Status unchanged in %.2f hours\n", f);
		}
		else {
			f = duration / (double) 60.00;
			sprintf(dur, "Status unchanged in %.2f minutes\n", f);
		}

nohistpls:

		sprintf(sentby,"Status message received from %s\n",ipdotaddr);

        	debug("CREATING BBFILE %s\n", fname);
		/*
		 * THANKS TO: Andrey Alekseyev <fetch@muffin.arcadia.spb.ru> 
		 * More checking...
		 */
        	bbfile = fopen(fname, "w+");            /* APPEND IT */
		if (bbfile) {
        		msg += len + 1;                 /* SKIP FIRST ARGS */
        		debug("MSG IS %s....\n", msg);
        		fprintf(bbfile, "%s\n\n%s%s", msg, dur,sentby);   /* PUKE */
        		fclose(bbfile);                 /* CLOSE */
		}
		else {
			debug("FAILED TO OPEN STATUS FILE %s\n", bbfile);
		}

		/* Create an HTML version of the status file */

		strcpy(tmpfilename,filename);
		replacestr(tmpfilename,sizeof(tmpfilename),",",".");
        	sprintf(htmlname, "%s/%s.html", bbhtmldir, tmpfilename);
        	debug("CREATING HTML FILE %s\n", htmlname);
        	bbhtml = fopen(htmlname, "w");
		if (bbhtml) {

			/* Find the values of BBHOST / BBSVC 	*/
			/* filename:  xxx,domain,com.disk	*/
			/*            xxx.svc			*/
			/* BBHOST -> xxx.domain.com or xxx	*/
			/* BBSVC -> disk			*/
			strcpy(hostname,filename);
			bbsvc = (char *) strrchr(hostname,'.');
			if( bbsvc ) {
				*bbsvc = '\0'; /* NULL for bbhost */
				bbsvc++;
			}
			bbhost = hostname;
			while( bbhost=(char *)strchr(bbhost,',') )
				*bbhost = '.';
			bbhost=hostname;

			/* Open and read header file */
        		sprintf(headname, "%s/hostsvc_header", bbwebdir);
        		if( bbhead = fopen(headname, "r") ) {
				while( fgets( htmlline ,sizeof(htmlline)-1,bbhead) ) {
					replacestr(htmlline,sizeof(htmlline),"&BBDATE",timebuf);
					sprintf(bbbkgfile,"../gifs/bkg-%s.gif",newcolor);
					replacestr(htmlline,sizeof(htmlline),"&BBBACKGROUND",bbbkgfile);
					replacestr(htmlline,sizeof(htmlline),"&BBRELDATE",BBRELDATE);
					replacestr(htmlline,sizeof(htmlline),"&BBREL",BBREL);
					replacestr(htmlline,sizeof(htmlline),"&BBCOLOR",newcolor);
					replacestr(htmlline,sizeof(htmlline),"&BBHOST",bbhost);
					replacestr(htmlline,sizeof(htmlline),"&BBSVC",bbsvc);
					fprintf(bbhtml,"%s",htmlline);
				}
				fclose(bbhead);
			}
			else {
				fprintf(bbhtml,"\
<HTML><BODY>\n\
<HR size=4>\n\
<BR>%s was not found, please create this file with your custom header<BR>\n\
<HR size=4>\n\
",headname);
			}

			/* Now print generic stuff */

			fprintf(bbhtml,"\n\n<!-- Start of code generated by Big Brother Systems and Network Monitor -->\n\n");

			fprintf(bbhtml,"<BR><BR>\n");
			fprintf(bbhtml,"<CENTER><TABLE ALIGN=CENTER BORDER=0>\n");
			fprintf(bbhtml,"<TR><TH><FONT %s>\n", getenv("MKBBROWFONT"));
			fprintf(bbhtml,"%s - %s<BR><HR WIDTH=60%%></TH>\n",bbhost,bbsvc);
			fprintf(bbhtml,"<TR><TD><H3>\n");
			ptrmsg = msg;
			/* Add a newline at the end of the message if there isn't one */
			msglen = strlen(msg);
			if ( msg[msglen-1] != '\n' ) {
				msg[msglen+1] = '\0';
				msg[msglen] = '\n';
			}
			first = 0;
			while( nlmsg=(char *)strchr(ptrmsg,(int) '\n') ) {
				*nlmsg='\0';
				strcpy(htmlline,ptrmsg);
				replacestr(htmlline,sizeof(htmlline),"&green","<IMG SRC=\"../gifs/green.gif\" ALT=\"green\" HEIGHT=16 WIDTH=16>");
				replacestr(htmlline,sizeof(htmlline),"&red","<IMG SRC=\"../gifs/red.gif\" ALT=\"red\" HEIGHT=16 WIDTH=16>");
				replacestr(htmlline,sizeof(htmlline),"&yellow","<IMG SRC=\"../gifs/yellow.gif\" ALT=\"yellow\" HEIGHT=16 WIDTH=16>");
				replacestr(htmlline,sizeof(htmlline),"&purple","<IMG SRC=\"../gifs/purple.gif\" ALT=\"purple\" HEIGHT=16 WIDTH=16>");
				replacestr(htmlline,sizeof(htmlline),"&clear","<IMG SRC=\"../gifs/clear.gif\" ALT=\"clear\" HEIGHT=16 WIDTH=16>");
	        		fprintf(bbhtml, "%s\n", htmlline); /* PUKE message line */
				if (first == 0) {		/* FIRST LINE */
	        			fprintf(bbhtml, "</H3><PRE>\n");
					first = 1;
				}
				ptrmsg = nlmsg + 1;
			}

	        	fprintf(bbhtml, "%s", ptrmsg); /* PUKE message line */

			if (first == 0) {		
	        		fprintf(bbhtml, "</H3>\n");
			}
			else fprintf(bbhtml,"</PRE>\n");

			fprintf(bbhtml, "</TD></TR></TABLE>\n");

			fprintf(bbhtml, "<BR><BR>\n");

			fprintf(bbhtml,"<TABLE ALIGN=CENTER BORDER=0>\n");
			fprintf(bbhtml,"<TR><TD ALIGN=CENTER>\n");
			fprintf(bbhtml,"<FONT %s>\n", getenv("MKBBCOLFONT"));
        		fprintf(bbhtml, "%s<BR>", dur);   	/* PUKE  status unchanged */
        		fprintf(bbhtml, "%s", sentby);  /* PUKE  status from ip */
			fprintf(bbhtml,"</TD></TR>\n");
			fprintf(bbhtml,"</TABLE>\n");
			if ( webhistory && cgibinwebhistory && !strcmp(webhistory,"TRUE") ) {
				/* Changed ALT="HIST..." to NAME="HIST..." */
				/* Thanks to Andrew Dalgleish <andrewd@axonet.com.au> */
				fprintf(bbhtml,"<BR><BR><CENTER><FORM ACTION=\"%s/bb-hist.sh\"><INPUT TYPE=SUBMIT VALUE=\"HISTORY\"><INPUT TYPE=HIDDEN NAME=\"HISTFILE\" VALUE=\"%s\"><INPUT TYPE=HIDDEN NAME=\"BKG\" VALUE=\"%s\"></FORM></CENTER>\n",cgibinwebhistory,filename,newcolor);
			}
			else {
				fprintf(bbhtml,"<BR><BR><CENTER><A HREF=\"../hist/%s\"><B>HISTORY</B></a></CENTER>\n",filename);
			}

			fprintf(bbhtml,"</CENTER>\n\n<!-- End of code generated by Big Brother Systems and Network Monitor -->\n\n");

			/* Open and read footer file */
        		sprintf(footname, "%s/hostsvc_footer", bbwebdir);
        		if( bbfoot = fopen(footname, "r") ) {
				while( fgets( htmlline ,sizeof(htmlline)-1,bbfoot) ) {
					replacestr(htmlline,sizeof(htmlline),"&BBDATE",timebuf);
					sprintf(bbbkgfile,"../gifs/bkg-%s.gif",newcolor);
					replacestr(htmlline,sizeof(htmlline),"&BBBACKGROUND",bbbkgfile);
					replacestr(htmlline,sizeof(htmlline),"&BBRELDATE",BBRELDATE);
					replacestr(htmlline,sizeof(htmlline),"&BBREL",BBREL);
					replacestr(htmlline,sizeof(htmlline),"&BBCOLOR",newcolor);
					replacestr(htmlline,sizeof(htmlline),"&BBHOST",bbhost);
					replacestr(htmlline,sizeof(htmlline),"&BBSVC",bbsvc);
					fprintf(bbhtml,"%s",htmlline);
				}
				fclose(bbfoot);
			}
			else {
				fprintf(bbhtml,"<HR size=4><BR>%s was not found, please create this file with your custom footer<BR><HR size=4> ",footname);
			}

			fprintf(bbhtml,"<BR><BR><CENTER><H6><I><!-- By abiding to the license agreement you must leave the link back to BB --><FONT FACE=\"Arial, Helvetica\" COLOR=\"silver\"><A HREF=\"http://www.bb4.com\">Big Brother Systems &amp; Network Monitor %s </A><BR>Copyright &copy; 1997-1999 The MacLawran Group Inc<BR>All Rights Reserved</FONT></I></H6></CENTER></BODY></HTML>",BBREL);

	      		fclose(bbhtml);                 /* CLOSE */

			if ( savelog && savestatuslog && !strcmp(savestatuslog,"TRUE") ) {
				sprintf(savelog_cmd,"%s %s \"%s\"",savelogger,fname,timebuf);
				system(savelog_cmd);
			}
		}
		else {
			debug("FAILED TO OPEN HTML FILE %s\n", htmlname);
		}
	}
	else die("BB LOGGING DIRECTORY UNDEFINED\n");
}

/*
 * Replace a string by another
 * return an error code if string can't be inserted
 */

int replacestr(dst,dstmaxlen,from,to) 
char *dst;
int dstmaxlen;
char *from;
char *to;
{
char *realdst;
char *frompos;
char *dsttmp = NULL;

	debug("INTO REPLACESTR\n");

	realdst = dst;

	/* Dont work on null strings */
	if (!dst || !from || !to || (dstmaxlen == 0)) {
		debug("dst: [%s] from: [%s] to: [%s] dstmaxlen: [%d]\n",dst,from,to,dstmaxlen);
		return(1);
	}

	while( (frompos=(char *)strstr(dst,from)) ) {
		debug("match on [%s]\n",from);
		if( !dsttmp ) {
			dsttmp = (char *) malloc(dstmaxlen);
			/* Couldn't malloc */
			if( !dsttmp )
				return(2);
			memset(dsttmp,'\0',dstmaxlen);
		}
		/* Some strncpy barf on len = 0 */
		if( frompos-dst ) {
			*frompos = '\0';
			strcat(dsttmp,dst);
		}
		if( strlen(dsttmp) + strlen(to) > dstmaxlen ) {
			free(dsttmp);
			return(3);
		}
		strcat(dsttmp,to);
		dst = frompos + strlen(from);
		debug("dsttmp at this point: [%s], dst: [%s]\n",dsttmp,dst);
	}
	if( dsttmp ) {
		if( strlen(dsttmp) + strlen(dst) > dstmaxlen ) {
			free(dsttmp);
			return(3);
		}
		strcat(dsttmp,dst);
		strcpy(realdst,dsttmp);
		free(dsttmp);
	}

	debug("String returned: [%s]\n",dst);

	return(0);
}

/*
 * PUT AN ERROR INTO THE LOGFILE AND stderr AND DIE
 */
int die(msg)
char *msg;
{
        static char message[MAXLINE];
        sprintf(message, "bbd: %s\n", msg);

        syslog(LOG_DAEMON | LOG_CRIT , message);
        fprintf(stderr, message);
        exit(1);
}

/*
 * SMM: v.1.06b CLEAN THIS UP...
 * THANKS TO: Andrey Alekseyev <fetch@muffin.arcadia.spb.ru>
 * READS IN THE DATABASE OF IP ADDRESSES AND NETMASKS
 * FROM etc/security
 */
getsecurity() {
	FILE *sec;
	char line[MAXLINE];
	long iaddr;
	int cnt;

	debug("INTO GETSECURITY\n");
	cnt = 0;

	sec = fopen(security, "r");
	if (sec) {
		while(fgets(line, MAXLINE, sec)) {
			debug("LINE IS: %s\n", line);

			iaddr = inet_addr(line);
			if ((iaddr != -1)&&(cnt < MAXLINE - 1)) {
				debug("ADDING LINE %d %s\n", cnt, line);
				securedb[cnt] = iaddr;
				cnt++;
			}
			else debug("DISCARDING: %s\n", line);
		}
		fclose(sec);		/* CLOSE THE FILE */
	}
}

checksecurity(ipnum) 
unsigned long ipnum;
{
	int cnt = 0;
	int retval = 1;			/* TRUE */
	unsigned long chk;

	while (chk = securedb[cnt]) {
		retval = 0;		/* FALSE */
		debug("CHECKSECURITY CHECKING %u ", ipnum);
		debug("VS AUTHORIZED ADDR %u ", chk);
		/*
		 * SEEMS THE CAST TO (int) BREAKS THIS TEST ON Solaris 2.6
		 * FIXES FROM Henrik Stroem hstroem@pvv.org
		 */
		if ((ipnum & chk) == chk) {
			debug("------> PASSED\n");
			return(1);
		}
		else debug("--> FAILED\n");
		cnt++;
	}
	debug("CHECKSECUITY DEFAULT RETURNING %d\n", retval);
	return(retval);
}
