#!/bin/sh

# mkbb.sh
# SHELL SCRIPT TO MAKE THE NEW DISPLAY
# Sean MacGuire - The MacLawran Group Inc.
# Version 1.3
# Nov 07th, 1999
#
# This program is Copyright (c) 1997-1999
# The MacLawran Group Inc.
# All Rights Reserved

if test ! "$BBTMP"                      # GET DEFINITIONS IF NEEDED
then
        . $BBHOME/etc/bbdef.sh          # INCLUDE STANDARD DEFINITIONS
fi

#
# IF WE'RE CALLED WITH AN ARGUMENT, WE'RE IN A SUBPAGE
# THE ARGUMENT IS THE BACKGROUND COLOR OF THIS PAGE
# THE USEABLE PORTION OF THE etc/bb-hosts FILE NOW
# LIVES IN $BBTMP
#
if test "$#" = "1"
then
	# echo "WERE IN A SUBPAGE!"
	BBSUBPAGE="TRUE"
	BBBKG=$1
	BBHOSTS="$BBTMP/bb-hosts"; export BBHOSTS
else
	BBHOSTSTOTALLINES=`$CAT $BBHOSTS | $WC`
fi

BBDATE=`${DATE}`			# SET THE DATE
BBTIME=`${DATE} +%H:%M`			# SET THE TIME
BBSKIP=0
#
# FIND OUT IF WE HAVE ANY OLD DATA FILES LYING AROUND...
# touchtime is a C program that creates a file 30 minutes old
#

# For BB turn purple if the purple exceeded three times the check rate
timespan=`expr $BBSLEEP \* 3 \/ 60`

if [ "$?" -ne 0 ]
then
	timespan=30
fi

if test "$BBSUBPAGE" = ""
then
	$BBHOME/bin/touchtime -${timespan} ${BBLOGS}/.later	# MAKE THE TOUCH FILE
	$FIND $BBLOGS -type f ! -newer ${BBLOGS}/.later -print | $GREP -v .later | $GREP -v backup > $BBTMP/OLD.$$

	for file in `${CAT} $BBTMP/OLD.$$`
	do
		set -f			# disable globber
		set `${CAT} $file`
		set +f			# reenable globber
		COLOR=$1
		${CAT} $file | $SED "s/^${COLOR}/purple/"|$SED "/^Status unchanged/d" | $SED "/^Status message received from/d" >$BBTMP/NEW.$$
	#
	# SMM NEW FOR 1.08b - EVEN PURPLE SENDS MESSAGES VIA bbd
	# IF bbd IS DOWN, THOUGH, REVERT TO THE OLD WAY OF DOING
	# THINGS... THIS WAY THE HISTORY FILE WILL HANDLE PURPLE TOO...
	#
		set `echo $file | $SED "s/\//\ /g"`
		while test "$#" -gt 1		# THE basename COMMAND, IN SHELL...
		do
			shift;
		done
		FNAME=$1
	
		$BB $BBDISP "status $FNAME `${CAT} $BBTMP/NEW.$$`"
		if test $? != 0			# BAD THINGS IN BB LAND...
		then
			mv $BBTMP/NEW.$$ $file	# THE OLD WAY...
		else
			$RM $BBTMP/NEW.$$
		fi
	
	done
	$RM $BBTMP/OLD.$$

	#
	# RAC: NEW IN 1.09b 
	#       IF BBDISPLAY SENDS A SUMMARY MESSAGE TO ITSELF, REMOVE IT
	#	BEFORE THE BACKGROUND COLOR IS CHECKED
	#
	$CAT $BBHOSTS | $GREP "^summary" |
	while read line
	do
		set $line
		if [ "$3" = "$BBDISP" ]
		then
			$RM -f $BBLOGS/summary.$2
		fi
	done

	BBBKG=`${BBHOME}/web/mkbb.bkg`		# SET THE BACKGROUND COLOR
	BBBKG=`$CAT ${BBLOGS}/.bkg`		# GET THE BACKGROUND COLOR

	#
	# SMM: NEW IN 1.05 - SUPPORT FOR SENDING SUMMARY INFORMATION UPSTREAM
	# bb-hosts LINES OF THE FORMAT:
	#
	#	summary row.column	IP-ADDRESS-OF-PARENT	http://bb4.com/
	#	summary quebec.montreal	123.123.123.123 http://MacLawran.ca/bb/
	#
	$CAT $BBHOSTS | $GREP "^summary" |
	while read line
	do
		set $line
		BBNAME=$2
		BBSUMMARY=$3
		BBHTTP=$4
		$BB $BBSUMMARY "summary summary.${BBNAME} $BBBKG $BBHTTP $BBDATE"
	done
fi

ALLCOLS=`${BBHOME}/web/mkbb.cols`	# GET OUR COLUMN HEADINGS
COLMNS="$ALLCOLS"			# THANKS Rob!

#
# Thanks to "Alistair K. Birch" <birch@birch.de>
# who reminded me that Explorer needs Height and Width tags!
#
# SMM 1.10 - REMOVED THE PRAGMA BECAUSE IT BREAKS MORE
# THAN IT FIXES.  IT FORCES NETSCAPE 4.5 TO RE-GET EVERY
# LITTLE GIF ON THE PAGE (UGH)... THANKS TO:
# Henrik Olsen <henrik@iaeste.dk>
# <META HTTP-EQUIV=\"PRAGMA\" CONTENT=\"NO-CACHE\"> 
#

$CAT $BBHOME/web/bb_header | $SED "s/&BBRELDATE/$BBRELDATE/g" | $SED "s/&BBREL/$BBREL/g" |\
	 $SED "s/&BBDATE/$BBDATE/g" | $SED "s/&BBBACKGROUND/$BBBKG/g"

echo "
<CENTER>
"
    
#
# SMM 1.08
# GET TOTAL NUMBER OF COLUMNS
# DO THIS ONCE.
#
TOTCOL="1"
for column in $ALLCOLS
do
	TOTCOL=`expr $TOTCOL + 1`
done

BBHOSTLINE=0; export BBHOSTLINE

#
# FOR EACH HOST WE CARE ABOUT...
#
# echo "****  BBHOSTS IS $BBHOSTS"

$CAT $BBHOSTS | 
while read line
do
	BBHOSTLINE=`expr $BBHOSTLINE + 1`
	if test "$BBHOSTLINE" -le "$BBSKIP"
	then
		continue
	fi
	# echo "BBHOSTLINE: $BBHOSTLINE"

	# For an lower level instance, Don't print our own host
	echo "$line" | $GREP BBDISPLAY >/dev/null 2>&1
	if test "$?" = "0" -a "$BBGROUP" != ""
	then
		continue
	fi

	# For a lower level instance, Don't print our own host
	echo "$line" | $GREP BBPAGER >/dev/null 2>&1
	if test "$?" = "0" -a "$BBGROUP" != ""
	then
		continue
	fi

	# For a lower level isntance, Don't print our own host
	echo "$line" | $GREP BBNET >/dev/null 2>&1
	if test "$?" = "0" -a "$BBGROUP" != ""
	then
		continue
	fi

	#
	# FIX THIS LINE SOONER OR LATER - THE > /dev/null BREAKS ON
	# DEC ULTRIX.  GREAT EH?
	#
	set $line > /dev/null			# SMM 1.06a ENV DISPLAY BUG!

	#
	# SMM 1.10 SUPPORT FOR MULTIPLE DISPLAY PAGES
	# FORMAT page NAME
	#
	echo $1 | $GREP "^page" > /dev/null	# IT'S A PAGE LINE
	if test "$?" = "0"
	then
		# THE ONLY WAY OUT OF A SUBPAGE IS EOF
		# THE mkbb.page SCRIPT ENSURES THIS.
		if test "$BBSUBPAGE"=""
		then
			BBPAGENAME="$2"; export BBPAGENAME
			shift;shift;
			BK=`$BBHOME/web/mkbb.page $BBHOSTLINE`

			if test "$NAME" != ""		# CLOSE OFF TABLE
			then
				echo "</TABLE><BR><BR>"
				NAME=""
			fi

			#
			# IF THIS IS OUR FIRST SUBPAGE, MAKE THE TABLE
			#
			if test "$FIRSTPG" = ""
			then
				FIRSTPG="DONE"
				echo "<TABLE BORDER=0><TR>"
				echo "<TD COLSPAN=2><CENTER>"
				echo "<FONT $MKBBTITLE>"
				echo "$MKBBLOCAL"
				echo "</CENTER></TD></TR><TR><TD COLSPAN=2>"
				echo "<HR WIDTH=100%></TD></TR>"
			fi
			echo "<TR><TD><FONT $MKBBROWFONT>"
			echo "$*</TD>"
			echo "<TD><CENTER><A HREF=\"$BBPAGENAME.html\">"
			echo "<IMG SRC=\"gifs/$BK.gif\" WIDTH=16"
			echo "HEIGHT=16 BORDER=0 ALT=\"$BK\"></A>"
			echo "</CENTER></TD></TR>"

			OLDBBHOSTLINE=$BBHOSTLINE
			unset BBHOSTLINE
			$BBHOME/web/mkbb.sh $BK > $BBTMP/$BBPAGENAME.$$
			mv $BBTMP/$BBPAGENAME.$$ $BBHOME/www/$BBPAGENAME.html
			BBHOSTLINE=$OLDBBHOSTLINE
			$RM -f $BBTMP/bb-hosts
			BBSKIP=`cat $BBTMP/BBSKIP`
			# Are we at end of file ?
			if [ $BBSKIP -ge $BBHOSTSTOTALLINES ]
			then
				break
			fi
			BBSKIP=`expr $BBSKIP - 1`
			# echo "NOW ON LINE NUMBER $BBSKIP"
			continue
		fi
	fi

	#
	# SMM 1.06a SUPPORT FOR GROUPING THINGS TOGETHER
	# IF THE LINE STARTS WITH THE WORD group THEN
	# A NEW TABLE IS CREATED WITH THE REST OF THE LINE
	# AS THE CENTERED LABEL, i.e.
	# group Web and Mail Servers
	#
	# SMM 1.08 SUPPORT FOR COMPRESSED GROUPINGS
	# IF THERE IS ONLY ONE COLUMN IN THE GROUP, DISPLAY THEM
	# ACROSS THE SCREEN, OTHERWISE JUST ELIMINATE UNNEEDED COLUMNS
	#
	echo $1 | $GREP "^group" > /dev/null	# IT'S A GROUP LINE
	if test "$?" = "0"
	then
		echo $1 | $GREP "^group-compress" > /dev/null
		if test "$?" = "0" 
		then				# COMPRESS COLUMNS
			COLMNS=`${BBHOME}/web/mkbb.cols $BBHOSTLINE`
			TOTCOLS="1"
			for column in $COLMNS
			do
				TOTCOLS=`expr $TOTCOLS + 1`
			done
		else				# ALL COLUMNS
			COLMNS="$ALLCOLS"
			TOTCOLS="$TOTCOL"
		fi
		XCOLS=`expr $TOTCOLS - 1`	# SMM NEW...

		if test "$NAME" != ""		# CLOSE OFF TABLE
		then
			echo "</TABLE><BR><BR>"
		fi
		shift;				# GET RID OF group
		echo "<TABLE SUMMARY=\"Group Block\" BORDER=0><TR><TD VALIGN=MIDDLE ROWSPAN=2 CELLPADDING=2>"
		echo "<FONT $MKBBTITLE><CENTER>$*</CENTER></TD>"

		for column in $COLMNS		# REDISPLAY HEADERS
		do
                        echo "<TD ALIGN=CENTER VALIGN=BOTTOM WIDTH=45>"

                        if test -f "$BBHOME/www/help/${column}.html"
                        then
                                echo "<A HREF=\"help/${column}.html\">"
                        else
                                echo "<A HREF=\"help/bb-help.html#${column}\">"
                        fi

			echo "<FONT $MKBBCOLFONT><B>$column</B></A></TD>"
		done
		TOP="DONE"			# SMM FOR TOP LINE DISP
		echo "</TR>
		<TR><TD COLSPAN=$XCOLS><HR WIDTH=100%></TD></TR>"
		continue;
	else					# BETTER BE AN IP ADDR
		echo $1 | $GREP "^[0-9]" > /dev/null
		if test "$?" = "1"		# NOT VALID
		then
			continue;		# SKIP TO NEXT ONE
		fi

		#
		# SMM 1.06a
		# WE MAY NOT HAVE A group DIRECTIVE THAT CREATED
		# THE TABLE.  HANDLE IT HERE.
		#
		if test "$TOP" = ""		# TOP LINE NOT DONE
		then
			echo "<TABLE BORDER=0><TR><TD></TD>"
			for column in $COLMNS
			do
                        	if test -f "$BBHOME/www/help/${column}.html"
                        	then
                                	echo "<TD ALIGN=CENTER VALIGN=BOTTOM WIDTH=45>
                                	<A HREF=\"help/${column}.html\">
					<FONT $MKBBCOLFONT>
                                	<B>$column</B></A></TD>"
                        	else
                                	echo "<TD ALIGN=CENTER VALIGN=BOTTOM WIDTH=45>
                                	<A HREF=\"help/bb-help.html#${column}\">
					<FONT $MKBBCOLFONT>
                                	<B>$column</B></A></TD>"
                        	fi
			done
			TOP="DONE"
			echo "</TR>"
		fi
	fi

	#
	# NEW FOR 1.04 - SUPPORT FOR FQDN's
	# NOT CENTERED...
	#
	if test "$FQDN" != ""
	then
		FNAME="$2"
		echo "<TR><TD><FONT $MKBBROWFONT>"
		NAME=`echo $2 | $SED "s/\./,/g"`
	else
		set `echo $2 | $SED "s/\./ /"`
		NAME=$1
		FNAME="$NAME"
		echo "<TR><TD ALIGN=CENTER><FONT $MKBBROWFONT>"
	fi

	#
	# PUT A LINK IN FOR SYSTEM NOTES IF WE HAVE ANY
	# THIS IS A GOOD PLACE TO PUT INVENTORY INFO
	# SMM NEW IN 1.05: SUPPORT FOR .html and .htm EXTENSIONS
	# DON'T ASK FOR UPPERCASE EXTENSIONS.  EVER.
	#
	if test -f "${BBNOTES}/${FNAME}.html"
	then
		echo "<A HREF=notes/${FNAME}.html> $FNAME</FONT></A></TD>"
	elif test -f "${BBNOTES}/${FNAME}.htm"
	then
		echo "<A HREF=notes/${FNAME}.htm> $FNAME</FONT></A></TD>"
	elif test -f "${BBNOTES}/${FNAME}"
        then
		echo "<A HREF=notes/$FNAME> $FNAME</FONT></A></TD>"
	else
		echo "$FNAME</FONT></TD>"
	fi

	#
	# FOR EACH OF THE THINGS WE MONITOR...
	#
	for column in $COLMNS
	do
		if test -f "$BBLOGS/${NAME}.${column}"
		then
			set `${CAT} ${BBLOGS}/${NAME}.${column}` >/dev/null 2>&1
			if [ -d "$BBHOME/www/html" ]
			then
				echo "<TD ALIGN=CENTER><A HREF=\"html/${FNAME}.${column}.html\">
					<IMG SRC=\"gifs/$1.gif\" ALT=\"${column}:$1\" HEIGHT=16 WIDTH=16 BORDER=0></A></TD>"
			else
				echo "<TD ALIGN=CENTER><A HREF=\"logs/${NAME}.${column}\">
					<IMG SRC=\"gifs/$1.gif\" ALT=\"${column}:$1\" HEIGHT=16 WIDTH=16 BORDER=0></A></TD>"
			fi
			
		else
		echo "<TD ALIGN=CENTER>-</TD>"
		fi
	done
	echo "</TR>"
done
echo "</TABLE><BR><BR>"				# END OF TABLE

#
# CLOSE OFF TABLE
#
if test "$FIRSTPG" != ""
then
	echo "</TABLE><BR><BR>"
fi


#
# SMM NEW IN 1.05 - SUPPORT FOR DISPLAY OF SUMMARY INFORMATION
#
if test "$BBSUBPAGE" = ""
then
	# SMM 1.2
	# TIDY UP...
	#
	$RM -f $BBTMP/BBSKIP

	cd ${BBLOGS}
#	sumfiles=`$LS ${BBLOGS}/summary* 2> /dev/null| $SORT`
	sumfiles=`$LS summary* 2> /dev/null| $SORT`
	cd ${BBHOME}
	if [ -n "$sumfiles" ]
	then
		# echo "**** $sumfiles ****"
		for line in $sumfiles
		do
			if test "$BBSUMHDR" != "TRUE"
			then
				BBSUMHDR="TRUE"
				echo "<TABLE BORDER=0><TR><TD>"
				echo "<FONT $MKBBTITLE><CENTER>"
				echo "$MKBBREMOTE"
				echo "</CENTER></TD></TR><TR><TD>"
				echo "<HR WIDTH=100%></TD></TR>"
				echo "<TR><TD><TABLE BORDER=0>"
			fi
			set `echo $line | $SED "s/\./ /g"`
			ROW=$2
			COL=$3

			#
			# HANDLE THE ROW DISPLAY 
			#
			if test "$ROW" != "$LASTROW"		# WE HAVE A NEW ROW...
			then
				if test "$LASTROW" != ""
				then
					echo "</TR>"
				fi

				#
				# SMM: NEW IN 1.06a
				# SUPPORT FOR NOTES IN THE SUMMARY LINES
				# VIA: David Fordyce <fordyce@ite1.dseg.ti.com>
				#
				echo "<TR><TD>"
				echo "<FONT $MKBBROWFONT>"
	
				if test -f "${BBNOTES}/${ROW}.html"
				then
					echo "<A HREF=notes/${ROW}.html>$ROW</A></TD>"
				elif test -f "${BBNOTES}/${ROW}.htm"
				then
					echo "<A HREF=notes/${ROW}.htm>$ROW</A></TD>"
				elif test -f "${BBNOTES}/${ROW}"
        			then
					echo "<A HREF=notes/$ROW>$ROW</A></TD>"
				else
					echo "$ROW</TD>"
				fi

				LASTROW="$ROW"
			fi
			#
			# HANDLE THE COLUMN DISPLAY
			#
			echo "<TD WIDTH=45 ALIGN=CENTER>$COL<BR>"	# COLUMN TITLE
			set `$CAT ${BBLOGS}/summary.${ROW}.${COL}`
			echo "<A HREF=$2><IMG SRC=\"gifs/$1.gif\" ALT=\"$1\" HEIGHT=16 WIDTH=16 BORDER=0></A></TD>"
		done
		echo "</TR></TABLE>"
		echo "</TD></TR></TABLE>"
	fi

#
# SMM NEW IN 1.05 - SUPPORT FOR MONITORING MODEM BANKS
#
	echo "<P><TABLE BORDER=0>"
	$CAT $BBHOSTS | $GREP "^dialup" |
	while read line
	do
		set $line
	
		FNAME=$2
	
		#
		# PUT IN A LINK...
		#
		echo "<TR><TD><FONT $MKBBROWFONT>" 	# MAKE A NEW ROW...
		if test -f "${BBNOTES}/${FNAME}.html"
		then
			echo "<A HREF=notes/${FNAME}.html> $FNAME</A></TD>"
		elif test -f "${BBNOTES}/${FNAME}.htm"
		then
			echo "<A HREF=notes/${FNAME}.htm> $FNAME</A></TD>"
		else
			echo "$FNAME</TD>"
		fi
	
		if test -f "$BBLOGS/dialup.${FNAME}"
		then
			set `$CAT $BBLOGS/dialup.${FNAME}` >/dev/null 2>&1
			while test "$1" != "DATA"
			do
				shift;
			done
			shift;		# GO PAST THE DATA LINE
			#
			# NOW MAKE NICE PICTURES
			#
			while test "$1" != "Status"	# SMM 1.08b - STOP AT Status
			do
				if [ -d "$BBHOME/www/html" ]
				then
					echo "<TD ALIGN=CENTER><A HREF=\"html/dialup.${FNAME}.html\">"
					echo "<IMG SRC=\"gifs/$1.gif\" ALT=$1 HEIGHT=16 WIDTH=16 BORDER=0></A>"
					echo "</TD>"
				else
					echo "<TD ALIGN=CENTER><A HREF=\"logs/dialup.${FNAME}\">"
					echo "<IMG SRC=\"gifs/$1.gif\" ALT=$1 HEIGHT=16 WIDTH=16 BORDER=0></A>"
					echo "</TD>"
				fi
				shift;
			done
			echo "</TR>"
		fi
	done
	echo "</TABLE>"
fi

echo "
</CENTER>
"
    
#
# SMM NEW IN 1.04 - STANDARD FOOTER
#
if test -f "$BBHOME/web/bb_footer"
then
	$CAT $BBHOME/web/bb_footer | $SED "s/&BBRELDATE/$BBRELDATE/g" | $SED "s/&BBREL/$BBREL/g" |\
		$SED "s/&BBDATE/$BBDATE/g" | $SED "s/&BBBACKGROUND/$BBBKG/g"
fi

echo "
</BODY></HTML>"		# END OF HTML DOCUMENT
