#!/bin/sh

# mkbb2.sh
# SCRIPT TO MAKE THE BIG BROTHER SUMMARY WEB PAGE
# Sean MacGuire - The MacLawran Group Inc.
# Version 1.3
# Nov 07th, 1999
#
# This program is Copyright (c) 1997-1999
# The MacLawran Group Inc.
# All Rights Reserved

if test ! "$BBTMP"                      # GET DEFINITIONS IF NEEDED
then
        . $BBHOME/etc/bbdef.sh          # INCLUDE STANDARD DEFINITIONS
fi

BBDATE=`${DATE}`			# SET THE DATE
BBTIME=`${DATE} "+%a %b %d @ %H:%M"`	# SET THE TIME
${BBHOME}/web/mkbb.bkg			# SET THE BACKGROUND COLOR
BBBKG=`$CAT ${BBLOGS}/.bkg`		# GET THE BACKGROUND COLOR

$CAT $BBHOME/web/bb2_header | $SED "s/&BBRELDATE/$BBRELDATE/g" | $SED "s/&BBREL/$BBREL/g" |\
         $SED "s/&BBDATE/$BBDATE/g" | $SED "s/&BBBACKGROUND/$BBBKG/g"

echo "
<CENTER>
"
if test -s $BBTMP/BB
then

	#
	# SMM - NEW FOR 1.08
	# DISPLAY ONLY NON-GREEN COLUMNS
	#
	COLMNS=`${BBHOME}/web/mkbb.cols 0` 	# GET OUR COLUMN HEADINGS 

	if test "$COLMNS"			# ONLY DO THIS IF WE HAVE TO
	then
		echo "<TABLE BORDER=0><TR><TD COLSPAN=2 ALIGN=CENTER></TD>"

		COLNUM=1

		for col in $COLMNS
		do
        		echo "<TD ALIGN=CENTER WIDTH=45>"
			echo "<FONT $MKBBCOLFONT><B>$col</B></TD>"
			COLNUM=`expr $COLNUM + 1`
		done
		echo "</TR>"				# END THE ROW
		echo "<TR><TD></TD><TD></TD><TD COLSPAN=$COLNUM><HR></TD></TR>"

		#
		# FOR EACH UNIQUE HOST WE CARE ABOUT
		# EXCEPT THE SUMMARY FILES...
		#
		$CAT $BBTMP/BB | $GREP -v "summary" | $SORT |
		while read line
		do
			set `basename $line | $SED "s/\./ /" `
			if test "$NAME" = $1
			then
				continue;		# ALREADY DEALT WITH THIS
			else
				NAME=$1			# IT'S A NEW ONE...
			fi
		
			if test "$FQDN" != ""
			then
				FNAME=`echo $NAME | $SED "s/\,/\./g"`
				echo "<TR><TD COLSPAN=2>"
			else
				FNAME=$NAME
				echo "<TR><TD COLSPAN=2 ALIGN=CENTER>"
			fi

			echo "<FONT $MKBBROWFONT>"

			#
			# ADD HOOK FOR CUSTOM FILES HERE
			#
	
			if test -f "${BBNOTES}/${FNAME}.html"
        		then
                  	echo "<A HREF=notes/${FNAME}.html> <B>$FNAME</B></A></TD>"
        		elif test -f "${BBNOTES}/${FNAME}.htm"
        		then
               	  	echo "<A HREF=notes/${FNAME}.htm> <B>$FNAME</B></A></TD>"
			elif test -f "${BBNOTES}/${FNAME}"
			then
		  	echo "<A HREF=notes/$FNAME> <B>$FNAME</B></A></TD>"
        		else
                		echo "<B>$FNAME</B></TD>"
        		fi
		
			#
			# FOR EACH OF THE THINGS WE MONITOR...
			#
			for col in $COLMNS
			do
				if test -f ${BBLOGS}/$NAME.$col
				then
					set `${CAT} ${BBLOGS}/$NAME.$col`
					if [ -d "$BBHOME/www/html" ]
					then
						echo "<TD ALIGN=CENTER>
							<A HREF=\"html/${FNAME}.${col}.html\">
							<IMG SRC=\"gifs/$1.gif\"  ALT=\"${col}:$1\"
							HEIGHT=16 WIDTH=16 BORDER=0></A></TD>"
					else
						echo "<TD ALIGN=CENTER>
							<A HREF=\"html/$NAME.${col}\">
							<IMG SRC=\"gifs/$1.gif\"  ALT=\"${col}:$1\"
							HEIGHT=16 WIDTH=16 BORDER=0></A></TD>"
					fi
				else
					echo "<TD ALIGN=CENTER>-</TD>"
				fi
			done
			echo "</TR>"
		done
		#
		# Ruediger Schuetz (Ruediger.Schuetz@Munich.Netsurf.DE)
		# Fixed bad table ending....
		#
		echo "</TABLE>"

	fi
	#
	# NOW HANDLE SUMMARY INFO
	#

	cd ${BBLOGS}
#	sumfiles=`$LS ${BBLOGS}/summary* 2> /dev/null| $SORT`
	sumfiles=`$LS summary* 2> /dev/null| $SORT`          
	cd ${BBHOME}
	if [ -n "$sumfiles" ]
	then
		echo "<BR><BR>"
		# echo "**** $sumfiles ****"
		for line in $sumfiles
		do
			if test "$BBSUMHDR" != "TRUE"
			then
				BBSUMHDR="TRUE"
				echo "<TABLE BORDER=0>"
#				echo "<TR><TD>"
#				echo "<HR WIDTH=100%></TD></TR>"
				echo "<TR><TD><TABLE BORDER=0>"
			fi
			set `echo $line | $SED "s/\./ /g"`
			ROW=$2
			COL=$3

			#
			# HANDLE THE ROW DISPLAY 
			#
			if test "$ROW" != "$LASTROW"		# WE HAVE A NEW ROW...
			then
				if test "$LASTROW" != ""
				then
					echo "</TR>"
				fi

				#
				# SMM: NEW IN 1.06a
				# SUPPORT FOR NOTES IN THE SUMMARY LINES
				# VIA: David Fordyce <fordyce@ite1.dseg.ti.com>
				#
				echo "<TR><TD>"
				echo "<FONT $MKBBROWFONT>"
	
				if test -f "${BBNOTES}/${ROW}.html"
				then
					echo "<A HREF=notes/${ROW}.html>$ROW</A></TD>"
				elif test -f "${BBNOTES}/${ROW}.htm"
				then
					echo "<A HREF=notes/${ROW}.htm>$ROW</A></TD>"
				elif test -f "${BBNOTES}/${ROW}"
        			then
					echo "<A HREF=notes/$ROW>$ROW</A></TD>"
				else
					echo "$ROW</TD>"
				fi

				LASTROW="$ROW"
			fi
			#
			# HANDLE THE COLUMN DISPLAY
			#
			echo "<TD WIDTH=45 ALIGN=CENTER>$COL<BR>"	# COLUMN TITLE
			set `$CAT ${BBLOGS}/summary.${ROW}.${COL}`
			echo "<A HREF=$2><IMG SRC=\"gifs/$1.gif\" ALT=\"$1\" HEIGHT=16 WIDTH=16 BORDER=0></A></TD>"
		done
		echo "</TR></TABLE>"
		echo "</TD></TR></TABLE>"
	fi
else
	echo "<FONT SIZE=+2 FACE=\"Arial, Helvetica\"><BR><BR><I>All Monitored Systems OK</I></FONT><BR><BR>"
fi

echo "
</CENTER>
"

#
# SMM NEW IN 1.04 - STANDARD FOOTER
#
if test -f "$BBHOME/web/bb2_footer"
then
	$CAT $BBHOME/web/bb2_footer | $SED "s/&BBRELDATE/$BBRELDATE/g" | $SED "s/&BBREL/$BBREL/g" |\
		$SED "s/&BBDATE/$BBDATE/g" | $SED "s/&BBBACKGROUND/$BBBKG/g"
fi

echo "
</BODY></HTML>"          # END OF HTML DOCUMENT
