use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

print "Barcode module version 1.5.1\n";
print "Checking for GD version 1.30 or higher\n\n";

@path = @INC;
while(@path) {
	$check = pop(@path);
	$file_to_check = $check . "/GD.pm";
	print "\n";
	$found = system("ls $file_to_check");
	if($found eq '256') {
		print "No GD in $check\n";
	}
	else {
		use GD;
		$gd_version = $GD::VERSION;
		print "Found GD-$gd_version at $check.\n";
		if($gd_version lt '1.3') {
			print "This module requires GD-1.30 or higher. Make aborted.\n";
			exit;
		}
	}
}

print "Writing makefile...\n";
WriteMakefile(
	'NAME'	=> 'Barcode',
	'VERSION_FROM' => 'Barcode.pm', # finds $VERSION
	'INSTALLDIRS' => 'site',
);
