
;   ************************************************************************
;   *				   ascii.inc				   *
;   ************************************************************************

IFNDEF _ASCII_INC
_ASCII_INC EQU <>

;   Commonly used ASCII characters, mostly non-printable.

.NOCREF 		NULL, BELL, BACKSPACE, TAB, LF, CR, ESCAPE, SPACE

NULL			EQU	00h
BELL			EQU	07h
BACKSPACE		EQU	08h
TAB			EQU	09h
LF			EQU	0Ah
CR			EQU	0Dh
ESCAPE			EQU	1Bh
SPACE			EQU	20h

;   ========================================================================

@StrToNum		MACRO	str:VARARG
			LOCAL	num, shift
  num			=	0
  shift 		=	0
  FOR			ch, <str>
    num 		=	num OR (ch SHL shift)
    shift		=	shift + 08h
  ENDM
  EXITM 		%num
ENDM

;   ************************************************************************

ENDIF

