
;   ************************************************************************
;   *				    cpu.inc				   *
;   ************************************************************************

IFNDEF _CPU_INC
_CPU_INC EQU <>

;   Structures and definitions for 80x86 properties

;   Arrangement of registers on stack for PUSHA and POPA instructions:

PUSHA_STACK		STRUCT
  stacked_di		dw	?
  stacked_si		dw	?
  stacked_bp		dw	?
  stacked_sp		dw	?
  UNION
    stacked_bx		dw	?
    STRUCT
      stacked_bl	db	?
      stacked_bh	db	?
    ENDS
  ENDS
  UNION
    stacked_dx		dw	?
    STRUCT
      stacked_dl	db	?
      stacked_dh	db	?
    ENDS
  ENDS
  UNION
    stacked_cx		dw	?
    STRUCT
      stacked_cl	db	?
      stacked_ch	db	?
    ENDS
  ENDS
  UNION
    stacked_ax		dw	?
    STRUCT
      stacked_al	db	?
      stacked_ah	db	?
    ENDS
  ENDS
PUSHA_STACK		ENDS

;   ------------------------------------------------------------------------

FAR_RETADDR		UNION
  stacked_csip		dd		?
  STRUCT
    stacked_ip		dw		?
    stacked_cs		dw		?
  ENDS
FAR_RETADDR		ENDS

INT_RETADDR		STRUCT
			FAR_RETADDR	<>
  stacked_flags 	dw		?
INT_RETADDR		ENDS

;   ========================================================================

;   Bits within the CPU flags register (bits 1, 3, 5 and F are unused):

CPU_FLAGS		RECORD	FLAGSbitF:1, NTbit:1, IOPLbits:2,
				OFbit:1, DFbit:1, IFbit:1, TFbit:1,
				SFbit:1, ZFbit:1, FLAGSbit5:1, AFbit:1,
				FLAGSbit3:1, PFbit:1, FLAGSbit1:1, CFbit:1

;   ************************************************************************

ENDIF

