
;   ************************************************************************
;   *			 debobjs.asm - for wdeb386.com			   *
;   ************************************************************************

;   (C) Geoff Chappell 1995.  All rights reserved.

.NOLIST
  INCLUDE		standard.inc
.LIST

.NOLIST
  INCLUDE		debobjs.inc
  INCLUDE		le.inc
  INCLUDE		segmodel.inc
.LIST

;   ************************************************************************

.CODE			KEEP_TEXT

FixDebugObjects 	PROC	NEAR PUBLIC
			ASSUME	bx:PTR LE_HEADER

;   The DEBUG VxD embedded in version 4.0.4 of the WDEB386.EXE file contains
;   two objects DCODE and DDATA that can provide the main substance of the
;   debugger using VxD memory instead of the more precious DOS memory.

;   Two problems arise.  The first is that for Windows 3.xx, the mere
;   presence of a 16-bit data object (the attributes of DDATA) in the DEBUG
;   VxD prevents WIN386 from loading the VxD.  Likewise, an arrangement of
;   objects where DCODE follows RCODE induces WIN386 to think that the entry
;   point for real mode initialisation is in DCODE (not RCODE).  The VxD
;   supplies the ability to break into the debugger via a hotkey at the
;   computer or via Ctrl-C at the terminal.  At the very least then, the
;   DCODE and DDATA objects must be changed somehow so that the DEBUG VxD
;   can get loaded.

;   Second, if the main substance of the debugger has already been provided
;   from the WDEB386.EXE program, then the DCODE and DDATA objects in the
;   DEBUG VxD are redundant.  To load them would be to waste nearly 90KB of
;   VxD memory.

			call	IsDebuggerActive
			jc	no_debugger_yet

;   So, given a situation where the functionality of the DCODE and DDATA
;   objects is known to have been supplied already from material in the DOS
;   image of WDEB386.EXE, attempt to hide the DCODE and DDATA objects from
;   the WIN386's VxD loader.

			call	RemoveDebugObjects
			jnc	done

;   If the objects cannot be removed from consideration, then if the
;   debugger has loaded Windows 3.xx, modify the objects' attributes so that
;   they seem to be 32-bit.  This will at least allow WIN386 to proceed with
;   loading the DEBUG VxD.

			cmp	[wWinVer],0400h
			jnb	done

			ASSUME	si:PTR OBJ_TABLE_ENTRY

			mov	si,[ObjTabEntries].dcode
			or	word ptr es:[si].dwFlags,OBJ_USE32

			mov	si,[ObjTabEntries].ddata
			or	word ptr es:[si].dwFlags,OBJ_USE32

			clc
			jmp	done

no_debugger_yet:

;   If the debugging facility has not already been supplied from the
;   WDEB386.EXE DOS program, then another issue arises.  The means by which
;   the VMM can activate the debugger from the DCODE and DDATA VxD objects
;   was introduced with Windows 95.  For earlier Windows versions, the DEBUG
;   VxD is more or less redundant - but worse, the implementation in WDEB386
;   version 4.0.4 is harmful because it assumes that it will not be loaded
;   unless the debugger can be activated.  In this case, it is best just to
;   leave the objects alone, knowing that Windows 3.xx will be unable to
;   load the DEBUG VxD.

done:
			ret

			ASSUME	bx:NOTHING, si:NOTHING
FixDebugObjects 	ENDP

;   ========================================================================

RemoveDebugObjects	PROC	NEAR
			ASSUME	bx:PTR LE_HEADER

;   The following method for hiding the DCODE and DDATA objects is not
;   entirely satisfactory.  Since the two objects concerned happen to be the
;   last two objects in the VxD, they can be removed easily just by reducing
;   the count of objects.  Against this is that the method leaves WIN386
;   applying random fixups wherever another object requires the address of
;   something in either DCODE or DDATA.  The randomness is unimportant since
;   if other objects executed code that required access to DCODE or DDATA,
;   removal of DCODE and DDATA would be unsafe.  The potential trouble is
;   that the VxD loader might actually refuse the whole VxD if it discovers
;   a fixup whose target object does not exist (having been undefined).  At
;   present, none of the Windows 3.xx or Windows 95 VxD loaders are so
;   defensive;	thus, this simple method works.

			mov	ax,NUM_OBJECTS - 0002h

			cmp	[ObjNums].dcode,ax
			jbe	fail
			cmp	[ObjNums].ddata,ax
			jbe	fail

			mov	word ptr es:[bx].dwNumObjs,ax

ok:
			clc
			jmp	done

fail:
			stc

done:
			ret

			ASSUME	bx:NOTHING
RemoveDebugObjects	ENDP

;   ========================================================================

IsDebuggerActive	PROC	NEAR PRIVATE USES es bx

			mov	ax,3568h
			int	21h
			mov	ax,es
			or	ax,bx
			jz	fail

			mov	ah,43h
			int	68h
			cmp	ax,0F386h
			jz	done

fail:
			stc

done:
			ret

IsDebuggerActive	ENDP

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

.CODE			KEEP_DATA

			EXTERN	wWinVer:WORD
			EXTERN	ObjTabEntries:OBJECTS
			EXTERN	ObjNums:OBJECTS

;   ************************************************************************

END

