
;   ************************************************************************
;   *			 exeload.asm - for wdeb386.com			   *
;   ************************************************************************
                                 
;   (C) Geoff Chappell 1995.  All rights reserved.

;   ========================================================================

.NOLIST
  INCLUDE		cpu.inc
  INCLUDE		standard.inc
.LIST

.NOLIST
  INCLUDE		segmodel.inc
.LIST

;   ========================================================================

VXD_FILE_STATE		RECORD	VXD_DONE:1, VXD_OPEN:1

;   ************************************************************************

.CODE			KEEP_TEXT

			EXTERN	ExamineVxDFileData:NEAR

Int21h			PROC	FAR PRIVATE

;   Is Windows Enhanced mode running?  If not, then pass control as quickly
;   as possible.

			cmp	cs:[spWin386PSP],0000h
			jz	pass

;   Has the VxD analysis already been performed?  If so, there is no need to
;   delay any further int 21h calls (at least, not unless Windows exits and
;   restarts while remaining under the supervision of the debugger).

			test	cs:[fVxDFileState],MASK VXD_DONE
			jnz	pass

;   The functions of interest depend on whether WIN386.EXE is known to have
;   the WDEB386.EXE file open (for the purpose of loading the VxD component).

			test	cs:[fVxDFileState],MASK VXD_OPEN
			jnz	vxd_file_in_use

;   Until the VxD file is opened, the only function of interest is 3Dh - and
;   only then if the current PSP is the WIN386 PSP and if the pathname at
;   DS:DX matches the one for the WDEB386.EXE file.

			cmp	ah,3Dh
			jnz	pass

			call	IsWin386
			jc	pass

			call	IsVxDFile
			jc	pass

;   When WIN386 attempts to open the WDEB386.EXE file, let the call through
;   to DOS.  If the file gets opened, note the handle.

			pushf
			cli
			call	cs:[lpOrgInt21h]

			call	StackCF
			jc	done

			mov	cs:[wVxDFileHandle],ax
			mov	dword ptr cs:[dwFilePosition],00000000h

;   Switch attention to the functions concerned with accessing an open file.

			or	cs:[fVxDFileState],MASK VXD_OPEN

			jmp	done

vxd_file_in_use:

;   When WIN386 is known to have the WDEB386.EXE file open, interest is
;   confined to DOS functions that WIN386 will use to search for and load
;   the VxD component.

			cmp	ah,42h
			jz	@f
			cmp	ah,3Fh
			jz	@f
			cmp	ah,3Eh
			jnz	pass

@@:

;   Of course, the file handle and current process must confirm that the
;   operation is being conducted by WIN386.EXE on the WDEB386.EXE file (and
;   not by some other process or on some other file).

			cmp	bx,cs:[wVxDFileHandle]
			jnz	pass

			call	IsWin386
			jc	pass

			cmp	ah,3Eh
			jz	close
			cmp	ah,3Fh
			jz	read

seek:

;   For a seek, let the call through, but note the new position for the file
;   pointer if the call succeeds.

			pushf
			cli
			call	cs:[lpOrgInt21h]

			call	StackCF
			jc	done

			mov	word ptr cs:[dwFilePosition],ax
			mov	word ptr cs:[dwFilePosition + 02h],dx

			jmp	done

read:

;   For a read, let the call through, but examine (and possibly modify) the
;   data before WIN386 sees it.

			pushf
			cli
			call	cs:[lpOrgInt21h]

			call	StackCF
			jc	done

;	To make it easier for the ExamineVxDFileData procedure, preserve all
;	registers (32-bit and common segments), then load

;	    es:bx   = address of data in memory
;	    ecx     = size of data in memory
;	    eax     = position of data in file

			pushad
			push	es
			push	ds

			push	ds
			pop	es
			mov	bx,dx
			movzx	ecx,ax
			push	cs
			pop	ds
			mov	eax,[dwFilePosition]
			call	ExamineVxDFileData

			pop	ds
			pop	es
			popad

			jnc	@f

			or	cs:[fVxDFileState],MASK VXD_DONE
			jmp	done

@@:

;   Keep track of the current position for file access.

			add	word ptr cs:[dwFilePosition],ax
			adc	word ptr cs:[dwFilePosition + 02h],0000h

			jmp	done

close:

;   Once WIN386.EXE has closed the file, there should be no further delay
;   imposed on int 21h calls (unless WIN386 exits and restarts).

			or	cs:[fVxDFileState],MASK VXD_DONE

pass:
			jmp	cs:[lpOrgInt21h]

done:
			iret

Int21h			ENDP

;   ------------------------------------------------------------------------

StackCF 		PROC	NEAR C PRIVATE USES ax, intframe:INT_RETADDR

			rcl	ax,1
			and	ax,MASK CFbit
			and	[intframe].stacked_flags,NOT MASK CFbit
			or	[intframe].stacked_flags,ax
			shr	ax,1

			ret

StackCF 		ENDP

;   ========================================================================

IsWin386		PROC	NEAR PRIVATE USES bx ax

			mov	ah,51h
			pushf
			cli
			call	cs:[lpOrgInt21h]

			cmp	bx,cs:[spWin386PSP]
			jz	@f
			stc
@@:
			ret

IsWin386		ENDP

;   ------------------------------------------------------------------------

IsVxDFile		PROC	NEAR PRIVATE USES es ds di si cx ax

			mov	si,dx
			push	cs
			pop	es
			mov	di,OFFSET PathnameBuffer
			mov	ah,60h
			pushf
			cli
			call	cs:[lpOrgInt21h]
			jc	done

			push	cs
			pop	ds
			mov	si,OFFSET ExePathname

			mov	cx,[wExePathnameLength]
			repz	cmpsb
			jz	done

			stc

done:
			ret

IsVxDFile		ENDP

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

.CODE

InitDetectVxDLoad	PROC	NEAR PUBLIC

			mov	ax,3521h
			int	21h

			mov	word ptr [lpOrgInt21h],bx
			mov	word ptr [lpOrgInt21h + 02h],es

			mov	dx,OFFSET Int21h
			mov	ax,2521h
			int	21h

			ret

InitDetectVxDLoad	ENDP

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

.CODE			KEEP_TEXT

ExitDetectVxDLoad	PROC	NEAR PUBLIC USES ds

			lds	dx,[lpOrgInt21h]
			mov	ax,2521h
			int	21h

			ret

ExitDetectVxDLoad	ENDP

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

.CODE			KEEP_DATA

lpOrgInt21h		dd	?

			EXTERN	spWin386PSP:WORD

fVxDFileState		dw	0000h

wVxDFileHandle		dw	?
dwFilePosition		dd	?

PathnameBuffer		db	86h DUP (?)

			EXTERN	ExePathname:BYTE
			EXTERN	wExePathnameLength:WORD

;   ************************************************************************

END

