
;   ************************************************************************
;   *			  int22h.asm - for wdeb386.com			   *
;   ************************************************************************

;   (C) Geoff Chappell 1995.  All rights reserved.

.NOLIST
  INCLUDE		standard.inc
.LIST

.NOLIST
  INCLUDE		match32.inc
  INCLUDE		segmodel.inc
.LIST

KEEP_TEXT32		SEGMENT WORD PUBLIC USE32 'KEEPCODE'
KEEP_TEXT32		ENDS

;   ========================================================================

JA_SHORT_OPCODE 	EQU	77h

JCOND_SHORT		STRUCT
  opcode		db	?
  disp			db	?
JCOND_SHORT		ENDS

;   ************************************************************************

.CODE			KEEP_TEXT32

Int22hEntry		PROC	NEAR PRIVATE

			mov	eax,[ebp + 1Ch]
			cmp	ax,000Dh

SIZE_INT22H_ENTRY	=	OFFSET $ - OFFSET Int22hEntry

Int22hEntry		ENDP

Int22hJmp		PROC	NEAR PRIVATE

			jmp	dword ptr cs:[eax * 4 + MEMORY_REFERENCE]

SIZE_INT22H_JMP 	=	OFFSET $ - OFFSET Int22hJmp

Int22hJmp		ENDP

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

.CODE			KEEP_TEXT

			EXTERN	FindMatch32:NEAR

FixInt22hJmpTable	PROC	NEAR PUBLIC USES bp ecx bx

			mov	di,bx
			mov	si,OFFSET DGROUP:Int22hEntry
			mov	dx,SIZE_INT22H_ENTRY
			call	FindMatch32
			jc	fail

			mov	bp,di

			ASSUME	di:PTR JCOND_SHORT

			cmp	es:[di].opcode,JA_SHORT_OPCODE
			jnz	fail

			add	di,SIZEOF JCOND_SHORT
			sub	cx,SIZEOF JCOND_SHORT
			jb	fail

			mov	si,OFFSET DGROUP:Int22hJmp
			mov	dx,SIZE_INT22H_JMP
			push	cx
			mov	cx,dx
			call	FindMatch32
			pop	cx
			jc	fail
			sub	cx,dx

			movzx	eax,di
			sub	ax,bx
			cmp	eax,dword ptr es:[di - 04h]
			jnz	fail

;   In the DEBUG VxD provided with version 4.0.4 of WDEB386.EXE, the jump
;   table has space for only 7 entries.  Try to determine whether the same
;   applies to the version of the DEBUG VxD being loaded now.

			mov	esi,0007h SHL 02h
			sub	cx,si
			jb	fail
			add	si,ax

			mov	edx,000Eh SHL 02h
			add	dx,ax

			mov	cx,0007h
next_entry:
			mov	eax,dword ptr es:[di]
			cmp	eax,esi
			jb	@f
			cmp	eax,edx
			jnb	@f
			mov	edx,eax
@@:
			add	di,0004h
			loop	next_entry

			cmp	edx,esi
			jnz	fail

			mov	byte ptr es:[bp - 01h],06h

			clc
			jmp	done

fail:
			stc

done:
			ret

FixInt22hJmpTable	ENDP

;   ************************************************************************

END

