
;   ************************************************************************
;   *				  is80386.asm				   *
;   ************************************************************************

.MODEL			SMALL

.CODE

Is80386 		PROC	NEAR PUBLIC

			pushf

;   Attempt to set the IOPL and NT bits in the flags register and to clear
;   the reserved bit F.

			mov	ax,7000h
			push	ax
			popf

;   Examine the result of this attempt.

			pushf
			pop	ax

;   On processors that predate the 80286, bit F cannot be cleared.

			test	ax,8000h
			jnz	fail

;   On the 80286, the NT and IOPL bits are permanently clear (for a program
;   executing with real mode addressing).

			test	ax,7000h
			jz	fail

;   For an 80386 or higher, return a non-zero ax.

			mov	ax,0001h
			jmp	done

fail:
			xor	ax,ax

done:
			popf
			ret

Is80386 		ENDP

;   ************************************************************************

END

