
;   ************************************************************************
;   *			   main.asm - for wdeb386.com			   *
;   ************************************************************************
                                 
;   (C) Geoff Chappell 1995.  All rights reserved.

;   ========================================================================

.NOLIST
  INCLUDE		ascii.inc
  INCLUDE		arena.inc
  INCLUDE		exec.inc
  INCLUDE		psp.inc
  INCLUDE		standard.inc
.LIST

.NOLIST
  INCLUDE		segmodel.inc
.LIST

;   ========================================================================

KEEP_PSP		SEGMENT
_psp			PSP	{}
KEEP_PSP		ENDS

KEEP_STACK		SEGMENT
			dw	0080h DUP (0000h)
KEEP_STACK		ENDS

;   ========================================================================

CHILD_EXEC_STATE	RECORD	CHILD_RAN:1, CHILD_LOADED:1

;   ************************************************************************

.CODE
			EXTERN	InitDetectVxDLoad:NEAR
			EXTERN	InitDetectWin:NEAR
			EXTERN	Is80386:NEAR

MainInit		PROC	NEAR PUBLIC

			mov	dx,OFFSET ProgramBanner
			mov	ah,09h
			int	21h

			mov	ax,3000h
			int	21h
			xchg	al,ah
                        mov     [wDOSVersion],ax

			cmp	ax,@MakeWord (3, 10)
			jnb	@f

			mov	dx,OFFSET BadDOSVersion
			jmp	fail

@@:

;   Is the program running on a 386 or higher?	The program is written
;   mostly as a 16-bit program with real mode addressing (to run under DOS),
;   but establishing the presence of an 80386 or higher allows the code an
;   occasional luxury of easy 32-bit operations.

			call	Is80386
			or	ax,ax
			jnz	@f

			mov	dx,OFFSET Requires80386
			jmp	fail

@@:

;   Find the program's pathname in its environment.  (The procedure returns
;   the desired address in es:di.)

			call	GetProgramPathname
			jnc	@f

no_pathname:
			mov	dx,OFFSET NoPathname
			jmp	fail

@@:

;   Save a fully-qualified version of the program's pathname.

			push	ds
			mov	ax,ds
			push	es
			pop	ds
			mov	si,di
			mov	es,ax
			mov	di,OFFSET ExePathname
			mov	ah,60h
			int	21h
			pop	ds
			jc	no_pathname

;   Replace the file extension (assumed to be COM) in preparation for
;   loading the .EXE file that has the same filename and lies on the same
;   path.  The .EXE file is the debugger (WDEB386.EXE).

			xor	cx,cx
			not	cx
			xor	al,al
			repnz	scasb
			not	cx

			mov	[wExePathnameLength],cx

			cmp	cx,SIZEOF ExtensionCOM
			jb	no_pathname

			lea	si,[di - SIZEOF ExtensionCOM]

			sub	di,cx

			lodsb
			cmp	al,byte ptr [ExtensionCOM + 00h]
			jnz	no_pathname

			mov	eax,[si]
			and	eax,NOT 00202020h
			cmp	eax,dword ptr [ExtensionCOM + 01h]
			jnz	no_pathname

			mov	eax,dword ptr [ExtensionEXE + 01h]
			mov	[si],eax

;   Initialise the segment components of far pointers in the LOADBLOCK
;   structure that will be needed by int 21h function 4Bh to run the
;   WDEB386.EXE program.

			mov	ax,ds
			mov	word ptr [LoadBlock].lpCommandLine + 02h,ax
			mov	word ptr [LoadBlock].lpFCB1 + 02h,ax
			mov	word ptr [LoadBlock].lpFCB2 + 02h,ax

;   Check that the file exists.

			mov	dx,di
			mov	ax,4300h
			int	21h
			jnc	@f

			mov	dx,OFFSET NoDebuggerFile
			jmp	fail
@@:

;   Before making any changes to the system (for instance, to hook interrupt
;   vectors), disable DOS exceptions.

			mov	dx,OFFSET Int23h
			mov	ax,2523h
			int	21h
			mov	dx,OFFSET Int24h
			mov	ax,2524h
			int	21h

;   Hook int 2Fh functions 1605h and 1606h to detect the startup of and exit
;   from Windows enhanced mode.

			call	InitDetectWin

;   Hook various int 21h file functions to detect when WIN386.EXE loads the
;   VxD component of the WDEB386.EXE file.

			call	InitDetectVxDLoad

;   Discard material that won't be needed while the debugger runs.

			mov	sp,OFFSET DGROUP:KEEP_END_STACK

			push	ds
			pop	es
			mov	bx,OFFSET DGROUP:INIT_FENCE
			mov	cl,04h
			shr	bx,cl
			mov	ah,4Ah
			jmp	KeepInit		; to an int 21h

fail:
			mov	ah,09h
			int	21h

			mov	al,0FFh
			stc

done:
			ret

MainInit		ENDP

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

.CODE			KEEP_TEXT

			EXTERN	ExitDetectVxDLoad:NEAR
			EXTERN	ExitDetectWin:NEAR
			EXTERN	FixSwitchHBug:NEAR

KeepInit		PROC	NEAR PRIVATE

			int	21h			; from mov ah,4Ah

;   Load the debugger - but without letting it run immediately.  This
;   creates an opportunity to correct any bugs in the DOS portion of the
;   WDEB386.EXE image before the program actually runs.

;   DOS function 4B01h returns CY to indicate that the child (in this case,
;   the debugger) failed to load.  Otherwise, the function will seem to
;   return twice!  On the first return, the debugger has been loaded and
;   started as the new process (but it is not yet executing the code loaded
;   from its file on disk).  The second return occurs when the DOS process
;   started for the debugger terminates (which includes the possibility that
;   the process might not yet have executed any debugger code).

;   The following handling of int 21h function 4B01h is adapted from "DOS
;   Internals".  An alternative would be to divert the child's termination
;   address.

			mov	dx,OFFSET ExePathname
			mov	bx,OFFSET LoadBlock
			mov	ax,4B01h
			int	21h
			jc	load_error

			bts	[fChildState],CHILD_LOADED
			jc	child_returned

;   On the first time through, prepare to hand control to the debugger's own
;   code (loaded from disk).

;	Begin by aligning the stack correctly (and with registers that are
;	wanted when control returns after the child's termination).

			xor	ax,ax
			push	ax
			push	ax
			push	ax
			push	es
			push	ds
			push	bp
			push	di
			push	si
			push	dx
			push	cx
			push	bx
			push	ax

;	Find the debugger's PSP.  This is needed since it must be in ds and
;	es when the debugger starts to execute its own code.  It also helps
;	with the next step.

			mov	ah,51h
			int	21h
			mov	es,bx

;	Correct known problems with code in the debugger's DOS image.

			call	GetSizePSPBlock
			jc	@f

			sub	ecx,SIZEOF PSP
			jb	@f

			push	es
			mov	ax,es
			add	ax,SIZEOF PSP SHR 04h
			mov	es,ax
			xor	di,di
			call	FixSwitchHBug
			pop	es

@@:

;	Have the child process start with this program's original int 23h
;	and int 24h handlers (rather than the ones this program installed to
;	defeat exceptional termination).

			push	ds
			lds	dx,cs:[_psp].lpInt23h
			mov	ax,2523h
			int	21h
			lds	dx,cs:[_psp].lpInt24h
			mov	ax,2524h
			int	21h
			pop	ds

;	Disable the A20.

			cmp	[wDOSVersion],0500h
			jb	@f

			mov	[ExecState].wFlags,EXEC_OVERLAY
			mov	word ptr [ExecState].lpName,OFFSET ExePathname
			mov	word ptr [ExecState].lpName + 02h,ds
			mov	[ExecState].spPSP,es
			mov	eax,[LoadBlock].lpEntryPoint
			mov	[ExecState].lpEntryPoint,eax
			mov	dx,OFFSET ExecState
			mov	ax,4B05h
			int	21h

@@:
			bts	[fChildState],CHILD_RAN

;	Switch to the debugger's stack and start executing the debugger's
;	code.

			lss	sp,[LoadBlock].lpStackTop
			pop	ax
			push	dword ptr [LoadBlock].lpEntryPoint
			mov	dx,es
			mov	ds,dx
			retf

child_returned:

;   Save the debugger's exit code so that it may become this program's exit
;   code.

			bt	[fChildState],CHILD_RAN
			jnc	fail

			mov	ah,4Dh
			int	21h

			mov	[ExitCode],al
			jmp	unhook

load_error:
			mov	dx,OFFSET LoadError
			mov	ah,09h
			int	21h
			mov	bx,[wExePathnameLength]
			lea	si,[ExePathname + bx - 0001h]
			mov	byte ptr [si],"$"
			mov	dx,OFFSET ExePathname
			mov	ah,09h
			int	21h
			mov	byte ptr [si],00h
			mov	dx,OFFSET NewLine
			mov	ah,09h
			int	21h

fail:
			mov	[ExitCode],0FFh

unhook:
			call	ExitDetectVxDLoad
			call	ExitDetectWin

			mov	al,[ExitCode]
			mov	ah,4Ch
			int	21h

KeepInit		ENDP

;   ========================================================================

Int24h			PROC	FAR PRIVATE

			mov	al,03h

Int23h			PROC	FAR PRIVATE

			iret

Int23h			ENDP
Int24h			ENDP

;   ========================================================================

GetSizePSPBlock 	PROC	NEAR PRIVATE USES es

			mov	bx,es
			dec	bx
			mov	es,bx
			xor	di,di
			ASSUME	di:PTR ARENA_HEADER
			inc	bx
			mov	al,es:[di].cSignature
			cmp	al,ARENA_IN_CHAIN
			jz	@f
			cmp	al,ARENA_LAST
			jnz	fail

@@:
			cmp	es:[di].spOwner,bx
			jnz	fail

			movzx	ecx,es:[di].wParagraphs
			shl	ecx,04h

ok:
			clc
			jmp	done

fail:
			stc

done:
			ret

			ASSUME	di:NOTHING
GetSizePSPBlock 	ENDP

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

.CODE

GetProgramPathname	PROC	NEAR PRIVATE

;   Locate the program's environment.  (It is possible that the program has
;   been loaded with no environment, in which case, the word at offset 2Ch
;   in the PSP will be zero.)

			mov	dx,[_psp].spEnvironment
			or	dx,dx
			jz	fail

;   Use the memory arena header immediately below the environment block both
;   to verify that the environment block belongs to the program and to
;   obtain an upper limit on the environment's size.

			dec	dx
			mov	es,dx
			xor	di,di
			ASSUME	di:PTR ARENA_HEADER

			mov	al,es:[di].cSignature
			cmp	al,ARENA_IN_CHAIN
			jz	@f
			cmp	al,ARENA_LAST
			jnz	fail

@@:
			mov	ax,ds
			cmp	ax,es:[di].spOwner
			jnz	fail

			mov	cx,es:[di].wParagraphs
			shl	cx,1
                        shl     cx,1
                        shl     cx,1
                        shl     cx,1

			inc	dx
			mov	es,dx
			ASSUME	di:NOTHING

;   The environment consists of contiguous null-terminated strings, the last
;   of which is followed by another null byte.

			xor	al,al

@@:
			repnz	scasb
			jnz	fail
			dec	cx
			jle	fail
			scasb
			jnz	@b

;   This last null byte should be followed by the word 0001h and then the
;   program's pathname.  If this all fits within the memory block, return
;   the address of that pathname.

			dec	cx
			dec	cx
			jle	fail

			mov	ax,0001h
			scasw

			push	di
			xor	al,al
			repnz	scasb
			pop	di
			jz	done

fail:
			stc
done:
			ret

GetProgramPathname	ENDP

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

.CODE			KEEP_DATA

wDOSVersion             dw      ?

			PUBLIC	wExePathnameLength
wExePathnameLength	dw	?
			PUBLIC	ExePathname
ExePathname		db	86h DUP (?)

LoadBlock		LOADBLOCK	{ \
					0000h, \
					OFFSET _psp.cCommandLineLength, \
					OFFSET _psp.FCB1, \
					OFFSET _psp.FCB2 \
					}

ExecState		EXECSTATE	{}

fChildState		dw	0000h

ExitCode		db	?

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

.CONST

ExtensionCOM		db	".COM", 00h
ExtensionEXE		db	".EXE", 00h

ProgramBanner		db	\
	CR, LF,
	"WDEB386.COM fix for bugs in WDEB386.EXE Version 4.0.4",
	CR, LF,
	"Copyright (C) Geoff Chappell 1995.  All rights reserved.",
	CR, LF,
	"$"

BadDOSVersion		db	\
	CR, LF,
	"Bug fix requires DOS 3.10 or higher.",
	CR, LF,
	"$"

Requires80386		db	\
	CR, LF,
	"Bug fix requires 80386 or higher.",
	CR, LF,
	"$"

NoPathname		db	\
	CR, LF,
	"Cannot determine name of bug fix program",
	CR, LF,
	"or name does not have .COM extension.",
	CR, LF,
	"$"

NoDebuggerFile		db	\
	CR, LF,
	"Cannot find debugger file.  Bug fix expects debugger",
	CR, LF,
	"to have .EXE extension with same name as bug fix",
	CR, LF,
	"and to lie in same directory as bug fix.",
	CR, LF,
	"$"

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

.CODE			KEEP_CONST

LoadError		db	\
	CR, LF,
	"Error executing ",
	"$"

NewLine 		db	\
	CR, LF,
	"$"

;   ************************************************************************

END

