
;   ************************************************************************
;   *			 match16.asm - for wdeb386.com			   *
;   ************************************************************************

;   (C) Geoff Chappell 1995.  All rights reserved.

;   ========================================================================

.NOLIST
  INCLUDE		standard.inc
.LIST

.NOLIST
  INCLUDE		match16.inc
  INCLUDE		segmodel.inc
.LIST

;   ************************************************************************

.CODE			KEEP_TEXT

FindMatch16		PROC	NEAR PUBLIC

;   This procedure scans the CX bytes at ES:DI, looking for a subsequence
;   that matches the DX bytes at DS:SI.

;   If a match is found, the carry flag is returned clear and ax addresses
;   the matching sequence (with respect to segment ES).  Registers di and cx
;   describe the byte immediately following the matching sequence.

;   The absence of a match is indicated by a set carry flag.

			mov	al,[si]
			cld

@@:
			repnz	scasb
			jnz	no_match

			dec	di
			inc	cx

			call	TestMatch
			jz	match

			inc	di
			dec	cx
			jmp	@b

no_match:
			stc
			jmp	done

match:
			mov	ax,di
			add	di,dx
			sub	cx,dx

done:
			ret

FindMatch16		ENDP

;   ------------------------------------------------------------------------

TestMatch		PROC	NEAR PRIVATE USES di si dx ax

;   This procedure compares a sequence of instructions of CX bytes at ES:DI
;   with a hard-coded sequence of DX bytes at DS:SI.  All registers are
;   preserved.	The result is indicated by the zero flag.

			cmp	cx,dx
			jb	no_match

			add	dx,si
check_next:

;   When the word at the current position in the hard-coded fragment denotes
;   an unknown memory reference, allow any word at the corresponding
;   position in the candidate sequence.

			mov	ax,[si]
			cmp	ax,MEMORY_REFERENCE
			jnz	@f

			cmpsw
			jmp	check_end

@@:

;   Ordinarily, we have a simple byte-by-byte comparison.

			cmpsb
			jnz	no_match

check_end:
			cmp	si,dx
			jb	check_next
match:
no_match:
			ret

TestMatch		ENDP

;   ************************************************************************

END

