
;   ************************************************************************
;   *			 match32.asm - for wdeb386.com			   *
;   ************************************************************************

;   (C) Geoff Chappell 1995.  All rights reserved.

;   ========================================================================

.NOLIST
  INCLUDE		standard.inc
.LIST

.NOLIST
  INCLUDE		match32.inc
  INCLUDE		segmodel.inc
.LIST

;   ========================================================================

DYNALINK_OPCODE 	EQU	20CDh

CALL_NEAR_IND_OPCODE	EQU	15FFh

CALL_NEAR_IND		STRUC
  opcode		dw	CALL_NEAR_IND_OPCODE
  pointer		dd	?
CALL_NEAR_IND		ENDS

;   ************************************************************************

.CODE			KEEP_TEXT

FindMatch32		PROC	NEAR PUBLIC

;   This procedure scans the CX bytes at ES:DI, looking for a subsequence
;   that matches the DX bytes at DS:SI.

;   If a match is found, the carry flag is returned clear and ax addresses
;   the matching sequence (with respect to segment ES).  Registers di and cx
;   describe the byte immediately following the matching sequence.

;   The absence of a match is indicated by a set carry flag.

			mov	al,[si]
			cld

@@:
			repnz	scasb
			jnz	no_match

			dec	di
			inc	cx

			call	TestMatch
			jz	match

			inc	di
			dec	cx
			jmp	@b

no_match:
			stc
			jmp	done

match:
			mov	ax,di
			add	di,dx
			sub	cx,dx

done:
			ret

FindMatch32		ENDP

;   ------------------------------------------------------------------------

TestMatch		PROC	NEAR PRIVATE USES di si dx ax

;   This procedure compares a sequence of instructions of CX bytes at ES:DI
;   with a hard-coded sequence of DX bytes at DS:SI.  All registers are
;   preserved.	The result is indicated by the zero flag.

			cmp	cx,dx
			jb	no_match

			add	dx,si
check_next:

;   When the word at the current position in the hard-coded fragment denotes
;   an unknown memory reference, allow any dword at the corresponding
;   position in the candidate sequence.

			mov	eax,[si]
			cmp	eax,MEMORY_REFERENCE
			jnz	@f

			cmpsd
			jmp	check_end

@@:

;   Another special case occurs when the first two bytes at the current
;   position in the hard-coded sequence are the ones for an INT 20h
;   instruction (a VxD service call).

			cmp	ax,DYNALINK_OPCODE
			jnz	@f

			call	TestDynalink
			jmp	check_cmp

@@:

;   Ordinarily, we have a simple byte-by-byte comparison.

			cmpsb

check_cmp:
			jnz	no_match

check_end:
			cmp	si,dx
			jb	check_next
match:
no_match:
			ret

TestMatch		ENDP

;   ------------------------------------------------------------------------

TestDynalink		PROC	NEAR PRIVATE

;   Given that the hard-coded sequence has an INT 20h instruction, if the
;   candidate sequence also has an INT 20h instruction, then the four bytes
;   that come afterwards are certain to require an exact match.

			mov	ax,es:[di]
			cmp	ax,DYNALINK_OPCODE
			jnz	@f

			cmpsw
			cmpsd
			jmp	done

@@:

;   Another possibility is that a VxD service call in the candidate sequence
;   has already been resolved (by the VMM's dynamic linking machinery) into
;   an indirect near call.  In this case, just accept the six bytes of any
;   such call.

			cmp	ax,CALL_NEAR_IND_OPCODE
			jnz	done

			cmpsw
			cmpsd
			xor	eax,eax

done:
			ret

TestDynalink		ENDP

;   ************************************************************************

END

