
;   ************************************************************************
;   *			 pgalloc.asm - for wdeb386.com			   *
;   ************************************************************************

;   (C) Geoff Chappell 1995.  All rights reserved.

.NOLIST
  INCLUDE		standard.inc
.LIST

.NOLIST
  INCLUDE		match32.inc
  INCLUDE		segmodel.inc
.LIST

KEEP_TEXT32		SEGMENT WORD PUBLIC USE32 'KEEPCODE'
KEEP_TEXT32		ENDS

;   ========================================================================

JMP_SHORT_OPCODE	EQU	0EBh

JMP_SHORT		STRUCT
  opcode		db	JMP_SHORT_OPCODE
  disp			db	?
JMP_SHORT		ENDS

LEAVE_OPCODE		EQU	0C9h

;   ************************************************************************

.CODE			KEEP_TEXT32

;   A routine in the DEBUG VxD's ICODE segment, and which is used only for
;   the DebugVGA option, contains an assumption that _PageAllocate returns
;   with eax giving the address of the memory block.  This is true in
;   Windows 95.  In earlier versions, however, _PageAllocate returns a
;   handle in eax, not the address of the allocated memory block.

;   Observe that the routine is also unsatisfactory in its decision whether
;   to seek its memory allocation from the heap or in whole pages.  The
;   former is preferable if the amount of memory sought is small, but the
;   routine also uses the heap if the size is not a multiple of 4K.  It
;   would surely be better to round upwards and seek the memory in whole
;   pages.

GetVideoBuffer		PROC	NEAR PRIVATE

			push	ebp
			mov	ebp,esp
			mov	eax,[ebp + 08h]

			cmp	eax,00001000h
			jl	@f
			test	eax,00000FFFh
			jnz	@f

			push	00000009h
			push	00000000h
			push	00000000h
			push	00000000h
			sar	eax,0Ch
			push	00000000h
			push	00000000h
			push	00000001h
			push	eax
			call	UNKNOWN_RELOFF32	; _PageAllocate
PatchSite:
			add	esp,20h
EndPatchSite:
			jmp	done

@@:
			push	00000001h
			push	eax
			call	UNKNOWN_RELOFF32	; _HeapAllocate
			add	esp,08h

done:
			pop	ebp
			ret

SIZE_GETBUFFER_FRAGMENT =	OFFSET $ - OFFSET GetVideoBuffer
OFFSET_PATCH_SITE	=	OFFSET PatchSite - OFFSET GetVideoBuffer
SIZE_PATCH_SITE 	=	OFFSET EndPatchSite - OFFSET PatchSite
OFFSET_LEAVE_SITE	=	OFFSET done - OFFSET GetVideoBuffer

GetVideoBuffer		ENDP

;   ------------------------------------------------------------------------

;   To correct the problem, modify the code to take the memory block's
;   address from register edx instead of eax.

;   One way to arrange this is to patch the following instructions over the
;   ADD ESP,20h that follows the call to _PageAllocate.  The LEAVE
;   instruction realigns the stack and pops ebp, so the short jump must be
;   lengthened by one byte to skip the POP EBP at the routine's exit.

Fix			PROC	NEAR PRIVATE

			mov	eax,edx
			nop

SIZE_FIX		=	OFFSET $ - OFFSET Fix
.ERRE			SIZE_FIX EQ SIZE_PATCH_SITE

Fix			ENDP

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

.CODE			KEEP_TEXT

			EXTERN	FindMatch32:NEAR

FixPageAllocateBug	PROC	NEAR PUBLIC USES ecx bx

			mov	di,bx
			mov	si,OFFSET DGROUP:GetVideoBuffer
			mov	dx,SIZE_GETBUFFER_FRAGMENT
			call	FindMatch32
			jc	done

			add	ax,OFFSET_PATCH_SITE
			mov	di,ax

			mov	si,OFFSET DGROUP:Fix
			mov	cx,SIZE_FIX
			rep	movsb

			add	di,(OFFSET_LEAVE_SITE - \
					(OFFSET_PATCH_SITE + SIZE_PATCH_SITE))
			mov	byte ptr es:[di],LEAVE_OPCODE

			clc

done:
			ret

FixPageAllocateBug	ENDP

;   ************************************************************************

END

