
;   ************************************************************************
;   *			 switch-h.asm - for wdeb386.com 		   *
;   ************************************************************************

;   (C) Geoff Chappell 1995.  All rights reserved.

;   ========================================================================

.NOLIST
  INCLUDE		cpu.inc
  INCLUDE		standard.inc
.LIST

.NOLIST
  INCLUDE		match16.inc
  INCLUDE		segmodel.inc
.LIST

;   ========================================================================

JCOND_SHORT		STRUCT
  opcode		db	?
  disp			db	?
JCOND_SHORT		ENDS

JNZ_SHORT_OPCODE	EQU	75h
CALL_FAR_OPCODE 	EQU	9Ah

CALL_FAR16		STRUCT
  opcode		db	CALL_FAR_OPCODE
  target		dd	?
CALL_FAR16		ENDS

;   ************************************************************************

.CODE			KEEP_TEXT

;   When started as a DOS program with the /H switch, WDEB386.EXE is liable
;   to hang the computer after Windows exits.  The reason is shown in the
;   code fragments that follow.

;   Like many debuggers (but unlike earlier versions), WDEB386.EXE loads its
;   child program for execution via DOS function 4B01h.

LoadChild		PROC	NEAR PRIVATE

			mov	ax,4B01h
			int	21h

SIZE_LOAD_FRAGMENT	=	OFFSET $ - OFFSET LoadChild

LoadChild		ENDP

;   ------------------------------------------------------------------------

RestoreInt2Fh		PROC	NEAR PRIVATE

;   As WDEB386.EXE finishes as a DOS program, having at least attempted to
;   run the debuggee (loaded as above), it checks whether it hooked int 2Fh
;   to detect Windows' startup.  If so, it executes this fragment to unhook
;   the vector.

			lds	dx,cs:[MEMORY_REFERENCE]
PatchSite:
			mov	ax,252Fh
			int	21h
EndPatchSite:

;   If the /H switch was given, meaning that WDEB386 should not initialise
;   the debugger in real mode (but exist merely as a stub to ensure that
;   WIN386 will load the DEBUG VxD), then there is very little further
;   cleaning up to do.	The code jumps.

			cmp	byte ptr cs:[MEMORY_REFERENCE],00h
JnzAfterRestore::
			jnz	CallDebugExit

SIZE_INT_FRAGMENT	=	OFFSET JnzAfterRestore - OFFSET RestoreInt2Fh
OFFSET_PATCH_SITE	=	OFFSET PatchSite - OFFSET RestoreInt2Fh
SIZE_PATCH_SITE 	=	OFFSET EndPatchSite - OFFSET PatchSite

.ERRE			SIZE_PATCH_SITE EQ SIZEOF CALL_FAR16

RestoreInt2Fh		ENDP

;   ------------------------------------------------------------------------

CallDebugExit		PROC	NEAR PRIVATE

;   Unfortunately, the code takes the jump without having restored ds to
;   equal cs.  Thus, the following indirect far call (at the target of the
;   earlier jump) does not go to its intended destination (which will be a
;   RETF in the /H case) but will instead execute random code.

			call	dword ptr ds:[MEMORY_REFERENCE]

SIZE_CALL_FRAGMENT	=	OFFSET $ - OFFSET CallDebugExit

CallDebugExit		ENDP

;   ------------------------------------------------------------------------

;   The fix proposed here is to patch over the DOS call that restores the
;   int 2Fh vector.  The patch consists of a far call to the following fix
;   that executes the same DOS call but then reloads ds to equal the cs
;   expected later in WDEB386.EXE.

Fix			PROC	FAR PRIVATE

			mov	ax,252Fh
			int	21h

			push	bp
			mov	bp,sp
			mov	ds,(FAR_RETADDR PTR [bp + 02h]).stacked_cs
			pop	bp

			ret

Fix			ENDP

;   ========================================================================

			EXTERN	FindMatch16:NEAR

FixSwitchHBug		PROC	NEAR PUBLIC USES es di ecx

;   The debugger's DOS image consists of ECX bytes starting at ES:DI.  The
;   code concerned with the /h bug is expected to occur near the start of
;   this image.  Searching 8KB ought to suffice to find the bug without
;   imposing much of a penalty if the bug has already been corrected in the
;   file image.

			cmp	ecx,00002000h
			jb	@f
			mov	ecx,00002000h
@@:

;   Look first for the debugger's attempt to load the child program and then
;   for the attempt to restore the int 2Fh vector.

			mov	si,OFFSET LoadChild
			mov	dx,SIZE_LOAD_FRAGMENT
			call	FindMatch16
			jc	fail

			mov	si,OFFSET RestoreInt2Fh
			mov	dx,SIZE_INT_FRAGMENT
			call	FindMatch16
			jc	fail

			mov	bx,ax

;   Follow the JNZ instruction to its target.

			sub	cx,SIZEOF JCOND_SHORT
			jb	fail

			ASSUME	di:PTR JCOND_SHORT

			cmp	es:[di].opcode,JNZ_SHORT_OPCODE
                        jnz     fail

			movsx	ax,es:[di].disp
			add	di,SIZEOF JCOND_SHORT

			ASSUME	di:NOTHING

			sub	cx,ax
			jb	fail
			add	di,ax

;   If the JNZ target is the indirect far call through a variable addressed
;   with respect to ds, then conclude that this version of the WDEB386.EXE
;   code exhibits the /H bug (there having been no restoration of ds to
;   equal cs).

			mov	si,OFFSET CallDebugExit
			mov	dx,SIZE_CALL_FRAGMENT
			mov	cx,dx
			call	FindMatch16
			jc	fail

;   Prepare the far call at the patch site.

			mov	ax,cs
			shl	eax,10h
			mov	ax,OFFSET Fix

			lea	di,es:[bx + OFFSET_PATCH_SITE]
			mov	(CALL_FAR16 PTR es:[di]).opcode,CALL_FAR_OPCODE
			mov	(CALL_FAR16 PTR es:[di]).target,eax

ok:
			clc
			jmp	done

fail:
			stc

done:
			ret

FixSwitchHBug		ENDP

;   ************************************************************************

END

