
;   ************************************************************************
;   *			 vxddata.asm - for wdeb386.com			   *
;   ************************************************************************
                                 
;   (C) Geoff Chappell 1995.  All rights reserved.

;   ========================================================================

.NOLIST
  INCLUDE		ascii.inc
  INCLUDE		standard.inc
.LIST

.NOLIST
  INCLUDE		debobjs.inc
  INCLUDE		le.inc
  INCLUDE		mz.inc
  INCLUDE		segmodel.inc
.LIST

;   ========================================================================

FILE_AREA_INFO		STRUCT
  dwStart		dd	?
  pReviewProc		dw	?
FILE_AREA_INFO		ENDS

;   ************************************************************************

.CODE			KEEP_TEXT

ExamineVxDFileData	PROC	NEAR PUBLIC

			mov	si,OFFSET FileAreas
			mov	dx,NUM_FILE_AREAS
@@:
			cmp	eax,(FILE_AREA_INFO PTR [si]).dwStart
			jz	@f
			add	si,SIZEOF FILE_AREA_INFO
			dec	dx
			jnz	@b

			clc
			jmp	done

@@:
			call	(FILE_AREA_INFO PTR [si]).pReviewProc

done:
			ret

ExamineVxDFileData	ENDP

;   ========================================================================

ReviewMZHeader		PROC	NEAR PRIVATE
			ASSUME	bx:PTR MZ_HEADER

			cmp	cx,SIZEOF MZ_HEADER
			jb	fail

			cmp	es:[bx].wSignature,@StrToNum ('M', 'Z')
			jnz	fail

			mov	eax,es:[bx].pNewExeHeader
			mov	[Area_LEHeader].dwStart,eax

ok:
			clc
			jmp	done

fail:
			stc

done:
			ret

			ASSUME	bx:NOTHING
ReviewMZHeader		ENDP

;   ========================================================================

ReviewLEHeader		PROC	NEAR PRIVATE
			ASSUME	bx:PTR LE_HEADER

			cmp	cx,SIZEOF LE_HEADER
			jb	fail

			cmp	es:[bx].wSignature,@StrToNum ('L', 'E')
			jnz	fail

			add	eax,SIZEOF LE_HEADER
			mov	[Area_LEData].dwStart,eax

ok:
			clc
			jmp	done

fail:
			stc

done:
			ret

			ASSUME	bx:NOTHING
ReviewLEHeader		ENDP

;   ========================================================================

			EXTERN	FixDebugObjects:NEAR

ReviewLEData		PROC	NEAR PRIVATE

			sub	bx,SIZEOF LE_HEADER
			jb	fail
			add	cx,SIZEOF LE_HEADER

			ASSUME	bx:PTR LE_HEADER

			cmp	es:[bx].wSignature,@StrToNum ('L', 'E')
			jnz	fail

;   Note which object table entry corresponds to which of the expected
;   objects in the DEBUG VxD.

			call	IdentifyObjects
			jc	fail

;   Note the file offsets of pages expected to be relevant to the bug-fixing
;   exercise.

			mov	si,[ObjTabEntries].lcode
			mov	eax,00000001h
			call	FindPage
			jc	fail

			mov	[Area_LCODE].dwStart,eax

			mov	si,[ObjTabEntries].icode
			mov	eax,00000001h
			call	FindPage
			jc	fail

			mov	[Area_ICODE].dwStart,eax

			call	FixDebugObjects

ok:
			clc
			jmp	done

fail:
			stc

done:
			ret

			ASSUME	bx:NOTHING, si:NOTHING
ReviewLEData		ENDP

;   ------------------------------------------------------------------------

IdentifyObjects 	PROC	NEAR PRIVATE
			ASSUME	bx:PTR LE_HEADER

;   Locate the Object Table.

			mov	esi,es:[bx].pObjTable
			cmp	esi,ecx
			jnb	fail

			add	si,bx
			ASSUME	si:PTR OBJ_TABLE_ENTRY

;   Expect exactly five objects in the DEBUG VxD.

			mov	edx,es:[bx].dwNumObjs
			cmp	edx,NUM_OBJECTS
			jnz	fail

			push	es
			push	ds
			pop	es
			mov	di,OFFSET ObjTabEntries
			push	cx
			mov	cx,dx
			xor	ax,ax
			rep	stosw
			pop	cx
			pop	es

;   Check that the Object Table (as read into memory) has sufficient space
;   for the expected five entries.

			mov	al,SIZEOF OBJ_TABLE_ENTRY
			mul	dl
			add	ax,si
			sub	ax,bx
			cmp	ax,cx
			jnb	fail

			xor	dx,dx

;   Match the entries to the expected objects.

next_obj:
			mov	eax,es:[si].dwFlags

			test	ax,OBJ_USE32
			jz	obj_16

obj_32:
			mov	di,OBJECTS.lcode
			test	ax,OBJ_DISCARDABLE
			jz	@f

			mov	di,OBJECTS.icode
			jmp	@f

obj_16:
			mov	di,OBJECTS.rcode
			test	ax,OBJ_PRELOAD
			jz	@f

			mov	di,OBJECTS.dcode
			test	ax,OBJ_EXECUTEABLE
			jnz	@f

			mov	di,OBJECTS.ddata

@@:
			mov	ax,si
			xchg	ax,word ptr [ObjTabEntries + di]
			or	ax,ax
			jnz	fail

			inc	dx
			mov	word ptr [ObjNums + di],dx

			add	si,SIZEOF OBJ_TABLE_ENTRY
			cmp	dx,NUM_OBJECTS
			jb	next_obj

;   Check that all five expected objects are accounted for - and only those
;   five.

			push	es
			push	ds
			pop	es
			mov	di,OFFSET ObjTabEntries
			push	cx
			mov	cx,NUM_OBJECTS
			xor	ax,ax
			repnz	scasw
			pop	cx
			pop	es
			jz	fail

ok:
			clc
			jmp	done

fail:
			stc

done:
			ret

			ASSUME	bx:NOTHING, si:NOTHING
IdentifyObjects 	ENDP

;   ------------------------------------------------------------------------

FindPage		PROC	NEAR PRIVATE
			ASSUME	bx:PTR LE_HEADER, si:PTR OBJ_TABLE_ENTRY

;   Given the 1-based number of a page within an object, calculate the
;   corresponding file offset (if any).

;   Begin by determining the 1-based number of the page within the whole
;   VxD.

			or	eax,eax
			jz	fail
			dec	eax
			add	eax,es:[si].dwFirstPage
			or	eax,eax
			jz	fail

;   Locate the page table.

			mov	edi,es:[bx].pPageTable
			cmp	edi,ecx
			jnb	fail
			add	di,bx
			jc	fail

;   The page table consists of four byte entries for the successive pages in
;   the VxD.

			dec	eax
			shl	eax,2

			cmp	eax,0000FFFFh
			ja	fail
			add	di,ax
			jc	fail

;   Check that the data read into memory extends far enough to hold the
;   four-byte entry for the page.

			mov	ax,di
			add	ax,00000004h
			sub	ax,bx
			cmp	ax,cx
			jnb	fail

;   The page has a physical image in the file iff the last byte in the entry
;   is zero.

			cmp	byte ptr es:[di + 03h],00h
			jnz	fail

;   The 1-based number of the physical page within the VxD image on disk is
;   a quirky mixture of the first three bytes.

			movzx	ax,byte ptr es:[di]
			shl	eax,10h
			mov	ah,es:[di + 01h]
			mov	al,es:[di + 02h]

			or	eax,eax
			jz	fail
			dec	eax

;   Return the corresponding file position.

			mul	dword ptr es:[bx].dwPageSize
			add	eax,es:[bx].pPageData

			clc
			jmp	done

fail:
			stc

done:
			ret

			ASSUME	bx:NOTHING, si:NOTHING
FindPage		ENDP

;   ========================================================================

			EXTERN	FixInt22hJmpTable:NEAR

ReviewLCODE		PROC	NEAR PRIVATE

			call	FixInt22hJmpTable
			clc
			ret

ReviewLCODE		ENDP

;   ========================================================================

			EXTERN	FixPageAllocateBug:NEAR
			EXTERN	FixRefdataInitBug:NEAR

ReviewICODE		PROC	NEAR PRIVATE

			call	FixRefdataInitBug
			call	FixPageAllocateBug
			clc
			ret

ReviewICODE		ENDP

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

.CODE			KEEP_DATA

FileAreas		LABEL	FILE_AREA_INFO
  Area_MZHeader 	FILE_AREA_INFO	{00000000h, OFFSET ReviewMZHeader}
  Area_LEHeader 	FILE_AREA_INFO	{?, OFFSET ReviewLEHeader}
  Area_LEData		FILE_AREA_INFO	{?, OFFSET ReviewLEData}
  Area_LCODE		FILE_AREA_INFO	{?, OFFSET ReviewLCODE}
  Area_ICODE		FILE_AREA_INFO	{?, OFFSET ReviewICODE}

NUM_FILE_AREAS		=	(OFFSET $ - OFFSET FileAreas) \
					/ SIZEOF FILE_AREA_INFO

			PUBLIC	ObjTabEntries
ObjTabEntries		OBJECTS {}
			PUBLIC	ObjNums
ObjNums 		OBJECTS {}

			EXTERN	wWinVer:WORD

;   ************************************************************************

END

