
;   ************************************************************************
;   *			   win.asm - for wdeb386.com			   *
;   ************************************************************************
                                 
;   (C) Geoff Chappell 1995.  All rights reserved.

;   ========================================================================

.NOLIST
  INCLUDE		standard.inc
.LIST

.NOLIST
  INCLUDE		segmodel.inc
.LIST

;   ************************************************************************

.CODE			KEEP_TEXT

Int2Fh			PROC	FAR PRIVATE

			cmp	ax,1605h
			jz	winstart
			cmp	ax,1606h
			jz	winexit

pass:
			jmp	cs:[lpOrgInt2Fh]

winstart:

;   Detection of Windows' startup is required only for fixing problems with
;   the DEBUG VxD embedded in the WDEB386.EXE file.  Interest is therefore
;   only in Windows enhanced mode.

			test	dx,0001h
			jnz	pass

;   The extent and nature of the bug fixing depends on which version of
;   Windows runs.

			mov	cs:[wWinVer],di

;   Save the current PSP.  If the same DOS program that announces the
;   Windows startup also opens the WDEB386.EXE file and reads from the VxD
;   component, it will be assumed that the DOS program is WIN386 (and that
;   it is loading the DEBUG VxD).

			push	bx
			push	ax
			mov	ah,51h
			int	21h
			mov	cs:[spWin386PSP],bx
			pop	ax
			pop	bx

			jmp	pass

winexit:
			test	dx,0001h
			jnz	pass

;   When Windows enhanced mode exits, reset the code that detects WIN386
;   loading the DEBUG VxD.

			mov	cs:[spWin386PSP],0000h

			jmp	pass

fail:
			mov	cx,0FFFFh
			iret

Int2Fh			ENDP

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

.CODE

InitDetectWin		PROC	NEAR PUBLIC

			mov	ax,352Fh
			int	21h

			mov	word ptr [lpOrgInt2Fh],bx
			mov	word ptr [lpOrgInt2Fh + 02h],es

			mov	dx,OFFSET Int2Fh
			mov	ax,252Fh
			int	21h

			ret

InitDetectWin		ENDP

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

.CODE			KEEP_TEXT

ExitDetectWin		PROC	NEAR PUBLIC USES ds

			lds	dx,[lpOrgInt2Fh]
			mov	ax,252Fh
			int	21h

			ret

ExitDetectWin		ENDP

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

.CODE			KEEP_DATA

lpOrgInt2Fh		dd	?

			PUBLIC	spWin386PSP
spWin386PSP		dw	0000h

			PUBLIC	wWinVer
wWinVer 		dw	0000h

;   ************************************************************************

END

