
/*  ************************************************************************  *
 *				   listview.h				      *
 *  ************************************************************************  */

/*  This header exists only for a rough definition of the IListView
    interface, as implemented by List-View controls in Windows Vista but not
    documented by Microsoft.

    Copyright (C) 2008. Geoff Chappell. All rights reserved.  */

/*  ========================================================================  */

#include    <windows.h>
#include    <objbase.h>
#include    <commctrl.h>

/*  ************************************************************************  */
/*  Forward references	*/

/*  Follow Microsoft's practices - in the hope of not frustrating anyone who
    uses this header with an SDK in which Microsoft does define IListView.  */

#ifndef __IListView_FWD_DEFINED__
#define __IListView_FWD_DEFINED__
typedef interface IListView IListView;
#endif

#ifndef __ILVRange_FWD_DEFINED__
#define __ILVRange_FWD_DEFINED__
typedef interface ILVRange ILVRange;
#endif

#ifndef __IOwnerDataCallback_FWD_DEFINED__
#define __IOwnerDataCallback_FWD_DEFINED__
typedef interface IOwnerDataCallback IOwnerDataCallback;
#endif

#ifndef __ISubItemCallback_FWD_DEFINED__
#define __ISubItemCallback_FWD_DEFINED__
typedef interface ISubItemCallback ISubItemCallback;
#endif

/*  ========================================================================  */
/*  IListView  */

#if _WIN32_WINNT >= 0x0600

#ifndef __IListView_INTERFACE_DEFINED__
#define __IListView_INTERFACE_DEFINED__

MIDL_INTERFACE ("2FFE2979-5928-4386-9CDB-8E1F15B72FB4")
IListView : public IOleWindow
{
    virtual HRESULT STDMETHODCALLTYPE GetImageList (INT, HIMAGELIST *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetImageList (INT, HIMAGELIST, HIMAGELIST *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetBackgroundColor (COLORREF *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetBackgroundColor (COLORREF) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetTextColor (COLORREF *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetTextColor (COLORREF) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetTextBackgroundColor (COLORREF *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetTextBackgroundColor (COLORREF) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetHotLightColor (COLORREF *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetHotLightColor (COLORREF) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetItemCount (int *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetItemCount (int, DWORD) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetItem (LVITEMW *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetItem (LVITEMW * const) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetItemState (int, int, ULONG, ULONG *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetItemState (int, int, ULONG, ULONG) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetItemText (INT, INT, PWSTR, INT) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetItemText (int, int, PCWSTR) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetBackgroundImage (LVBKIMAGEW *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetBackgroundImage (LVBKIMAGEW * const) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetFocusedColumn (INT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetSelectionFlags (ULONG, ULONG) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetSelectedColumn (INT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetSelectedColumn (int) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetView (DWORD *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetView (DWORD) = 0;
    virtual HRESULT STDMETHODCALLTYPE InsertItem (LVITEMW * const, int *) = 0;
    virtual HRESULT STDMETHODCALLTYPE DeleteItem (int) = 0;
    virtual HRESULT STDMETHODCALLTYPE DeleteAllItems (VOID) = 0;
    virtual HRESULT STDMETHODCALLTYPE UpdateItem (int) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetItemRect (LVITEMINDEX, int, RECT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetSubItemRect (LVITEMINDEX, INT, INT, RECT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE HitTestSubItem (LVHITTESTINFO *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetIncrSearchString (PWSTR, INT, INT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetItemSpacing (BOOL, INT *, INT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetIconSpacing (INT, INT, INT *, INT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetNextItem (LVITEMINDEX, ULONG, LVITEMINDEX *) = 0;
    virtual HRESULT STDMETHODCALLTYPE FindItem (LVITEMINDEX, LVFINDINFOW const *, LVITEMINDEX *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetSelectionMark (LVITEMINDEX *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetSelectionMark (LVITEMINDEX, LVITEMINDEX *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetItemPosition (LVITEMINDEX, POINT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetItemPosition (int, POINT const *) = 0;
    virtual HRESULT STDMETHODCALLTYPE ScrollView (int, int) = 0;
    virtual HRESULT STDMETHODCALLTYPE EnsureItemVisible (LVITEMINDEX, BOOL) = 0;
    virtual HRESULT STDMETHODCALLTYPE EnsureSubItemVisible (LVITEMINDEX, INT) = 0;
    virtual HRESULT STDMETHODCALLTYPE EditSubItem (LVITEMINDEX, INT) = 0;
    virtual HRESULT STDMETHODCALLTYPE RedrawItems (int, int) = 0;
    virtual HRESULT STDMETHODCALLTYPE ArrangeItems (int) = 0;
    virtual HRESULT STDMETHODCALLTYPE RecomputeItems (INT) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetEditControl (HWND *) = 0;
    virtual HRESULT STDMETHODCALLTYPE EditLabel (LVITEMINDEX, PCWSTR, HWND *) = 0;
    virtual HRESULT STDMETHODCALLTYPE EditGroupLabel (INT) = 0;
    virtual HRESULT STDMETHODCALLTYPE CancelEditLabel (VOID) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetEditItem (LVITEMINDEX *, INT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE HitTest (LVHITTESTINFO *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetStringWidth (PCWSTR, int *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetColumn (int, LVCOLUMNW *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetColumn (int, LVCOLUMNW * const) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetColumnOrderArray (int, int *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetColumnOrderArray (int, int const *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetHeaderControl (HWND *) = 0;
    virtual HRESULT STDMETHODCALLTYPE InsertColumn (int, LVCOLUMNW * const, int *) = 0;
    virtual HRESULT STDMETHODCALLTYPE DeleteColumn (int) = 0;
    virtual HRESULT STDMETHODCALLTYPE CreateDragImage (int, POINT const *, HIMAGELIST *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetViewRect (RECT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetClientRect (BOOL, RECT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetColumnWidth (INT, INT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetColumnWidth (int, int) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetCallbackMask (ULONG *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetCallbackMask (ULONG) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetTopIndex (int *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetCountPerPage (int *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetOrigin (POINT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetSelectedCount (INT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SortItems (BOOL, LPARAM, PFNLVCOMPARE) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetExtendedStyle (DWORD *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetExtendedStyle (DWORD, DWORD, DWORD *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetHoverTime (UINT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetHoverTime (UINT, UINT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetToolTip (HWND *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetToolTip (HWND, HWND *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetHotItem (LVITEMINDEX *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetHotItem (LVITEMINDEX, LVITEMINDEX *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetHotCursor (HCURSOR *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetHotCursor (HCURSOR, HCURSOR *) = 0;
    virtual HRESULT STDMETHODCALLTYPE ApproximateViewRect (int, INT *, INT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetRangeObject (INT, ILVRange *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetWorkAreas (int, RECT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetWorkAreas (int, RECT const *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetWorkAreaCount (INT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE ResetEmptyText (VOID) = 0;
    virtual HRESULT STDMETHODCALLTYPE EnableGroupView (INT) = 0;
    virtual HRESULT STDMETHODCALLTYPE IsGroupViewEnabled (BOOL *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SortGroups (PFNLVGROUPCOMPARE, PVOID) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetGroupInfo (INT, INT, LVGROUP *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetGroupInfo (INT, INT, LVGROUP * const) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetGroupRect (BOOL, int, INT, RECT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetGroupState (INT, ULONG, ULONG *) = 0;
    virtual HRESULT STDMETHODCALLTYPE HasGroup (int, BOOL *) = 0;
    virtual HRESULT STDMETHODCALLTYPE InsertGroup (int, LVGROUP * const, int *) = 0;
    virtual HRESULT STDMETHODCALLTYPE RemoveGroup (INT) = 0;
    virtual HRESULT STDMETHODCALLTYPE InsertGroupSorted (LVINSERTGROUPSORTED const *, int *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetGroupMetrics (LVGROUPMETRICS *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetGroupMetrics (LVGROUPMETRICS * const) = 0;
    virtual HRESULT STDMETHODCALLTYPE RemoveAllGroups (VOID) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetFocusedGroup (INT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetGroupCount (INT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetOwnerDataCallback (IOwnerDataCallback *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetTileViewInfo (LVTILEVIEWINFO *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetTileViewInfo (LVTILEVIEWINFO * const) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetTileInfo (LVTILEINFO *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetTileInfo (LVTILEINFO * const) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetInsertMark (LVINSERTMARK *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetInsertMark (LVINSERTMARK const *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetInsertMarkRect (RECT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetInsertMarkColor (COLORREF *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetInsertMarkColor (COLORREF, COLORREF *) = 0;
    virtual HRESULT STDMETHODCALLTYPE HitTestInsertMark (POINT const *, LVINSERTMARK *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetInfoTip (LVSETINFOTIP * const) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetOutlineColor (COLORREF *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetOutlineColor (COLORREF, COLORREF *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetFrozenItem (INT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetFrozenItem (INT, INT) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetFrozenSlot (RECT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetFrozenSlot (INT, POINT const *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetViewMargin (RECT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetViewMargin (RECT const *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetKeyboardSelected (LVITEMINDEX) = 0;
    virtual HRESULT STDMETHODCALLTYPE MapIndexToId (INT, INT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE MapIdToIndex (INT, INT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE IsItemVisible (LVITEMINDEX, BOOL *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetGroupSubsetCount (INT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetGroupSubsetCount (INT) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetVisibleSlotCount (INT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetColumnMargin (RECT *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetSubItemCallback (ISubItemCallback *) = 0;
    virtual HRESULT STDMETHODCALLTYPE GetVisibleItemRange (LVITEMINDEX *, LVITEMINDEX *) = 0;
    virtual HRESULT STDMETHODCALLTYPE SetTypeAheadFlags (UINT, UINT) = 0;
};

#endif	// #ifndef __IListView_INTERFACE_DEFINED__

#endif	// #if _WIN32_WINNT >= 0x0600

/*  ************************************************************************  */

