<!--

/*  **********************************************  */
/*  For inclusion in the HEAD of the "banner" page  */
/*  **********************************************  */

/*  *************  */
/*  Configuration  */

/*  The following names need to match BANNER.CSS and BANNER.HTM.  */

/*  The banner is an arrangement of named blocks (each with an ID). Whether 
    each block is a DIV or a cell in a table is something we prefer not to 
    depend on. One important block presents the available subwebs and is 
    distinguished by the following ID. It needs scripting support so that 
    the current subweb gets highlighted.  */

var sSubwebs = "Subwebs";

/*  The subwebs block is some sort of list in which each item (or cell) 
    represents either a single subweb or a group of them. The distinction is 
    known to the style sheet through class names. One item that represents a 
    single subweb can have its class name altered so that it is specially 
    presented as the current subweb.  */

var sSubweb = "Subweb";
var sCurrent = "Current";

/*  *******  */
/*  Subwebs  */

function GetCurrentSubwebLink (CurrentSubweb)
{
    var subwebs = window.document.getElementById (sSubwebs);
    if (subwebs == null) return null;

    var links = subwebs.getElementsByTagName ("A");
    var numlinks = links.length;
    for (var n = 0; n < numlinks; n ++) {
        var link = links [n];
        if (link.href == CurrentSubweb) return link;
    }
    return null;
}

function ShowAsCurrentSubweb (CurrentSubwebLink)
{
    for (var x = CurrentSubwebLink; x != null; x = x.parentNode) {
        var classname = x.className;
        if (classname == null) continue;
        var classes = classname.split (" ");
        var numclasses = classes.length;
        for (var n = 0; n < numclasses; n ++) {
            if (classes [n] == sSubweb) {
                x.className = sCurrent + " " + classname;
                return true;
            }
        }
    }
    return false;
}

/*  As a temporary (and really ugly) provision, pending discovery of how to 
    specify the colour for flat frame borders in browsers other than 
    Internet Explorer, change the style sheet's specification of colour for 
    the current subweb (which is supposed to match the frame border).  */

function EnsureCurrentSubwebStyle ()
{
    var nav = window.navigator;
    if (nav == null) return;
    var appname = nav.appName;
    if (appname == "Microsoft Internet Explorer") return;
    var colour = null;
    switch (appname) {

        /*  Observation (only) suggests that the Netscape browsers either 
            show no border or make it white.  */

        case "Netscape": {          // Firefox, Safari and Chrome 
            colour = "#FFFFFF";
            break;
        }

        /*  Opera is seen to use whatever is the system's ButtonFace colour 
            (and so is Internet Explorer when "bordercolor" is not set).  */

        case "Opera": {
            colour = "ButtonFace";
            break;
        }
    }
    if (colour == null) return;

    var sheet = GetLastStyleSheet ();
    if (sheet != null) {
        var selector = "#" + sSubwebs + " ." + sCurrent + " a";
        var rule = "background-color:" + colour;
        AppendRule (sheet, selector, rule);
        AppendRule (sheet, selector + ":hover", rule);
    }
}

function OnLoad (Event)                         // onload 
{
    /*  Compose a URL for the current subweb. If there's a matching link, 
        show it as current.  */
    
    var subwebfile = PathAppend (GetSubwebPath (null), sDefaultFilename);
    var link = GetCurrentSubwebLink (new LocalUrl (subwebfile).toString ());
    if (link != null) {
        EnsureCurrentSubwebStyle ();
        ShowAsCurrentSubweb (link);
    }
}

/*  *********************  */
/*  Global initialisation  */

/*  The banner page is meant to be seen in a frameset which presents the 
    page in a FRAME as context for a document that is being shown 
    concurrently in another frame.  */

if (sTopWindow != null 
        && !IsBadHostName () 
        && !IsLowScriptSupport ()
        && IsInFrameset (sBannerFrame)) {

    /*  When the banner has loaded, identify the link for the current subweb 
        and make it distinct.  */

    window.onload = OnLoad;

    /*  Ensure that all links from the banner to another page at this site 
        will redraw the frameset in the top window and pick up whatever 
        needs to be preserved of the TOC state.  */

    window.document.onclick = RedirectClickedLink;
}

/*  Copyright  2007-2016. Geoff Chappell. All rights reserved.  */

//-->