<!--

/*  ************************************************************  */
/*  For inclusion in the head of any document page that wants it  */
/*  ************************************************************  */

/*  This script eases the inclusion of expandable digressions in a document. 
    Each example is some arbitrary amount of HTML which is not wanted in the 
    ordinary flow but which the reader is invited to reveal, if in the mind 
    for diversion. 

    All the HTML for the example goes into a DIV. If scripting is enabled, 
    the DIV is hidden and a "show" button appears in its place. Clicking the 
    button reveals the DIV and the "show" turns to "hide". 

    The example may have its own user-interface name, for use in relevant 
    buttons. Set this as the "id" of the DIV.  */

/*  *************  */
/*  Configuration  */

var sBoxClass = "Digression";

/*  **************  */
/*  Implementation  */

/*  Build two buttons, one to show and one to hide, and insert them 
    immediately ahead of the DIV. Only one button is to be displayed at 
    any one time.  */

function CreateButton (Text, ShowOrHide)
{
    var document = window.document;
    var button = document.createElement ("BUTTON");
    button.appendChild (document.createTextNode (Text));
    button.style.display = ShowOrHide ? "block" : "none";
    return button;
}

function ActivateButton (Button, ShowOrHide, OtherButton, Div)
{
    Button.onclick = function ()
    {
        Button.style.display = "none";
        OtherButton.style.display = "block";
        OtherButton.focus ();
        Div.style.display = ShowOrHide ? "block" : "none";
    }
}

function CreateBox (Div)
{
    var name = Div.className;
    var id = Div.id;
    if (id != null && id != "") name += " (" + id + ")";

    var oshow = CreateButton ("Show " + name, true);
    var ohide = CreateButton ("Hide " + name, false);

    Div.style.display = "none";

    var parent = Div.parentNode;
    parent.insertBefore (oshow, Div);
    parent.insertBefore (ohide, Div);

    ActivateButton (oshow, true, ohide, Div);
    ActivateButton (ohide, false, oshow, Div);
}

function ConfigureBoxes (Event)
{
    var divs = window.document.getElementsByTagName ("DIV");
    var numdivs = divs.length;
    for (var n = 0; n < numdivs; n ++) {
        var div = divs [n];
        if (div.className == sBoxClass) CreateBox (div);
    }
}

if (IsBadHostName () || IsLowScriptSupport ()) {
    /*  do nothing  */
}
else if (IsInFrameset (sDocFrame)) {
    RegisterEventHandler (window, "load", ConfigureBoxes);
}

/*  Copyright  2008-2011. Geoff Chappell. All rights reserved.  */

//-->