<!--

/*  ************************************************************  */
/*  For inclusion in the head of any document page that wants it  */
/*  ************************************************************  */

/*  This script eases the inclusion of expandable demonstrations in a 
    document. Each demonstration is some arbitrary amount of script which is 
    not wanted in the ordinary flow of text but which the reader is invited 
    to reveal and run, if in the mind for diversion. 

    A DIV with the class name "Demonstration" may have an ID that describes 
    the example. 

    The DIV is to contain a SCRIPT block, disguised as a PRE block with the 
    class name "Script", plus explanatory text for readers who do not have 
    scripting enabled. The ID of the script block names the function to run 
    for the demonstration.  */

/*  *************  */
/*  Configuration  */

var sDemoClass = "Demonstration";
var sScriptClass = "Script";
var sSourceClass = "source";

/*  **************  */
/*  Implementation  */

function CreateButton (Text, ShowOrHide)
{
    var doc = window.document;
    var button = doc.createElement ("BUTTON");
    if (button != null) {
        button.style.display = ShowOrHide ? "block" : "none";
        button.appendChild (doc.createTextNode (Text));
    }
    return button;
}

function CreateExample (Div)
{
    /*  We must have a single PRE block which contains code for the script.  */

    var blocks = Div.getElementsByTagName ("PRE");
    var numblocks = blocks.length;
    if (numblocks != 1) return false;
    var block = blocks [0];

    /*  In this block must be one function to call - and we must be able to 
        make a script object whose code is the block's text.  */

    var id = block.id;
    if (id == null) return false;
    var scriptfunc = new Function (id + " ();");
    if (scriptfunc == null) return false;

    var oscript = window.document.createElement ("SCRIPT");
    if (oscript == null) return false;
    oscript.type = "text/javascript";
    oscript.text = GetInnerText (block);

    /*  We must have buttons to control the demonstration.  */

    var demoname = "Demonstration";
    var id = Div.id;
    if (id != null && id != "") demoname += "(" + id + ")";

    var oshow = CreateButton ("Show " + demoname, true);
    if (oshow == null) return false;
    var ohide = CreateButton ("Hide " + demoname, false);
    if (ohide == null) return false;
    var orun = CreateButton ("Run " + demoname, false);
    if (orun == null) return false;

    Div.style.display = "none";
    block.className = sSourceClass;

    var parent = Div.parentNode;
    parent.insertBefore (oshow, Div);
    parent.insertBefore (ohide, Div);
    parent.insertBefore (orun, Div);
    
    oshow.onclick = function ()
    {
        oshow.style.display = "none";
        ohide.style.display = "inline";
        ohide.focus ();
        orun.style.display = "inline";
        Div.appendChild (oscript);
        Div.style.display = "block";
    };

    ohide.onclick = function ()
    {
        oshow.style.display = "block";
        oshow.focus ();
        ohide.style.display = "none";
        orun.style.display = "none";
        Div.style.display = "none";
        Div.removeChild (oscript);
    };

    orun.onclick = scriptfunc;

    return true;
}

function ConfigureExamples (Event)              // onload 
{
    var divs = window.document.getElementsByTagName ("DIV");
    var numdivs = divs.length;
    for (var n = 0; n < numdivs; n ++) {
        var div = divs [n];
        if (div.className == sDemoClass) CreateExample (div);
    }
}

if (IsBadHostName () || IsLowScriptSupport ()) {
    /*  do nothing  */
}
else if (IsInFrameset (sDocFrame)) {
    RegisterEventHandler (window, "load", ConfigureExamples);
}

/*  Copyright  2007-2011. Geoff Chappell. All rights reserved.  */

//-->