<!--

/*  **********************************************  */
/*  For inclusion in the HEAD of the "viewer" page  */
/*  **********************************************  */

/*  In a previous implementation, scripts running in "document" pages would 
    load a "viewer" page that contained a frameset in which to re-present 
    the document page with a banner and table of contents (TOC). The 
    document at 

        http://hostname/path/document.htm?search#hash 

    would load 

        http://hostname/viewer.htm?doc=path/document.htm&bm=hash&search 

    To support other sites' links to this site's VIEWER.HTM now that the 
    implementation has changed, this script reverses the redirection.  */

/*  **********  */
/*  Validation  */

function IsPlausibleDocArgument (Doc)
{
    /*  All paths that are valid for redirection will begin with a 
        lower-case letter.  */

    var first = Doc.charAt (0);
    return 'a' <= first && first <= 'z';
}

/*  *********************  */
/*  Global Initialisation  */

/*  Do nothing if we seem to be in someone else's presentation, e.g., a 
    search engine's cache, or if we don't have some minimal scripting 
    support.  */

if (sTopWindow == null || IsBadHostName () || IsLowScriptSupport ()) {
    /*  do nothing  */
}
else if (window != window.top) {

    /*  When we are (somehow) being presented in another window, force our 
        way to the top.  */

    window.top.location.replace (window.location);
}
else {

    /*  Ordinarily, replace "viewer.htm" with whatever is indicated in the 
        "doc" argument, remove the "doc" argument, change the "bm" argument 
        to a bookmark, keep everything else in the search string, and then 
        redirect the browser.  */

    var search = new ParsedSearch (window.location.search);
    var pathname = search.Delete (sDocumentArgumentName);
    if (pathname != null && IsPlausibleDocArgument (pathname)) {
        var hash = search.Delete (sBookmarkArgumentName);
        window.location.replace (new LocalUrl (pathname, search, hash));
    }
}

/*  Copyright  2007-2016. Geoff Chappell. All rights reserved.  */

//-->