
;   ************************************************************************
;   *	      control.asm - for demonstration of hooking BlockDev	   *
;   ************************************************************************

.386P

;   The DDK include files ignore differences in case.  Force the assembler
;   into case-insensitive mode even without the corresponding command line
;   switch.

			OPTION	CASEMAP:NOTPUBLIC

;   This VxD is compatible with Windows 3.10.  We do not want macros defined
;   in any included file (such as VMM.INC) to generate any code that might
;   call services introduced for Windows 95 when the VxD is being run under
;   Windows 3.10.  On the other hand, we do want the right (even though we
;   happen not to exercise it here) to use features that are new to
;   Windows 95 should our VxD be loaded under Windows 95.

DDK_VERSION		EQU	0400h
WIN31COMPAT		EQU	1
WIN40SERVICES		EQU	1

;   Include files from the INC32 directory of the Windows 95 DDK

.NOLIST
  INCLUDE		vmm.inc
  INCLUDE		blockdev.inc
.LIST

;   The DDK include files disable the attractive feature of permitting
;   labels that are local to procedures.  Turn this feature on now.

			OPTION	SCOPED

;   ************************************************************************

;   To be able to hook disk access between BlockDev and a FastDisk driver,
;   we must hook the BlockDev_Register_Device service before any FastDisk
;   drivers call it.  The standard FastDisk driver, WDCTRL, registers during
;   Sys_Critical_Init.	We certainly must have a lower initialisation order
;   than WDCTRL - but this is not restrictive.

;   During Device_Init, potential clients of BlockDev may try to perform I/O
;   through BlockDev.  A BlockDev-hooking VxD that has hooked access to the
;   target device for this I/O may need to perform other I/O in order to
;   decide how to handle the client's request.  In general therefore, a
;   BlockDev-hooking VxD needs a lower initialisation order than any likely
;   BlockDev client.  The most noticeable BlockDev client is the PageFile
;   VxD, and its initialisation order is very low (18000000h).

;   A possibly troubling implication is that we must initialise before
;   BlockDev itself, BlockDev's initialisation order being fairly high at
;   40000000h.	At each stage of our initialisation, we can never depend on
;   BlockDev having already done its corresponding work.

;   It should not go unnoticed that Microsoft realised this conflict of
;   dependencies in choosing the initialisation order for the Windows 95
;   version of the IOS.  Although the IOS supersedes BlockDev, its
;   initialisation order is significantly lower at 17000000h, i.e., below
;   that of any IOS client.

Init_Order		=	IOS_INIT_ORDER + 00001000h

;   ************************************************************************

VxD_ICODE_SEG
			EXTERN	HookedBDRegDev:NEAR		; hook.asm
			EXTERN	InitIOHooking:NEAR		; iomgr.asm

OnSysCriticalInit	PROC	NEAR PRIVATE

;   Check that we are working with the Windows 3.10 BLOCKDEV or some VxD
;   that supersedes it (and which we hope will support us, since we don't
;   make use of any undocumented BLOCKDEV behaviour).  The main concern is
;   to decline to work with a Windows 3.0 VHD, which has the same VxD ID as
;   BLOCKDEV but supplies a very different VxD interface.

			VxDCall BlockDev_Get_Version
			jc	done
			cmp	eax,0000030Ah
			jb	done

;   Install our replacement for the BlockDev_Register_Device service.  It's
;   in another source file only so that it can be varied more easily to suit
;   the requirements of any particular project.

			mov	esi,OFFSET HookedBDRegDev
			call	InitIOHooking
			jc	done

			mov	[pOrgBDRegDev],esi

done:
			ret

OnSysCriticalInit	ENDP

VxD_ICODE_ENDS

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

VxD_IDATA_SEG
			PUBLIC	pOrgBDRegDev
pOrgBDRegDev		dd	?

VxD_IDATA_ENDS

;   ************************************************************************
;   Some necessary VxD features - a DDB in the locked data segment and a
;   Control Procedure in locked code

Declare_Virtual_Device	DISKHOOK, 1, 0, Control_Proc, , Init_Order

VxD_LOCKED_CODE_SEG

Control_Proc		PROC	NEAR PRIVATE

  Control_Dispatch	Sys_Critical_Init, OnSysCriticalInit
			clc
			ret

Control_Proc		ENDP

VxD_LOCKED_CODE_ENDS

;   ************************************************************************

END

