
;   ************************************************************************
;   *			    hook.asm - for VSD demo			   *
;   ************************************************************************

.386P

;   The DDK include files ignore differences in case.  Force the assembler
;   into case-insensitive mode even without the corresponding command line
;   switch.

			OPTION	CASEMAP:NOTPUBLIC

;   This VxD is compatible with Windows 3.10.  We do not want macros defined
;   in any included file (such as VMM.INC) to generate any code that might
;   call services introduced for Windows 95 when the VxD is being run under
;   Windows 3.10.  On the other hand, we do want the right (even though we
;   happen not to exercise it here) to use features that are new to
;   Windows 95 should our VxD be loaded under Windows 95.

DDK_VERSION		EQU	0400h
WIN31COMPAT		EQU	1
WIN40SERVICES		EQU	1

;   Include files from the INC32 directory of the Windows 95 DDK

.NOLIST
  INCLUDE		vmm.inc
  INCLUDE		blockdev.inc
.LIST

;   The DDK include files disable the attractive feature of permitting
;   labels that are local to procedures.  Turn this feature on now.

			OPTION	SCOPED

;   ************************************************************************

VxD_LOCKED_CODE_SEG
			EXTERN	IOHook:NEAR			; play.asm
VxD_LOCKED_CODE_ENDS

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

VxD_IDATA_SEG
			EXTERN	pOrgBDRegDev:DWORD		; control.asm
VxD_IDATA_ENDS

;   ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

VxD_ICODE_SEG
			EXTERN	HookDevice:NEAR

HookedBDRegDev		PROC	NEAR PUBLIC
			ASSUME	edi:PTR BlockDev_Device_Descriptor

;   This procedure replaces the BlockDev_Register_Device service during
;   initialisation.

;   ----

;   We are interested only in the registration of devices driven through
;   int 13h - and for this particular demonstration, only if the drive
;   number is 80h.

			test	[edi].BDD_Flags,BDF_Int13_Drive
			jz	pass

			cmp	[edi].BDD_Int_13h_Number,80h
			jnz	pass

;   Given that we have a drive that interests us, arrange to receive all
;   attempts at operations on that drive.  In effect, the IOHook routine
;   replaces the FastDisk driver's command procedure.

			push	esi
			mov	esi,OFFSET IOHook
			call	HookDevice
			pop	esi

pass:
			jmp	[pOrgBDRegDev]

HookedBDRegDev		ENDP

VxD_ICODE_ENDS

;   ************************************************************************

END

