
;   ************************************************************************
;   *				   iomgr.asm				   *
;   ************************************************************************

.386P

;   The DDK include files ignore differences in case.  Force the assembler
;   into case-insensitive mode even without the corresponding command line
;   switch.

			OPTION	CASEMAP:NOTPUBLIC

;   This VxD is compatible with Windows 3.10.  We do not want macros defined
;   in any included file (such as VMM.INC) to generate any code that might
;   call services introduced for Windows 95 when the VxD is being run under
;   Windows 3.10.  On the other hand, we do want the right (even though we
;   happen not to exercise it here) to use features that are new to
;   Windows 95 should our VxD be loaded under Windows 95.

DDK_VERSION		EQU	0400h
WIN31COMPAT		EQU	1
WIN40SERVICES		EQU	1

;   Include files from the INC32 directory of the Windows 95 DDK

.NOLIST
  INCLUDE		vmm.inc
  INCLUDE		blockdev.inc
.LIST

;   The DDK include files disable the attractive feature of permitting
;   labels that are local to procedures.  Turn this feature on now.

			OPTION	SCOPED

;   ************************************************************************

;   Structures with which we support BlockDev hooking

BDD_HOOK                STRUCT
  pBDD			dd	?
  pOrgCmdProc		dd	?
BDD_HOOK		ENDS

BCB_HOOK		STRUCT
  pBCB			dd	?
  pCallBack		dd	?
  dwRefData		dd	?
BCB_HOOK		ENDS

VxD_LOCKED_DATA_SEG

;   Handles to formal lists in which we keep instances of those structures.

BCBHookList		dd	?
BDDHookList		dd	?

;   Address of routine that handled the BlockDev_Command_Complete service
;   before we hooked it.

pOrgBDCmdCplt		dd	?

VxD_LOCKED_DATA_ENDS

;   ========================================================================

VxD_LOCKED_CODE_SEG

ForwardIORequest	PROC	NEAR PUBLIC USES eax
			ASSUME	esi:PTR BlockDev_Command_Block
			ASSUME	edi:PTR BlockDev_Device_Descriptor

;   This procedure passes the I/O request described by the BlockDev Command
;   Block at ESI towards the FastDisk driver for the device described by the
;   BlockDev Device Descriptor at EDI.

;   If there is no such driver, the procedure returns with a set carry flag
;   (not that this should ever happen).

;   The procedure makes no attempt to preserve registers that might be
;   changed by the lower-level command procedure.

;   ----

;   Find the BDD_HOOK entry in which we saved the address of this storage
;   device's original command procedure.

			push	esi

			mov	esi,[BDDHookList]
			VMMCall List_Get_First
@@:
			or	eax,eax
			jz	fail

			cmp	(BDD_HOOK PTR [eax]).pBDD,edi
			jz	found

			VMMCall List_Get_Next
			jmp	@b

found:

;   Having found the BDD_HOOK entry for the storage unit, call the original
;   command procedure, making sure that esi and edi still address the
;   BlockDev Command Block and Device Descriptor respectively.

			pop	esi
			call	(BDD_HOOK PTR [eax]).pOrgCmdProc
			clc
			jmp	done

fail:
			pop	esi
			stc
done:
			ret

			ASSUME	esi:NOTHING, edi:NOTHING
ForwardIORequest	ENDP

;   ========================================================================

CallWhenIOComplete	PROC	NEAR PUBLIC USES eax
			ASSUME	esi:PTR BlockDev_Command_Block
			ASSUME	edi:PTR BlockDev_Device_Descriptor

;   This procedure registers the routine addressed by EBX as one that the
;   I/O system should call (back) when the I/O operation described by the
;   BlockDev Command Block at ESI completes.  The contents of register EDX
;   are stored to serve as reference data for the callback routine.

;   The procedure indicates success or failure via the carry flag.  All
;   registers are preserved.

;   The callback routine will be entered with ESI and EDI addressing the
;   BlockDev Command Block and BlockDev Device Descriptor respectively, and
;   with the reference data in EDX.

;   ----

;   Obtain a BCB_HOOK entry in which to save the address of the procedure
;   that is to be called (back) on completion of the I/O request.

			push	esi
			mov	esi,[BCBHookList]
			VMMCall List_Allocate
			pop	esi
			jc	done

			mov	(BCB_HOOK PTR [eax]).pBCB,esi
			mov	(BCB_HOOK PTR [eax]).pCallBack,ebx
			mov	(BCB_HOOK PTR [eax]).dwRefData,edx

;   Attach the list entry so that it can be found again when the command
;   actually does complete.

			push	esi
			mov	esi,[BCBHookList]
			VMMCall List_Attach
			pop	esi
			clc

done:
			ret

			ASSUME	esi:NOTHING, edi:NOTHING
CallWhenIOComplete	ENDP

;   ========================================================================

ForwardIOCompletion	PROC	NEAR PUBLIC
			ASSUME	esi:PTR BlockDev_Command_Block
			ASSUME	edi:PTR BlockDev_Device_Descriptor

;   This procedure invokes the BlockDev_Command_Complete service to start
;   the sequence by which the VxD that requested the I/O may learn of the
;   request's completion (including its failure).

			VxDCall BlockDev_Command_Complete
			clc
			ret

			ASSUME	esi:NOTHING, edi:NOTHING
ForwardIOCompletion	ENDP

;   ------------------------------------------------------------------------

HookedBDCmdCplt 	PROC	NEAR PRIVATE
			ASSUME	esi:PTR BlockDev_Command_Block
			ASSUME	edi:PTR BlockDev_Device_Descriptor

;   If there is no BCB_HOOK structure for the command block, then make the
;   service behave as if it were not hooked.

			mov	ebx,esi

			mov	esi,[BCBHookList]
			VMMCall List_Get_First

@@:
			or	eax,eax
			jz	pass

			cmp	(BCB_HOOK PTR [eax]).pBCB,ebx
			jz	found

			VMMCall List_Get_Next
			jmp	@b

pass:
			mov	esi,ebx
			jmp	[pOrgBDCmdCplt]

found:

;   If, however, a callback procedure is registered, note the procedure's
;   address and the reference data, then detach and deallocate the BCB_HOOK
;   structure before calling the callback.

			push	(BCB_HOOK PTR [eax]).pCallBack
			mov	edx,(BCB_HOOK PTR [eax]).dwRefData

			VMMCall List_Remove
			VMMCall List_Deallocate

			mov	esi,ebx

			ret

			ASSUME	esi:NOTHING, edi:NOTHING
HookedBDCmdCplt 	ENDP

VxD_LOCKED_CODE_ENDS

;   ************************************************************************

VxD_ICODE_SEG

HookDevice		PROC	NEAR PUBLIC USES esi edx eax

;   This routine hooks the procedure addressed by ESI into the flow of I/O
;   commands for the device described by the BlockDev Device Descriptor at
;   EDI.  The routine indicates success or failure via the carry flag.

;   ----

;   Swap the device's current command procedure for our own, saving the
;   original in a BDD_HOOK structure so that whenever we intercept I/O
;   requests for this device, we will be able to pass them on.

			mov	edx,esi

			mov	esi,[BDDHookList]
			VMMCall List_Allocate
			jc	done

			ASSUME	eax:PTR BDD_HOOK
			mov	[eax].pBDD,edi

			xchg	edx,[edi].BDD_Command_Proc
			mov	[eax].pOrgCmdProc,edx

			VMMCall List_Attach

			clc
done:
			ret

HookDevice		ENDP

;   ========================================================================

InitIOHooking		PROC	NEAR PUBLIC USES edx ecx

;   This routine initialises the I/O control functions implemented in this
;   file.  The caller must pass in ESI the address of a replacement for the
;   BlockDev_Register_Device service.  The routine returns with esi
;   addressing whatever code previously handled that service.

;   Success or failure is indicated via the carry flag.  No attempt is made
;   at preserving registers.

;   ----

;   Create formal lists for the two types of hook.

			mov	edx,esi

			mov	eax,LF_Async
			mov	ecx,SIZEOF BDD_HOOK
			VMMCall List_Create
			jc	done

			mov	[BDDHookList],esi

			mov	eax,LF_Async OR LF_Alloc_Error
			mov	ecx,SIZEOF BCB_HOOK
			VMMCall List_Create
			jc	destroy1

			mov	[BCBHookList],esi

;   Hook the BlockDev_Command_Complete service, which we use to control the
;   flow of completed I/O commands from the FastDisk driver up to the
;   BlockDev client that first presented the command.

			mov	esi,OFFSET HookedBDCmdCplt
			GetVxDServiceOrdinal eax,BlockDev_Command_Complete
			VMMCall Hook_Device_Service
			jc	destroy2

			mov	[pOrgBDCmdCplt],esi

;   Hook the BlockDev_Register_Device service so that we will learn of all
;   devices that get supported by FastDisk drivers and handled through
;   BlockDev.  This must be done before any FastDisk driver registers a
;   device - which is why we do this during Sys_Critical_Init, and indeed,
;   early in Sys_Critical_Init.

			mov	esi,edx
			GetVxDServiceOrdinal eax,BlockDev_Register_Device
			VMMCall Hook_Device_Service
			jnc	done

unhook1:
			mov	esi,[pOrgBDCmdCplt]
			GetVxDServiceOrdinal eax,BlockDev_Command_Complete
			VMMCall Hook_Device_Service

destroy2:
			mov	esi,[BCBHookList]
			VMMCall List_Destroy

destroy1:
			mov	esi,[BDDHookList]
			VMMCall List_Destroy
			stc
done:
			ret

InitIOHooking		ENDP

VxD_ICODE_ENDS

;   ************************************************************************

END

