
;   ************************************************************************
;   *				    play.asm				   *
;   ************************************************************************

.386P

;   The DDK include files ignore differences in case.  Force the assembler
;   into case-insensitive mode even without the corresponding command line
;   switch.

			OPTION	CASEMAP:NOTPUBLIC

;   This VxD is compatible with Windows 3.10.  We do not want macros defined
;   in any included file (such as VMM.INC) to generate any code that might
;   call services introduced for Windows 95 when the VxD is being run under
;   Windows 3.10.  On the other hand, we do want the right (even though we
;   happen not to exercise it here) to use features that are new to
;   Windows 95 should our VxD be loaded under Windows 95.

DDK_VERSION		EQU	0400h
WIN31COMPAT		EQU	1
WIN40SERVICES		EQU	1

;   Include files from the INC32 directory of the Windows 95 DDK

.NOLIST
  INCLUDE		vmm.inc
  INCLUDE		blockdev.inc
.LIST

;   The DDK include files disable the attractive feature of permitting
;   labels that are local to procedures.  Turn this feature on now.

			OPTION	SCOPED

;   ************************************************************************

VxD_LOCKED_CODE_SEG

			EXTERN	CallWhenIOComplete:NEAR 	; iomgr.asm
			EXTERN	ForwardIOCompletion:NEAR	; iomgr.asm
			EXTERN	ForwardIORequest:NEAR		; iomgr.asm

IOHook			PROC	NEAR PUBLIC USES edi esi ebx
			ASSUME	esi:PTR BlockDev_Command_Block
			ASSUME	edi:PTR BlockDev_Device_Descriptor

;   The intention is to make a harmless change to the appearance of one
;   specific sector on the hooked drive.  We also refuse write access to
;   that sector.  No other BlockDev commands are of interest in this toy.

			cmp	[esi].BD_CB_Command,BDC_Read
			jz	@f
			cmp	[esi].BD_CB_Command,BDC_Write
			jnz	pass

@@:

;   The BlockDev Command Block provides the starting sector and sector count
;   for the read/write operation.

			mov	edx,[esi].BD_CB_Sector
			mov	ecx,[esi].BD_CB_Count

;   The specific sector of interest is the one in which most machines have a
;   DOS boot sector - the first sector on the disk's second track.

			mov	eax,[edi].BDD_Num_Sec_Per_Track

;   If the range for the read/write does not overlap the test sector, just
;   let the operation go through.

			sub	eax,edx
			jb	pass
			cmp	eax,ecx
			jnb	pass

;   Given an overlap, simulate an error if BlockDev indicates an attempt to
;   write over the sector.

			cmp	[esi].BD_CB_Command,BDC_Read
			jz	read

write:
			mov	ax,BDS_Invalid_Command
			jmp	simulate_error

read:

;   Given an attempt to read a range of sectors including the test sector,
;   let the operation go through, but only after arranging to be called back
;   when the operation has completed.

;   Since we have handy the offset in sectors from the start of the range to
;   the test sector, we may as well save it as reference data so that it
;   will still be handy when the callback routine executes (whenever that
;   may be).

			mov	ebx,OFFSET ReadDone
			mov	edx,eax
			call	CallWhenIOComplete
			jnc	pass

			mov	ax,BDS_Device_Error	; should never happen
			jmp	simulate_error

pass:
			call	ForwardIORequest
			jnc	done

			mov	ax,BDS_Device_Error	; should never happen

simulate_error:

;   To simulate an error, load the Command Block's status field with an
;   error code and then spread the "news" that the requested I/O operation
;   has completed (albeit unsuccessfully).

			mov	[esi].BD_CB_Cmd_Status,ax
			call	ForwardIOCompletion

done:
			ret

IOHook			ENDP

;   ------------------------------------------------------------------------

ReadDone		PROC	NEAR C PRIVATE USES edi esi ebx

			cmp	[esi].BD_CB_Cmd_Status,BDS_First_Error_Code
			jnb	done

;   Find the space in the I/O request's buffer where the caller will expect
;   to see the contents of the test sector.  (Note that the offset in
;   sectors from the start of the range read to the test sector is available
;   as reference data passed in EDX.)

;   In the usual case, this calculation is the obvious:  multiply the sector
;   index by the sector size in bytes and add to the starting address of the
;   buffer.

;   There is a complication, however.  In the scatter-gather case, the
;   caller supplies not just one buffer, but many, leaving it to BlockDev
;   or a FastDisk driver (or perhaps even the hardware) to distribute the
;   sectors into the many buffers.  The Command Block field that would
;   usually provide the buffer address gives instead the address of an array
;   of BlockDev_Scatter_Gather descriptors.

			mov	eax,edx
			mov	ebx,[esi].BD_CB_Buffer_Ptr

			test	[esi].BD_CB_Flags,BDCF_Scatter_Gather
			jz	calculate

			ASSUME	ebx:PTR BlockDev_Scatter_Gather

;   Each descriptor corresponds to a buffer - in the same order as sectors
;   have been read from disk.  Just follow the array to find which buffer
;   contains the sector of interest.

@@:
			cmp	eax,[ebx].BD_SG_Count
			jb	@f

			sub	eax,[ebx].BD_SG_Count
			add	ebx,SIZE BlockDev_Scatter_Gather
			jmp	@b

@@:
			mov	ebx,[ebx].BD_SG_Buffer_Ptr
			ASSUME	ebx:NOTHING

calculate:
			mul	[edi].BDD_Sector_Size
			add	ebx,eax

;   Now that we have the data that was read from the test sector, modify it
;   so that our test programs can confirm that we have hooked access to the
;   disk.

			call	PlayWithImage

done:

;   Keep passing on the news of the I/O operation's completion.  Eventually,
;   this will get all the way to whichever VxD requested the I/O.

			call	ForwardIOCompletion
			ret

			ASSUME	esi:NOTHING, edi:NOTHING
ReadDone		ENDP

;   ------------------------------------------------------------------------

PlayWithImage		PROC	NEAR PRIVATE

;   Check first that EBX points to a sector with the expected appearance (a
;   DOS boot sector).

			cmp	word ptr [ebx + 01FEh],0AA55h
			jnz	fail

			mov	eax,[ebx]

			cmp	al,0E9h
			jz	@f
			cmp	al,0EBh
			jnz	fail
			shr	eax,10h
			cmp	al,90h
			jnz	fail

@@:

;   Search for the word "disk" and toggle the case of its last two letters.

;   I am grateful to Ralph Shnelvar for pointing out to me that my first
;   coding of the for loop - with ecx = 0200h on entry - could access memory
;   beyond the end of the buffer (which we are already presuming holds at
;   least the data from a 0200h-byte sector).

			mov	ecx,01FDh
next:
			mov	eax,[ebx]
			and	eax,NOT 20202020h
			cmp	eax,"KSID"
			jz	play

			inc	ebx
			loop	next

			jmp	fail

play:
			xor	dword ptr [ebx],20200000h
			jmp	done

fail:
			stc
done:
			ret

PlayWithImage		ENDP

VxD_LOCKED_CODE_ENDS

;   ************************************************************************

END

