
/*  ************************************************************************  *
 *				   intpack.h				      *
 *  ************************************************************************  */

#ifndef __INTPACK_H__
#define __INTPACK_H__

#include    "standard.h"

/*  A structure for accessing registers presented as arguments to functions
    declared with the _interrupt keyword in Microsoft C  */

#pragma pack (1)

#define GeneralRegister(r) \
union { \
    WORD r##x; \
    struct { \
	BYTE r##l, r##h; \
    }; \
} \

struct INTPACK {
    WORD es;
    WORD ds;
    WORD di;
    WORD si;
    WORD bp;
    WORD sp;
    GeneralRegister (b);
    GeneralRegister (d);
    GeneralRegister (c);
    GeneralRegister (a);
    WORD ip;
    WORD cs;
    WORD flags;
};

#pragma pack ()

#endif	// ifndef __INTPACK_H__

/*  ************************************************************************  */

