
/*  ************************************************************************  *
 *	   memstrat.c - C functions to control DOS memory allocation	      *
 *  ************************************************************************  */

/*  Adapted on 16th July 1997 from version first published with "DOS
    Internals" (ISBN 0-201-60835-9)  */

#include    "memstrat.h"
#include    "standard.h"

#pragma warning (disable : 4035 4704)

WORD _dos_getstrategy (WORD *stratptr)
{
    WORD strategy;

    _asm {
	    mov     ax,5800h
	    int     21h
	    jc	    done
	    mov     strategy,ax
    }
    *stratptr = strategy;
    _asm {
	    xor     ax,ax
	done:
    }
}

WORD _dos_setstrategy (WORD strategy)
{
    _asm {
	    mov     bx,strategy
	    mov     ax,5801h
	    int     21h
	    jc	    done
	    xor     ax,ax
	done:
    }
}

WORD _dos_getumblink (BOOL *umblinkptr)
{
    BOOL umblink;

    _asm {
	    mov     ax,5802h
	    int     21h
	    jc	    done
	    xor     ah,ah
	    mov     umblink,ax
    }
    *umblinkptr = umblink;
    _asm {
	    xor     ax,ax
	done:
    }
}

WORD _dos_setumblink (BOOL umblink)
{
    _asm {
	    mov     bx,umblink
	    mov     ax,5803h
	    int     21h
	    jc	    done
	    xor     ax,ax
	done:
    }
}

#pragma warning (default : 4035 4704)

/*  ************************************************************************  */

