
;   ************************************************************************
;   *		 AEP.INC - Windows for Workgroups 3.11 version		   *
;   ************************************************************************

;   This file presents symbolic information from the AEP.INC header that
;   Microsoft provides with the Windows 95 DDK, but adapted to match the
;   IOS implementation in Windows for Workgroups 3.11.

;   ========================================================================

AEP_INITIALIZE			EQU	0000h
AEP_SYSTEM_CRIT_SHUTDOWN	EQU	0001h
AEP_BOOT_COMPLETE		EQU	0002h
AEP_CONFIG_DCB			EQU	0003h
AEP_UNCONFIG_DCB		EQU	0004h
AEP_IOP_TIMEOUT 		EQU	0005h
AEP_DEVICE_INQUIRY		EQU	0006h
AEP_HALF_SEC			EQU	0007h
AEP_1_SEC			EQU	0008h
AEP_2_SECS			EQU	0009h
AEP_4_SECS			EQU	000Ah
AEP_ASSOCIATE_DCB		EQU	000Ch
AEP_REAL_MODE_HANDOFF		EQU	000Dh
AEP_SYSTEM_SHUTDOWN		EQU	000Eh

;   The Windows for Workgroups 3.11 IOS does not allow for an AEP_lgn field
;   in every packet.

AEPHDR				STRUCT
  AEP_func			dw	?
  AEP_result			dw	?
  AEP_ddb			dd	?
AEPHDR				ENDS

AEP_SUCCESS			EQU	0000h
AEP_FAILURE			EQU	0FFFFh

AEP_bi_init			STRUCT
  AEP_bi_i_hdr			AEPHDR	{}
				db	05h DUP (?)
  AEP_lgn			db	?
  AEP_bi_reference_data 	dd	?
  AEP_bi_flags			db	?
  AEP_bi_i_max_target		db	?
  AEP_bi_i_max_lun		db	?
  AEP_bi_i_dcb			dd	?
				db	08h DUP (?)
AEP_bi_init			ENDS

AEP_inquiry_device		STRUCT
  AEP_i_d_hdr			AEPHDR	{}
				db	05h DUP (?)
  AEP_lgn			db	?
  AEP_i_d_dcb			dd	?
AEP_inquiry_device		ENDS

AEP_boot_done			STRUCT
  AEP_b_d_hdr			AEPHDR	{}
AEP_boot_done			ENDS

AEP_dcb_config			STRUCT
  AEP_d_c_hdr			AEPHDR	{}
				db	05h DUP (?)
  AEP_lgn			db	?
  AEP_d_c_dcb			dd	?
AEP_dcb_config			ENDS

AEP_dcb_unconfig		STRUCT
  AEP_d_u_hdr			AEPHDR	{}
				db	06h DUP (?)
  AEP_d_u_dcb			dd	?
AEP_dcb_unconfig		ENDS

AEP_io_timeout_occurred 	STRUCT
  AEP_i_t_o_hdr 		AEPHDR	{}
  AEP_i_t_o_iop 		dd	?
AEP_io_timeout_occurred 	ENDS

AEP_sys_shutdown		STRUCT
  AEP_s_s_hdr			AEPHDR	{}
AEP_sys_shutdown		ENDS

AEP_sys_crit_shutdown		STRUCT
  AEP_s_c_s_hdr 		AEPHDR	{}
AEP_sys_crit_shutdown		ENDS

AEP_assoc_dcb			STRUCT
  AEP_a_d_hdr			AEPHDR	{}
  AEP_a_d_pdcb			dd	?
  AEP_a_d_drives		dd	?
AEP_assoc_dcb			ENDS

AEP_rm_handoff			STRUCT
  AEP_r_m_h_hdr 		AEPHDR	{}
AEP_rm_handoff			ENDS

;   ************************************************************************

