
;   ************************************************************************
;   *		 DCB.INC - Windows for Workgroups 3.11 version		   *
;   ************************************************************************

;   This file presents symbolic information from the DCB.INC header that
;   Microsoft provides with the Windows 95 DDK, but adapted to match the
;   IOS implementation in Windows for Workgroups 3.11.

;   ========================================================================

;   The DCB_cd_entry structure is the same for both IOS versions.

DCB_cd_entry		STRUCT
  DCB_cd_io_address	dd	?
  DCB_cd_flags		dd	?
  DCB_cd_ddb		dd	?
  DCB_cd_next		dd	?
  DCB_cd_expan_off	dw	?
			db	?
  DCB_cd_lgn		db	?
DCB_cd_entry		ENDS

;   The Windows for Workgroups 3.11 DCB begins with the DCB_BLOCKDEV.  Note
;   that the DCB_device_flags are identical with the BDD_Flags in this
;   version.

DCB_BLOCKDEV			STRUCT
  DCB_BDD_Next			dd	?
  DCB_BDD_BD_Major_Version	db	BDD_BD_Major_Ver
  DCB_BDD_BD_Minor_Version	db	BDD_BD_Minor_Ver
  DCB_BDD_Device_SubType	db	?
  DCB_BDD_Int_13h_Number	db	?
  UNION
    DCB_BDD_flags		dd	?
    DCB_device_flags		dd	?
  ENDS
  DCB_BDD_Name_Ptr		dd	?
  DCB_apparent_sector_cnt	dd	2 DUP (?)
  DCB_apparent_blk_size 	dd	?
  DCB_apparent_head_cnt 	dd	?
  DCB_apparent_cyl_cnt		dd	?
  DCB_apparent_spt		dd	?
  DCB_BDD_Sync_Cmd_Proc 	dd	?
  DCB_BDD_Command_Proc		dd	?
  DCB_BDD_Hw_Int_Proc		dd	0
  DCB_BDP_Cmd_Queue_Ascending	dd	?
  DCB_BDP_Cmd_Queue_Descending	dd	?
  DCB_BDP_Current_Flags 	dd	?
  DCB_BDP_Int13_Param_Ptr	dd	?
  DCB_BDP_Current_Command	dd	?
  DCB_BDP_Current_Position	dd	2 DUP (?)
  DCB_BDP_Reserved		dd	5 DUP (?)
  DCB_fastdisk_bdd		dd	?
DCB_BLOCKDEV	ENDS

;   The other fields of the Windows for Workgroups 3.11 DCB are best handled
;   as (almost) all belonging to a DCB_COMMON.

DCB_COMMON			STRUCT
  DCB_physical_dcb		dd	?
  DCB_expansion_length		dd	?
  DCB_ptr_cd			dd	?
  DCB_next_dcb			dd	?
  DCB_next_logical_dcb		dd	?
  DCB_next_ddb_dcb		dd	?
				db	04h DUP (?)
  DCB_device_type		db	?
  DCB_bus_type			db	?
  DCB_drive_lttr_equiv		db	?
  DCB_unit_number		db	?
  DCB_bus_number		db	?
  DCB_max_sg_elements		db	?
				db	0Ah DUP (?)
  DCB_scsi_target_id		db	?
  DCB_scsi_lun			db	?
  DCB_scsi_hba			db	?
				db	03h DUP (?)
  DCB_inquiry_flags		db	24h DUP (?)
				db	08h DUP (?)
  DCB_apparent_blk_shift	db	?
  DCB_current_unit		db	?
				db	04h DUP (?)
  DCB_vrp_ptr			dd	?
				db	04h DUP (?)
  DCB_access_timer		db	?
				db	?
  DCB_dmd_flags 		dd	?
  DCB_q_algo			db	?
  DCB_sig			dw	?
				db	08h DUP (?)
  DCB_Exclusive_VM		dd	?
  DCB_max_xfer_len		dd	?
  DCB_queue_freeze		db	?
DCB_COMMON			ENDS

DCB				STRUCT
  DCB_bdd			DCB_BLOCKDEV {}
  DCB_actual_sector_cnt 	dd	2 DUP (?)
  DCB_actual_blk_size		dd	?
  DCB_actual_head_cnt		dd	?
  DCB_actual_cyl_cnt		dd	?
  DCB_actual_spt		dd	?
  DCB_cmn			DCB_COMMON {}
DCB				ENDS

DCB_q_fi_fo			EQU	00h
DCB_q_sort			EQU	01h

DCB_type_disk			EQU	00h
DCB_type_floppy 		EQU	0Ah

DCB_BUS_ESDI			EQU	00h
DCB_BUS_SCSI			EQU	01h

DCB_DEV_QUE_DESCEND		EQU	00200000h
DCB_DEV_PHYSICAL		EQU	00008000h
DCB_DEV_LOGICAL 		EQU	00004000h
DCB_DEV_RMM			EQU	00002000h
DCB_DEV_MUST_CONFIGURE		EQU	00000400h
DCB_DEV_I13_IN_PROGRESS 	EQU	00000040h
DCB_DEV_SERIAL_CMD		EQU	00000010h
DCB_DEV_WRITEABLE		EQU	00000002h
DCB_DEV_INT13_DRIVE		EQU	00000001h

DCB_dmd_do_a_b_toggling 	EQU	00002000h
DCB_dmd_phys_sgd_ptr		EQU	00001000h
DCB_dmd_phys_sgd		EQU	00000800h
DCB_dmd_dword_align		EQU	00000400h
DCB_dmd_word_align		EQU	00000200h

;   ************************************************************************

